/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.DataUtilities;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.Query;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.shapefile.ShapefileDumper;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.SchemaException;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;

public class ShapefileExample {
    public void use() throws Exception {
        File file = new File("example.shp");
        HashMap<String, URL> map = new HashMap<String, URL>();
        map.put("url", file.toURI().toURL());
        DataStore dataStore = DataStoreFinder.getDataStore(map);
        String typeName = dataStore.getTypeNames()[0];
        SimpleFeatureSource source = dataStore.getFeatureSource(typeName);
        IncludeFilter filter = Filter.INCLUDE;
        FeatureCollection collection = source.getFeatures((Filter)filter);
        try (FeatureIterator features = collection.features();){
            while (features.hasNext()) {
                SimpleFeature feature = (SimpleFeature)features.next();
                System.out.print(feature.getID());
                System.out.print(": ");
                System.out.println(feature.getDefaultGeometryProperty().getValue());
            }
        }
    }

    public void create() throws Exception {
        ShapefileDataStoreFactory factory = new ShapefileDataStoreFactory();
        File file = new File("my.shp");
        Map<String, URL> map = Collections.singletonMap("url", file.toURI().toURL());
        DataStore myData = factory.createNewDataStore(map);
        SimpleFeatureType featureType = DataUtilities.createType((String)"my", (String)"geom:Point,name:String,age:Integer,description:String");
        myData.createSchema((FeatureType)featureType);
    }

    public void read() throws Exception {
        File file = new File("my.shp");
        FileDataStore myData = FileDataStoreFinder.getDataStore((File)file);
        SimpleFeatureSource source = myData.getFeatureSource();
        SimpleFeatureType schema = (SimpleFeatureType)source.getSchema();
        Query query = new Query(schema.getTypeName());
        query.setMaxFeatures(1);
        SimpleFeatureCollection collection = source.getFeatures(query);
        try (FeatureIterator features = collection.features();){
            while (features.hasNext()) {
                SimpleFeature feature = (SimpleFeature)features.next();
                System.out.println(feature.getID() + ": ");
                for (Property attribute : feature.getProperties()) {
                    System.out.println("\t" + attribute.getName() + ":" + attribute.getValue());
                }
            }
        }
    }

    public void dump() throws Exception {
        ShapefileDumper dumper = new ShapefileDumper(new File("./target/demo"));
        dumper.setCharset(Charset.forName("ISO-8859-15"));
        int maxSize = 0x6400000;
        dumper.setMaxDbfSize((long)maxSize);
        dumper.setMaxDbfSize((long)maxSize);
        SimpleFeatureCollection fc = this.getFeatureCollection();
        dumper.dump(fc);
    }

    private SimpleFeatureCollection getFeatureCollection() throws SchemaException {
        SimpleFeatureType featureType = DataUtilities.createType((String)"my", (String)"geom:Point,name:String,age:Integer,description:String");
        return new ListFeatureCollection(featureType);
    }
}

