/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FileDataStoreFactorySpi;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.Transaction;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.util.URLs;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;

public class DataExamples {
    SimpleFeatureSource alter(SimpleFeatureCollection collection, String typename, SimpleFeatureType featureType, final List<AttributeDescriptor> newTypes) {
        try {
            SimpleFeatureTypeBuilder buildType = new SimpleFeatureTypeBuilder();
            buildType.init(featureType);
            buildType.setName(typename);
            buildType.addAll(newTypes);
            final SimpleFeatureType schema = buildType.buildFeatureType();
            final MemoryDataStore memory = new MemoryDataStore();
            memory.createSchema(schema);
            collection.accepts(new FeatureVisitor(){

                public void visit(Feature feature) {
                    SimpleFeatureBuilder builder = new SimpleFeatureBuilder(schema);
                    builder.init((SimpleFeature)feature);
                    for (AttributeDescriptor descriptor : newTypes) {
                        builder.add(descriptor.getDefaultValue());
                    }
                    SimpleFeature newFeature = builder.buildFeature(feature.getIdentifier().getID());
                    memory.addFeature(newFeature);
                }
            }, null);
            return memory.getFeatureSource(typename);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataStore exportToShapefile(MemoryDataStore memory, String typeName, File directory) throws IOException {
        ContentFeatureSource featureSource = memory.getFeatureSource(typeName);
        SimpleFeatureType ft = (SimpleFeatureType)featureSource.getSchema();
        String fileName = ft.getTypeName();
        File file = new File(directory, fileName + ".shp");
        HashMap<String, URL> creationParams = new HashMap<String, URL>();
        creationParams.put("url", URLs.fileToUrl((File)file));
        FileDataStoreFactorySpi factory = FileDataStoreFinder.getDataStoreFactory((String)"shp");
        DataStore dataStore = factory.createNewDataStore(creationParams);
        dataStore.createSchema((FeatureType)ft);
        SimpleFeatureStore featureStore = (SimpleFeatureStore)dataStore.getFeatureSource(typeName);
        try (DefaultTransaction t = new DefaultTransaction();){
            SimpleFeatureCollection collection = featureSource.getFeatures();
            featureStore.addFeatures((FeatureCollection)collection);
            t.commit();
        }
        return dataStore;
    }

    private void fixWFSTypeName(SimpleFeatureType ft) {
        StringBuilder builder = new StringBuilder(ft.getTypeName());
        for (int i = 0; i < builder.length(); ++i) {
            if (Character.isLetterOrDigit(builder.charAt(i))) continue;
            builder.setCharAt(i, '_');
        }
        String fileName = builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataStore exportToShapefile2(MemoryDataStore memory, String typeName, File directory) throws IOException {
        ContentFeatureSource featureSource = memory.getFeatureSource(typeName);
        SimpleFeatureType ft = (SimpleFeatureType)featureSource.getSchema();
        String fileName = ft.getTypeName();
        File file = new File(directory, fileName + ".shp");
        HashMap<String, URL> creationParams = new HashMap<String, URL>();
        creationParams.put("url", URLs.fileToUrl((File)file));
        FileDataStoreFactorySpi factory = FileDataStoreFinder.getDataStoreFactory((String)"shp");
        DataStore dataStore = factory.createNewDataStore(creationParams);
        dataStore.createSchema((FeatureType)ft);
        SimpleFeatureStore featureStore = (SimpleFeatureStore)dataStore.getFeatureSource(typeName);
        try (DefaultTransaction t = new DefaultTransaction();){
            SimpleFeatureCollection collection = featureSource.getFeatures();
            FeatureWriter writer = dataStore.getFeatureWriter(typeName, (Transaction)t);
            SimpleFeatureIterator iterator = collection.features();
            try {
                while (iterator.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)iterator.next();
                    SimpleFeature aNewFeature = (SimpleFeature)writer.next();
                    aNewFeature.setAttributes(feature.getAttributes());
                    writer.write();
                }
            }
            catch (IOException eek) {
                eek.printStackTrace();
                try {
                    t.rollback();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return dataStore;
    }
}

