/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.cql;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import org.apache.commons.io.FileUtils;
import org.geotools.cql.ECQLExamples;
import org.geotools.data.DataUtilities;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.util.URLs;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

final class DataExamples
extends ECQLExamples {
    private static SimpleFeature COUNTRY = null;
    private static SimpleFeature CITY = null;

    private DataExamples() {
    }

    public static SimpleFeature getInstanceOfCity() throws Exception {
        if (CITY != null) {
            return CITY;
        }
        SimpleFeatureType type = DataUtilities.createType((String)"Location", (String)"geometry:Point:srid=4326,cityName:String,over65YearsOld:Double,under18YearsOld:Double,population:Integer,lastEarthQuake:Date");
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(type);
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
        Point point = geometryFactory.createPoint(new Coordinate(-17.2053, 11.9517));
        featureBuilder.add((Object)point);
        featureBuilder.add((Object)"New York");
        featureBuilder.add((Object)22.6);
        featureBuilder.add((Object)13.4);
        featureBuilder.add((Object)19541453);
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        featureBuilder.add((Object)dateFormatter.parse("1737-11-30T01:30:00Z"));
        CITY = featureBuilder.buildFeature(null);
        return CITY;
    }

    public static SimpleFeature getInstanceOfCountry() throws Exception {
        if (COUNTRY != null) {
            return COUNTRY;
        }
        SimpleFeatureType type = DataUtilities.createType((String)"Location", (String)"geometry:Polygon:srid=4326,countryName:String,population:Integer,principalMineralResource:String");
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(type);
        WKTReader reader = new WKTReader();
        MultiPolygon geometry = (MultiPolygon)reader.read(DataExamples.usaGeometry());
        featureBuilder.add((Object)geometry);
        featureBuilder.add((Object)"USA");
        featureBuilder.add((Object)307006550);
        featureBuilder.add((Object)"oil");
        COUNTRY = featureBuilder.buildFeature(null);
        return COUNTRY;
    }

    private static String usaGeometry() {
        try {
            return FileUtils.readFileToString((File)URLs.urlToFile((URL)DataExamples.class.getResource("usa-geometry.wkt")), (String)"UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        try {
            System.out.println(DataExamples.getInstanceOfCountry());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

