/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage;

import java.awt.image.RenderedImage;
import java.io.File;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.geometry.DirectPosition2D;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CoverageExamples {
    void exampleGridFormat() throws Exception {
        File file = new File("test.tiff");
        AbstractGridFormat format = GridFormatFinder.findFormat((Object)file);
        AbstractGridCoverage2DReader reader = format.getReader((Object)file);
        GridCoverage2D coverage = reader.read(null);
    }

    void exampleGridCoverageFactory() throws Exception {
        Envelope referencedEnvelope = null;
        RenderedImage bufferedImage = null;
        GridCoverageFactory factory = new GridCoverageFactory();
        GridCoverage2D coverage = factory.create((CharSequence)"GridCoverage", bufferedImage, referencedEnvelope);
    }

    void exampleGridCoverageUsing() throws Exception {
        File file = new File("test.tiff");
        AbstractGridFormat format = GridFormatFinder.findFormat((Object)file);
        AbstractGridCoverage2DReader reader = format.getReader((Object)file);
        GridCoverage2D coverage = reader.read(null);
        CoordinateReferenceSystem crs = coverage.getCoordinateReferenceSystem2D();
        Envelope env = coverage.getEnvelope();
        RenderedImage image = coverage.getRenderedImage();
    }

    void exampleGridCoverageDirect() throws Exception {
        double x = 0.0;
        double y = 0.0;
        CoordinateReferenceSystem crs = null;
        File file = new File("test.tiff");
        AbstractGridFormat format = GridFormatFinder.findFormat((Object)file);
        AbstractGridCoverage2DReader reader = format.getReader((Object)file);
        GridCoverage2D coverage = reader.read(null);
        DirectPosition2D position = new DirectPosition2D(crs, x, y);
        double[] sample = (double[])coverage.evaluate((DirectPosition)position);
        sample = coverage.evaluate((DirectPosition)position, sample);
    }
}

