/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.brewer;

import java.awt.Color;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.geotools.brewer.color.ColorBrewer;
import org.geotools.brewer.color.StyleGenerator;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.function.Classifier;
import org.geotools.filter.function.ExplicitClassifier;
import org.geotools.filter.function.RangedClassifier;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.util.SuppressFBWarnings;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.PropertyName;

@SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"})
public class BrewerExamples {
    public void classiferExample() {
        Object collection = null;
        Object feature = null;
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        Function classify = ff.function("Quantile", new Expression[]{ff.property("name"), ff.literal(2)});
        Classifier groups = (Classifier)classify.evaluate(collection);
        groups.setTitle(0, "Group A");
        groups.setTitle(1, "Group B");
        Function sort = ff.function("classify", new Expression[]{ff.property("name"), ff.literal((Object)groups)});
        int slot = (Integer)sort.evaluate(feature);
        System.out.println(groups.getTitle(slot));
    }

    public void classiferQuantile() {
        Object collection = null;
        Object feature = null;
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        Function classify = ff.function("Quantile", new Expression[]{ff.property("zone"), ff.literal(2)});
        Classifier groups = (Classifier)classify.evaluate(collection);
    }

    public void classiferEqualInterval() {
        Object collection = null;
        Object feature = null;
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        Function classify = ff.function("EqualInterval", new Expression[]{ff.property("height"), ff.literal(5)});
        Classifier height = (Classifier)classify.evaluate(collection);
    }

    public void explicitClassifierExample() {
        Set[] zones = new Set[]{new HashSet<String>(Arrays.asList("Zone 1", "Zone 2")), new HashSet<String>(Arrays.asList("Zone 4", "Crown 2")), new HashSet<String>(Arrays.asList("Zone 3"))};
        ExplicitClassifier landuse = new ExplicitClassifier(zones);
        landuse.setTitle(0, "urban");
        landuse.setTitle(1, "park");
        landuse.setTitle(2, "industrial");
    }

    public void rangedClassifierExample() {
        Comparable[] min = new Comparable[25];
        Comparable[] max = new Comparable[25];
        for (int i = 0; i < 25; ++i) {
            min[i] = Character.valueOf((char)(65 + i));
            max[i] = Character.valueOf((char)(66 + i));
        }
        RangedClassifier alphabetical = new RangedClassifier(min, max);
    }

    void colorBrewerExample(SimpleFeatureCollection featureCollection) {
        ColorBrewer brewer = ColorBrewer.instance();
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        PropertyName propteryExpression = ff.property("height");
        Function classify = ff.function("Quantile", new Expression[]{propteryExpression, ff.literal(5)});
        Classifier groups = (Classifier)classify.evaluate((Object)featureCollection);
        String paletteName = "GrBu";
        Color[] colors = brewer.getPalette(paletteName).getColors(5);
        FeatureTypeStyle style = StyleGenerator.createFeatureTypeStyle((Classifier)groups, (Expression)propteryExpression, (Color[])colors, (String)"Generated FeatureTypeStyle for GreeBlue", (GeometryDescriptor)((SimpleFeatureType)featureCollection.getSchema()).getGeometryDescriptor(), (int)0, (double)0.95, null);
    }
}

