/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.api.validation;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.validation.DefaultFeatureResults;
import org.geotools.validation.FeatureValidation;
import org.geotools.validation.ValidationProcessor;
import org.geotools.validation.ValidationResults;
import org.geotools.validation.spatial.IsValidGeometryValidation;

public class ValidationExamples {
    private void validationExample() throws Exception {
        SimpleFeatureCollection roadFeatures = null;
        FeatureCollection riverFeatures = null;
        MemoryDataStore store = new MemoryDataStore();
        store.addFeatures(roadFeatures);
        store.addFeatures(riverFeatures);
        ValidationProcessor processor = new ValidationProcessor();
        IsValidGeometryValidation geom = new IsValidGeometryValidation();
        geom.setName("IsValidGeometry");
        geom.setDescription("IsValid geomtry check");
        geom.setTypeRef("*");
        processor.addValidation((FeatureValidation)geom);
        DefaultFeatureResults results = new DefaultFeatureResults();
        processor.runFeatureTests("dataStoreId", roadFeatures, (ValidationResults)results);
        System.out.println("Found " + results.error.size() + " failires");
    }

    private void validationExample2() throws Exception {
        File pluginDirectory = null;
        File testSuiteDirectory = null;
        Object lakesFeatureSource = null;
        Object streamsFeatureSource = null;
        ValidationProcessor processor = new ValidationProcessor();
        processor.load(pluginDirectory, testSuiteDirectory);
        processor.load(pluginDirectory, testSuiteDirectory);
        DefaultFeatureResults results = new DefaultFeatureResults();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LAKES:lakes", lakesFeatureSource);
        map.put("STREAMS:streams", streamsFeatureSource);
        HashSet<NameImpl> check = new HashSet<NameImpl>();
        check.add(new NameImpl("LAKES:lakes"));
        processor.runIntegrityTests(check, map, null, (ValidationResults)results);
        System.out.println("Found " + results.error.size() + " failires");
    }
}

