/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.api;

import java.net.URI;
import java.util.Set;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.Query;
import org.geotools.data.ServiceInfo;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.NameImpl;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.util.SuppressFBWarnings;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;

@SuppressFBWarnings(value={"UWF_NULL_FIELD"})
public class DataStoreExamples {
    @SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD"})
    DataStore dataStore = null;
    @SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD"})
    SimpleFeatureSource featureSource = null;

    void exampleInfo() {
        ServiceInfo info = this.dataStore.getInfo();
        String title = info.getTitle();
        String text = info.getDescription();
        Set keywords = info.getKeywords();
        URI publisher = info.getPublisher();
        URI schema = info.getSchema();
        URI source = info.getSource();
    }

    void exampleCreateSchema() throws Exception {
        SimpleFeatureType schema = DataUtilities.createType((String)"LINE", (String)"centerline:LineString,name:\"\",id:0");
        this.dataStore.createSchema((FeatureType)schema);
    }

    void exampleRemoveSchema() throws Exception {
        NameImpl schemaName = new NameImpl("myTable");
        this.dataStore.removeSchema((Name)schemaName);
    }

    void exampleAllCount() throws Exception {
        int count = this.featureSource.getCount(Query.ALL);
        if (count == -1) {
            count = this.featureSource.getFeatures().size();
        }
    }

    void exampleQueryCount() throws Exception {
        Query query = new Query("typeName", CQL.toFilter((String)"REGION = 3"));
        int count = this.featureSource.getCount(query);
        if (count == -1) {
            count = this.featureSource.getFeatures(query).size();
        }
    }
}

