/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data.publish;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.tester.FormTester;
import org.apache.wicket.util.tester.WicketTester;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.TestHttpClientProvider;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.WMSLayerInfoImpl;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geoserver.data.test.MockData;
import org.geoserver.test.http.MockHttpClient;
import org.geoserver.test.http.MockHttpResponse;
import org.geoserver.web.ComponentBuilder;
import org.geoserver.web.FormTestPage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.wms.web.publish.StylesModel;
import org.geoserver.wms.web.publish.WMSLayerConfig;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WMSLayerConfigTest
extends GeoServerWicketTestSupport {
    @Before
    public void resetPondStyle() {
        Catalog catalog = this.getCatalog();
        StyleInfo style = catalog.getStyleByName(MockData.PONDS.getLocalPart());
        style.setWorkspace(null);
        catalog.save(style);
    }

    @Test
    public void testExisting() {
        LayerInfo layer = this.getCatalog().getLayerByName(MockData.PONDS.getLocalPart());
        FormTestPage page = new FormTestPage((ComponentBuilder & Serializable)id -> new WMSLayerConfig(id, (IModel)new Model((Serializable)layer)));
        tester.startPage((Page)page);
        tester.assertRenderedPage(FormTestPage.class);
        tester.assertComponent("form", Form.class);
        tester.assertComponent("form:panel:styles:defaultStyle", DropDownChoice.class);
        StyleInfo target = (StyleInfo)((List)new StylesModel().getObject()).get(0);
        FormTester ft = tester.newFormTester("form");
        ft.select("panel:styles:defaultStyle", 0);
        ft.submit();
        tester.assertModelValue("form:panel:styles:defaultStyle", (Object)target);
        Assert.assertFalse((boolean)this.cascadedControlsVisible(tester));
    }

    @Test
    public void testNew() {
        LayerInfo layer = this.getCatalog().getFactory().createLayer();
        layer.setResource((ResourceInfo)this.getCatalog().getFactory().createFeatureType());
        FormTestPage page = new FormTestPage((ComponentBuilder & Serializable)id -> new WMSLayerConfig(id, (IModel)new Model((Serializable)layer)));
        Component layerConfig = page.get("form:panel:styles:defaultStyle");
        tester.startPage((Page)page);
        tester.assertRenderedPage(FormTestPage.class);
        tester.assertComponent("form", Form.class);
        tester.assertComponent("form:panel:styles:defaultStyle", DropDownChoice.class);
        tester.submitForm("form");
        Assert.assertTrue((boolean)layerConfig.getFeedbackMessages().hasMessage(400));
        page.getSession().getFeedbackMessages().clear();
        FormTester ft = tester.newFormTester("form");
        ft.select("panel:styles:defaultStyle", 0);
        ft.submit();
        Assert.assertFalse((boolean)layerConfig.getFeedbackMessages().hasMessage(400));
        Assert.assertFalse((boolean)this.cascadedControlsVisible(tester));
    }

    @Test
    public void testLegendGraphicURL() throws Exception {
        Catalog catalog = this.getCatalog();
        StyleInfo style = catalog.getStyleByName(MockData.PONDS.getLocalPart());
        WorkspaceInfo ws = catalog.getWorkspaceByName(MockData.PONDS.getPrefix());
        style.setWorkspace(ws);
        catalog.save(style);
        LayerInfo layer = this.getCatalog().getLayerByName(MockData.PONDS.getLocalPart());
        FormTestPage page = new FormTestPage((ComponentBuilder & Serializable)id -> new WMSLayerConfig(id, (IModel)new Model((Serializable)layer)));
        tester.startPage((Page)page);
        tester.assertRenderedPage(FormTestPage.class);
        tester.debugComponentTrees();
        Image img = (Image)tester.getComponentFromLastRenderedPage("form:panel:styles:defaultStyleLegendGraphic");
        Assert.assertNotNull((Object)img);
        Assert.assertEquals((long)1L, (long)img.getBehaviors().size());
        Assert.assertTrue((boolean)(img.getBehaviors().get(0) instanceof AttributeModifier));
        AttributeModifier mod = (AttributeModifier)img.getBehaviors().get(0);
        Assert.assertTrue((boolean)mod.toString().contains("cite/wms?REQUEST=GetLegendGraphic"));
        Assert.assertTrue((boolean)mod.toString().contains("style=cite:Ponds"));
        Assert.assertFalse((boolean)this.cascadedControlsVisible(tester));
        style.setWorkspace(null);
        catalog.save(style);
    }

    @Test
    public void testLegendGraphicURLNoWorkspace() throws Exception {
        LayerInfo layer = this.getCatalog().getLayerByName(MockData.PONDS.getLocalPart());
        FormTestPage page = new FormTestPage((ComponentBuilder & Serializable)id -> new WMSLayerConfig(id, (IModel)new Model((Serializable)layer)));
        tester.startPage((Page)page);
        tester.assertRenderedPage(FormTestPage.class);
        tester.debugComponentTrees();
        Image img = (Image)tester.getComponentFromLastRenderedPage("form:panel:styles:defaultStyleLegendGraphic");
        Assert.assertNotNull((Object)img);
        Assert.assertEquals((long)1L, (long)img.getBehaviors().size());
        Assert.assertTrue((boolean)(img.getBehaviors().get(0) instanceof AttributeModifier));
        AttributeModifier mod = (AttributeModifier)img.getBehaviors().get(0);
        Assert.assertFalse((boolean)mod.toString().contains("cite/wms?REQUEST=GetLegendGraphic"));
        Assert.assertTrue((boolean)mod.toString().contains("wms?REQUEST=GetLegendGraphic"));
        Assert.assertTrue((boolean)mod.toString().contains("style=Ponds"));
        Assert.assertFalse((boolean)this.cascadedControlsVisible(tester));
    }

    @Test
    public void testInterpolationDropDown() {
        LayerInfo layer = this.getCatalog().getLayerByName(MockData.PONDS.getLocalPart());
        Model layerModel = new Model((Serializable)layer);
        FormTestPage page = new FormTestPage((ComponentBuilder & Serializable)id -> new WMSLayerConfig(id, (IModel)layerModel));
        tester.startPage((Page)page);
        tester.assertRenderedPage(FormTestPage.class);
        tester.assertComponent("form", Form.class);
        tester.assertComponent("form:panel:defaultInterpolationMethod", DropDownChoice.class);
        FormTester ft = tester.newFormTester("form");
        ft.submit();
        tester.assertModelValue("form:panel:defaultInterpolationMethod", null);
        ft = tester.newFormTester("form");
        ft.select("panel:defaultInterpolationMethod", 2);
        ft.submit();
        tester.assertModelValue("form:panel:defaultInterpolationMethod", (Object)LayerInfo.WMSInterpolation.Bicubic);
        Assert.assertFalse((boolean)this.cascadedControlsVisible(tester));
    }

    @Test
    public void testWMSCascadeSettings() throws Exception {
        MockHttpClient wms11Client = new MockHttpClient();
        URL wms11BaseURL = new URL("http://mock.test.geoserver.org/wms11");
        URL capsDocument = WMSLayerConfigTest.class.getResource("caps111.xml");
        wms11Client.expectGet(new URL(wms11BaseURL + "?service=WMS&request=GetCapabilities&version=1.1.1"), (HTTPResponse)new MockHttpResponse(capsDocument, "text/xml", new String[0]));
        String caps = wms11BaseURL + "?service=WMS&request=GetCapabilities&version=1.1.1";
        TestHttpClientProvider.bind((HTTPClient)wms11Client, (String)caps);
        CatalogBuilder cb = new CatalogBuilder(this.getCatalog());
        WMSStoreInfo store = cb.buildWMSStore("mock-wms-store-110");
        this.getCatalog().add((StoreInfo)store);
        cb.setStore((StoreInfo)store);
        store.setCapabilitiesURL(caps);
        WMSLayerInfo wmsLayer = cb.buildWMSLayer("roads");
        wmsLayer.setName("roads");
        wmsLayer.reset();
        int remoteStyleCount = wmsLayer.getAllAvailableRemoteStyles().size();
        this.getCatalog().add((ResourceInfo)wmsLayer);
        LayerInfo gsLayer = cb.buildLayer(wmsLayer);
        this.getCatalog().add(gsLayer);
        Model layerModel = new Model((Serializable)gsLayer);
        FormTestPage page = new FormTestPage((ComponentBuilder & Serializable)id -> new WMSLayerConfig(id, (IModel)layerModel));
        tester.startPage((Page)page);
        tester.assertRenderedPage(FormTestPage.class);
        tester.assertModelValue("form:panel:remotestyles:remoteStylesDropDown", (Object)wmsLayer.getForcedRemoteStyle());
        tester.assertModelValue("form:panel:remotestyles:extraRemoteStyles", new HashSet(wmsLayer.remoteStyles()));
        Assert.assertEquals((long)wmsLayer.remoteStyles().size(), (long)remoteStyleCount);
        tester.assertModelValue("form:panel:remoteformats:remoteFormatsDropDown", (Object)wmsLayer.getPreferredFormat());
        tester.assertModelValue("form:panel:remoteformats:remoteFormatsPalette", new HashSet(wmsLayer.availableFormats()));
        tester.assertVisible("form:panel:metaDataCheckBoxContainer");
        tester.assertVisible("form:panel:scaleDenominatorContainer:minScale");
        tester.assertVisible("form:panel:scaleDenominatorContainer:maxScale");
        FormTester ft = tester.newFormTester("form");
        ft.setValue("panel:scaleDenominatorContainer:minScale", "100");
        ft.setValue("panel:scaleDenominatorContainer:maxScale", "1");
        ft.submit();
        tester.assertErrorMessages(new Serializable[]{"Minimum Scale cannot be greater than Maximum Scale"});
        Assert.assertTrue((boolean)this.cascadedControlsVisible(tester));
    }

    private boolean cascadedControlsVisible(WicketTester tester) {
        return tester.getComponentFromLastRenderedPage("form:panel:remotestyles") != null && tester.getComponentFromLastRenderedPage("form:panel:remoteformats") != null && tester.getComponentFromLastRenderedPage("form:panel:scaleDenominatorContainer") != null && tester.getComponentFromLastRenderedPage("form:panel:metaDataCheckBoxContainer") != null;
    }

    @Test
    public void testWMSCascadeSettingsLegacyBean() throws Exception {
        XStreamPersister persister = new XStreamPersisterFactory().createXMLPersister();
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wmsLayer>\n   <id>WMSLayerInfoImpl-622caab0:16ff63f5f7a:-7ffc</id>\n   <name>legacy_roads</name>\n   <nativeName>roads</nativeName>\n   <title>Legacy</title>\n   <description>Legacy</description>\n   <abstract>Legacy</abstract>\n   <keywords>\n      <string>census</string>\n      <string>united</string>\n      <string>boundaries</string>\n      <string>state</string>\n      <string>states</string>\n   </keywords>\n   <nativeCRS>GEOGCS[\"WGS 84\", &#xD;\n  DATUM[\"World Geodetic System 1984\", &#xD;\n    SPHEROID[\"WGS 84\", 6378137.0, 298.257223563, AUTHORITY[\"EPSG\",\"7030\"]], &#xD;\n    AUTHORITY[\"EPSG\",\"6326\"]], &#xD;\n  PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]], &#xD;\n  UNIT[\"degree\", 0.017453292519943295], &#xD;\n  AXIS[\"Geodetic longitude\", EAST], &#xD;\n  AXIS[\"Geodetic latitude\", NORTH], &#xD;\n  AUTHORITY[\"EPSG\",\"4326\"]]</nativeCRS>\n   <srs>EPSG:4326</srs>\n   <nativeBoundingBox>\n      <minx>-124.73142200000001</minx>\n      <maxx>-66.969849</maxx>\n      <miny>24.955967</miny>\n      <maxy>49.371735</maxy>\n      <crs>EPSG:4326</crs>\n   </nativeBoundingBox>\n   <latLonBoundingBox>\n      <minx>-124.731422</minx>\n      <maxx>-66.969849</maxx>\n      <miny>24.955967</miny>\n      <maxy>49.371735</maxy>\n      <crs>EPSG:4326</crs>\n   </latLonBoundingBox>\n   <projectionPolicy>FORCE_DECLARED</projectionPolicy>\n   <enabled>true</enabled>\n   <serviceConfiguration>false</serviceConfiguration>\n</wmsLayer>";
        WMSLayerInfoImpl legacyWmsLayerInfo = (WMSLayerInfoImpl)persister.load((InputStream)new ByteArrayInputStream(xml.getBytes()), WMSLayerInfo.class);
        MockHttpClient wms11Client = new MockHttpClient();
        URL wms11BaseURL = new URL("http://mock.test.geoserver.org/wms11");
        URL capsDocument = WMSLayerConfigTest.class.getResource("caps111.xml");
        wms11Client.expectGet(new URL(wms11BaseURL + "?service=WMS&request=GetCapabilities&version=1.1.1"), (HTTPResponse)new MockHttpResponse(capsDocument, "text/xml", new String[0]));
        String caps = wms11BaseURL + "?service=WMS&request=GetCapabilities&version=1.1.1";
        TestHttpClientProvider.bind((HTTPClient)wms11Client, (String)caps);
        CatalogBuilder cb = new CatalogBuilder(this.getCatalog());
        WMSStoreInfo store = cb.buildWMSStore("mock-wms-legacy-store-110");
        this.getCatalog().add((StoreInfo)store);
        cb.setStore((StoreInfo)store);
        store.setCapabilitiesURL(caps);
        WMSLayerInfo wmsLayer = cb.buildWMSLayer("roads");
        legacyWmsLayerInfo.setNamespace(wmsLayer.getNamespace());
        legacyWmsLayerInfo.setCatalog(wmsLayer.getCatalog());
        legacyWmsLayerInfo.setStore((StoreInfo)wmsLayer.getStore());
        this.getCatalog().add((ResourceInfo)legacyWmsLayerInfo);
        LayerInfo gsLayer = cb.buildLayer((WMSLayerInfo)legacyWmsLayerInfo);
        this.getCatalog().add(gsLayer);
        Model layerModel = new Model((Serializable)gsLayer);
        FormTestPage page = new FormTestPage((ComponentBuilder & Serializable)id -> new WMSLayerConfig(id, (IModel)layerModel));
        tester.startPage((Page)page);
        tester.assertRenderedPage(FormTestPage.class);
        tester.assertNoErrorMessage();
        tester.assertModelValue("form:panel:remotestyles:remoteStylesDropDown", (Object)wmsLayer.getForcedRemoteStyle());
        tester.assertModelValue("form:panel:remoteformats:remoteFormatsDropDown", (Object)wmsLayer.getPreferredFormat());
        DropDownChoice remotStyles = (DropDownChoice)tester.getComponentFromLastRenderedPage("form:panel:remotestyles:remoteStylesDropDown");
        DropDownChoice remoteformats = (DropDownChoice)tester.getComponentFromLastRenderedPage("form:panel:remoteformats:remoteFormatsDropDown");
        Assert.assertFalse((boolean)((List)remoteformats.getChoicesModel().getObject()).isEmpty());
        Assert.assertFalse((boolean)((List)remotStyles.getChoicesModel().getObject()).isEmpty());
        Palette remoteFormatsPalette = (Palette)tester.getComponentFromLastRenderedPage("form:panel:remoteformats:remoteFormatsPalette");
        Palette extraRemoteStyles = (Palette)tester.getComponentFromLastRenderedPage("form:panel:remotestyles:extraRemoteStyles");
        Assert.assertFalse((boolean)remoteFormatsPalette.getChoices().isEmpty());
        Assert.assertFalse((boolean)extraRemoteStyles.getChoices().isEmpty());
        Assert.assertNull((Object)remoteFormatsPalette.getConvertedInput());
        Assert.assertNull((Object)extraRemoteStyles.getConvertedInput());
    }
}

