/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.ValidationErrorFeedback;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.config.ServiceInfo;
import org.geoserver.web.GeoServerHomePage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.web.WMSAdminPage;
import org.geotools.api.util.InternationalString;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WMSAdminPageTest
extends GeoServerWicketTestSupport {
    private WMSInfo wms;

    @Before
    public void setUp() throws Exception {
        this.wms = (WMSInfo)this.getGeoServerApplication().getGeoServer().getService(WMSInfo.class);
        this.login();
    }

    @Test
    public void testValues() throws Exception {
        tester.startPage(WMSAdminPage.class);
        tester.assertModelValue("form:keywords", (Object)this.wms.getKeywords());
        tester.assertModelValue("form:srs", new ArrayList());
    }

    @Test
    public void testFormSubmit() throws Exception {
        tester.startPage(WMSAdminPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.submit("submit");
        tester.assertNoErrorMessage();
        tester.assertRenderedPage(GeoServerHomePage.class);
    }

    @Test
    public void testWatermarkLocalFile() throws Exception {
        File f = new File(((Object)((Object)this)).getClass().getResource("GeoServer_75.png").toURI());
        tester.startPage(WMSAdminPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("watermark.uRL", f.getAbsolutePath());
        ft.submit("submit");
        tester.assertNoErrorMessage();
        tester.assertRenderedPage(GeoServerHomePage.class);
    }

    @Test
    public void testFormInvalid() throws Exception {
        tester.startPage(WMSAdminPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("srs", "bla");
        ft.submit("submit");
        List errors = tester.getMessages(400);
        Assert.assertEquals((long)1L, (long)errors.size());
        Assert.assertTrue((boolean)((ValidationErrorFeedback)errors.get(0)).getMessage().toString().contains("bla"));
        tester.assertRenderedPage(WMSAdminPage.class);
    }

    @Test
    public void testBBOXForEachCRS() throws Exception {
        Assert.assertFalse((boolean)this.wms.isBBOXForEachCRS());
        tester.startPage(WMSAdminPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("bBOXForEachCRS", true);
        ft.submit("submit");
        Assert.assertTrue((boolean)this.wms.isBBOXForEachCRS());
    }

    @Test
    public void testRootLayerRemove() throws Exception {
        tester.startPage(WMSAdminPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("rootLayerEnabled", false);
        ft.submit("submit");
        tester.assertNoErrorMessage();
        Assert.assertEquals((Object)this.wms.getMetadata().get((Object)WMS.ROOT_LAYER_IN_CAPABILITIES_KEY), (Object)false);
    }

    @Test
    public void testRootLayerTitle() throws Exception {
        tester.startPage(WMSAdminPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("rootLayerTitleAndAbstract:title", "test");
        ft.setValue("rootLayerTitleAndAbstract:abstract", "abstract test");
        ft.submit("submit");
        tester.assertNoErrorMessage();
        Assert.assertEquals((Object)this.wms.getRootLayerTitle(), (Object)"test");
        Assert.assertEquals((Object)this.wms.getRootLayerAbstract(), (Object)"abstract test");
    }

    @Test
    public void testDensification() throws Exception {
        tester.startPage(WMSAdminPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("aph.densify", true);
        ft.submit("submit");
        tester.assertNoErrorMessage();
        Assert.assertEquals((Object)this.wms.getMetadata().get((Object)WMS.ADVANCED_PROJECTION_DENSIFICATION_KEY), (Object)true);
    }

    @Test
    public void testDisableWrappingHeuristic() throws Exception {
        tester.startPage(WMSAdminPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("aph.dlh", true);
        ft.submit("submit");
        tester.assertNoErrorMessage();
        Assert.assertEquals((Object)this.wms.getMetadata().get((Object)WMS.DATELINE_WRAPPING_HEURISTIC_KEY), (Object)true);
    }

    @Test
    public void testDynamicStylingDisabled() throws Exception {
        Assert.assertFalse((boolean)this.wms.isDynamicStylingDisabled());
        tester.startPage(WMSAdminPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("dynamicStyling.disabled", true);
        ft.submit("submit");
        Assert.assertTrue((boolean)this.wms.isDynamicStylingDisabled());
    }

    @Test
    public void testCacheConfiguration() throws Exception {
        Assert.assertFalse((boolean)this.wms.getCacheConfiguration().isEnabled());
        tester.startPage(WMSAdminPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("cacheConfiguration.enabled", true);
        ft.submit("submit");
        Assert.assertTrue((boolean)this.wms.getCacheConfiguration().isEnabled());
    }

    @Test
    public void testFeaturesReprojectionDisabled() throws Exception {
        Assert.assertFalse((boolean)this.wms.isFeaturesReprojectionDisabled());
        tester.startPage(WMSAdminPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("disableFeaturesReproject", true);
        ft.submit("submit");
        Assert.assertTrue((boolean)this.wms.isFeaturesReprojectionDisabled());
    }

    @Test
    public void testTransformFeatureInfoDisabled() throws Exception {
        Assert.assertFalse((boolean)this.wms.isTransformFeatureInfoDisabled());
        tester.startPage(WMSAdminPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("disableTransformFeatureInfo", true);
        ft.submit("submit");
        Assert.assertTrue((boolean)this.wms.isTransformFeatureInfoDisabled());
    }

    @Test
    public void testAutoEscapeTemplateValues() throws Exception {
        Assert.assertFalse((boolean)this.wms.isAutoEscapeTemplateValues());
        tester.startPage(WMSAdminPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("autoEscapeTemplateValues", true);
        ft.submit("submit");
        Assert.assertTrue((boolean)this.wms.isAutoEscapeTemplateValues());
    }

    @Test
    public void testIncludeDefaultGroupStyleInCapabilitiesDisabled() throws Exception {
        tester.startPage(WMSAdminPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("defaultGroupStyleEnabled", false);
        ft.submit("submit");
        Assert.assertFalse((boolean)this.wms.isDefaultGroupStyleEnabled());
    }

    @Test
    public void testIncludeDefaultGroupStyleInCapabilitiesEnabled() throws Exception {
        tester.startPage(WMSAdminPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("defaultGroupStyleEnabled", true);
        ft.submit("submit");
        Assert.assertTrue((boolean)this.wms.isDefaultGroupStyleEnabled());
    }

    @Test
    public void testInternationalContent() {
        tester.startPage(WMSAdminPage.class);
        FormTester form = tester.newFormTester("form");
        form.setValue("serviceTitleAndAbstract:titleAndAbstract:titleLabel:titleLabel_i18nCheckbox", true);
        tester.executeAjaxEvent("form:serviceTitleAndAbstract:titleAndAbstract:titleLabel:titleLabel_i18nCheckbox", "change");
        tester.executeAjaxEvent("form:serviceTitleAndAbstract:titleAndAbstract:internationalTitle:container:addNew", "click");
        tester.executeAjaxEvent("form:serviceTitleAndAbstract:titleAndAbstract:internationalTitle:container:addNew", "click");
        form.setValue("serviceTitleAndAbstract:titleAndAbstract:abstractLabel:abstractLabel_i18nCheckbox", true);
        tester.executeAjaxEvent("form:serviceTitleAndAbstract:titleAndAbstract:abstractLabel:abstractLabel_i18nCheckbox", "change");
        tester.executeAjaxEvent("form:serviceTitleAndAbstract:titleAndAbstract:internationalAbstract:container:addNew", "click");
        tester.executeAjaxEvent("form:serviceTitleAndAbstract:titleAndAbstract:internationalAbstract:container:addNew", "click");
        DropDownChoice select = (DropDownChoice)tester.getComponentFromLastRenderedPage("form:serviceTitleAndAbstract:titleAndAbstract:internationalTitle:container:tablePanel:listContainer:items:1:itemProperties:0:component:border:border_body:select");
        Locale l10 = (Locale)select.getChoices().get(10);
        Locale l20 = (Locale)select.getChoices().get(20);
        form.select("serviceTitleAndAbstract:titleAndAbstract:internationalTitle:container:tablePanel:listContainer:items:1:itemProperties:0:component:border:border_body:select", 10);
        form.setValue("serviceTitleAndAbstract:titleAndAbstract:internationalTitle:container:tablePanel:listContainer:items:1:itemProperties:1:component:border:border_body:txt", "an international title for WMS");
        form.select("serviceTitleAndAbstract:titleAndAbstract:internationalTitle:container:tablePanel:listContainer:items:2:itemProperties:0:component:border:border_body:select", 20);
        form.setValue("serviceTitleAndAbstract:titleAndAbstract:internationalTitle:container:tablePanel:listContainer:items:2:itemProperties:1:component:border:border_body:txt", "another international title for WMS");
        form.select("serviceTitleAndAbstract:titleAndAbstract:internationalAbstract:container:tablePanel:listContainer:items:1:itemProperties:0:component:border:border_body:select", 10);
        form.setValue("serviceTitleAndAbstract:titleAndAbstract:internationalAbstract:container:tablePanel:listContainer:items:1:itemProperties:1:component:border:border_body:txt", "an international abstract for WMS");
        form.select("serviceTitleAndAbstract:titleAndAbstract:internationalAbstract:container:tablePanel:listContainer:items:2:itemProperties:0:component:border:border_body:select", 20);
        form.setValue("serviceTitleAndAbstract:titleAndAbstract:internationalAbstract:container:tablePanel:listContainer:items:2:itemProperties:1:component:border:border_body:txt", "another international abstract for WMS");
        form.setValue("maxRenderingTime", "999");
        form.setValue("maxRequestMemory", "99999");
        form.setValue("maxRenderingErrors", "1");
        form.setValue("maxBuffer", "99");
        form.setValue("maxRequestedDimensionValues", "2");
        form.setValue("watermark.transparency", "5");
        form.setValue("cacheConfiguration.maxEntries", "1000");
        form.setValue("cacheConfiguration.maxEntrySize", "100000");
        form.setValue("remoteStyleTimeout", "9999");
        form.setValue("remoteStyleMaxRequestTime", "99");
        form.submit("submit");
        tester.assertNoErrorMessage();
        WMSInfo wmsInfo = (WMSInfo)this.getGeoServer().getService(WMSInfo.class);
        InternationalString internationalTitle = wmsInfo.getInternationalTitle();
        Assert.assertEquals((Object)"an international title for WMS", (Object)internationalTitle.toString(l10));
        Assert.assertEquals((Object)"another international title for WMS", (Object)internationalTitle.toString(l20));
        InternationalString internationalAbstract = wmsInfo.getInternationalAbstract();
        Assert.assertEquals((Object)"an international abstract for WMS", (Object)internationalAbstract.toString(l10));
        Assert.assertEquals((Object)"another international abstract for WMS", (Object)internationalAbstract.toString(l20));
    }

    @Test
    public void testDefaultLocale() {
        tester.startPage(WMSAdminPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.select("defaultLocale", 11);
        ft = tester.newFormTester("form");
        ft.submit("submit");
        Assert.assertNotNull((Object)((WMSInfo)this.getGeoServer().getService(WMSInfo.class)).getDefaultLocale());
    }

    @Test
    public void testAllowedUrlsAuth() {
        tester.startPage(WMSAdminPage.class);
        FormTester ft = tester.newFormTester("form");
        String allowedUrlForAuthForwarding = "http://localhost:8080/geoserver/rest/sldremote";
        ft.setValue("allowedURLsForAuthForwarding", allowedUrlForAuthForwarding);
        ft.submit("submit");
        Assert.assertEquals((Object)allowedUrlForAuthForwarding, ((WMSInfo)this.getGeoServer().getService(WMSInfo.class)).getAllowedURLsForAuthForwarding().get(0));
        tester.startPage(WMSAdminPage.class);
        ft = tester.newFormTester("form");
        allowedUrlForAuthForwarding = "invalid-remote-url\nhtPP://invalidhttpurl\nhttp://validurl";
        ft.setValue("allowedURLsForAuthForwarding", allowedUrlForAuthForwarding);
        ft.submit("submit");
        String reportedInvalidURLs = "invalid-remote-url, htPP://invalidhttpurl";
        tester.assertErrorMessages(new Serializable[]{String.format("The provided values are not valid HTTP urls: [%s]", reportedInvalidURLs)});
    }

    @Test
    public void testInvalidDimensionsFlag() throws Exception {
        this.wms.setExceptionOnInvalidDimension(Boolean.valueOf(true));
        this.getGeoServer().save((ServiceInfo)this.wms);
        tester.startPage(WMSAdminPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.select("exceptionOnInvalidDimension", 1);
        ft.submit("submit");
        Assert.assertFalse((boolean)this.wms.isExceptionOnInvalidDimension());
        tester.startPage(WMSAdminPage.class);
        ft = tester.newFormTester("form");
        ft.setValue("exceptionOnInvalidDimension", null);
        ft.submit("submit");
        Assert.assertNull((Object)this.wms.isExceptionOnInvalidDimension());
        tester.startPage(WMSAdminPage.class);
        ft = tester.newFormTester("form");
        ft.select("exceptionOnInvalidDimension", 0);
        ft.submit("submit");
        Assert.assertTrue((boolean)this.wms.isExceptionOnInvalidDimension());
    }
}

