/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.logging.Level;
import org.apache.commons.io.IOUtils;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogException;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.event.CatalogAddEvent;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.geoserver.catalog.event.CatalogRemoveEvent;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.wms.web.data.StyleEditPage;
import org.geotools.api.style.Style;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StyleEditPageWorkspaceRenameAndEditTest
extends GeoServerWicketTestSupport {
    StyleInfo buildingsStyle;
    StyleEditPage edit;
    private static final String STYLE_TO_MOVE_NAME = "testStyle";
    private static final String STYLE_TO_MOVE_FILENAME = "testMoveStyle.sld";
    private static final String STYLE_TO_MOVE_FILENAME_UPDATED = "testMoveStyleUpdated.sld";
    StyleInfo styleInfoToMove;

    @Before
    public void setUp() throws Exception {
        Catalog catalog = this.getCatalog();
        this.login();
        this.buildingsStyle = catalog.getStyleByName(MockData.BUILDINGS.getLocalPart());
        if (this.buildingsStyle == null) {
            StyleInfo si = catalog.getStyleByName("BuildingsNew");
            if (si != null) {
                si.setName(MockData.BUILDINGS.getLocalPart());
                catalog.save(si);
            }
            this.buildingsStyle = catalog.getStyleByName(MockData.BUILDINGS.getLocalPart());
        }
        this.edit = new StyleEditPage(this.buildingsStyle);
        tester.startPage((Page)this.edit);
        this.styleInfoToMove = catalog.getStyleByName(STYLE_TO_MOVE_NAME);
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.addStyle(STYLE_TO_MOVE_NAME, STYLE_TO_MOVE_FILENAME, ((Object)((Object)this)).getClass(), this.getCatalog());
    }

    @Test
    public void testMoveWorkspaceAndEdit() throws Exception {
        final boolean[] gotValidEvent = new boolean[]{false};
        this.getCatalog().addListener(new CatalogListener(){

            public void handleAddEvent(CatalogAddEvent event) throws CatalogException {
            }

            public void handleRemoveEvent(CatalogRemoveEvent event) throws CatalogException {
            }

            public void handleModifyEvent(CatalogModifyEvent event) throws CatalogException {
            }

            public void handlePostModifyEvent(CatalogPostModifyEvent event) throws CatalogException {
                MatcherAssert.assertThat((Object)event, (Matcher)CoreMatchers.notNullValue());
                MatcherAssert.assertThat((Object)event.getSource(), (Matcher)CoreMatchers.notNullValue());
                if (!(event.getSource() instanceof StyleInfo)) {
                    return;
                }
                try {
                    StyleInfo styleInfo = (StyleInfo)event.getSource();
                    MatcherAssert.assertThat((Object)styleInfo, (Matcher)CoreMatchers.notNullValue());
                    Style style = StyleEditPageWorkspaceRenameAndEditTest.this.getCatalog().getResourcePool().getStyle(styleInfo);
                    MatcherAssert.assertThat((Object)style, (Matcher)CoreMatchers.notNullValue());
                    MatcherAssert.assertThat((Object)style.featureTypeStyles().size(), (Matcher)CoreMatchers.is((Object)2));
                    gotValidEvent[0] = true;
                }
                catch (Exception exception) {
                    LOGGER.log(Level.SEVERE, "Error handling catalog modified style event.", exception);
                }
            }

            public void reloaded() {
            }
        });
        this.edit = new StyleEditPage(this.styleInfoToMove);
        tester.startPage((Page)this.edit);
        Assert.assertEquals((long)1L, (long)this.styleInfoToMove.getStyle().featureTypeStyles().size());
        FormTester form = tester.newFormTester("styleForm", false);
        DropDownChoice typeDropDown = (DropDownChoice)tester.getComponentFromLastRenderedPage("styleForm:context:panel:workspace");
        for (int wsIdx = 0; wsIdx < typeDropDown.getChoices().size(); ++wsIdx) {
            WorkspaceInfo ws = (WorkspaceInfo)typeDropDown.getChoices().get(wsIdx);
            if (!"sf".equalsIgnoreCase(ws.getName())) continue;
            form.select("context:panel:workspace", wsIdx);
            break;
        }
        File styleFile = new File(((Object)((Object)this)).getClass().getResource(STYLE_TO_MOVE_FILENAME_UPDATED).toURI());
        String updatedSld = IOUtils.toString((Reader)new FileReader(styleFile)).replaceAll("\r\n", "\n").replaceAll("\r", "\n");
        form.setValue("styleEditor:editorContainer:editorParent:editor", updatedSld);
        form.submit();
        StyleInfo si = this.getCatalog().getStyleByName(this.getCatalog().getWorkspaceByName("sf"), STYLE_TO_MOVE_NAME);
        Assert.assertNotNull((Object)si);
        Assert.assertNotNull((Object)si.getWorkspace());
        Assert.assertEquals((Object)"sf", (Object)si.getWorkspace().getName());
        Assert.assertEquals((long)2L, (long)si.getStyle().featureTypeStyles().size());
        MatcherAssert.assertThat((Object)gotValidEvent[0], (Matcher)CoreMatchers.is((Object)true));
    }
}

