/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.web.ComponentAuthorizer;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.data.SelectionRemovalLink;
import org.geoserver.web.data.workspace.WorkspaceEditPage;
import org.geoserver.web.wicket.DateTimeLabel;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.SimpleBookmarkableLink;
import org.geoserver.web.wicket.StyleFormatLabel;
import org.geoserver.wms.web.data.StyleEditPage;
import org.geoserver.wms.web.data.StyleNewPage;
import org.geoserver.wms.web.data.StyleProvider;

public class StylePage
extends GeoServerSecuredPage {
    GeoServerTablePanel<StyleInfo> table;
    SelectionRemovalLink removal;
    GeoServerDialog dialog;

    public StylePage() {
        StyleProvider provider = new StyleProvider();
        Component[] componentArray = new Component[1];
        this.table = new GeoServerTablePanel<StyleInfo>("table", (GeoServerDataProvider)provider, true){

            protected Component getComponentForProperty(String id, IModel<StyleInfo> itemModel, GeoServerDataProvider.Property<StyleInfo> property) {
                if (property == StyleProvider.NAME) {
                    return StylePage.this.styleLink(id, itemModel);
                }
                if (property == StyleProvider.WORKSPACE) {
                    return StylePage.this.workspaceLink(id, itemModel);
                }
                if (property == StyleProvider.MODIFIED_TIMESTAMP) {
                    return new DateTimeLabel(id, StyleProvider.MODIFIED_TIMESTAMP.getModel(itemModel));
                }
                if (property == StyleProvider.CREATED_TIMESTAMP) {
                    return new DateTimeLabel(id, StyleProvider.CREATED_TIMESTAMP.getModel(itemModel));
                }
                if (property == StyleProvider.FORMAT) {
                    return new StyleFormatLabel(id, StyleProvider.FORMAT.getModel(itemModel), StyleProvider.FORMAT_VERSION.getModel(itemModel));
                }
                return null;
            }

            protected void onSelectionUpdate(AjaxRequestTarget target) {
                StylePage.this.removal.setEnabled(!StylePage.this.table.getSelection().isEmpty());
                target.add(new Component[]{StylePage.this.removal});
            }
        };
        componentArray[0] = this.table;
        this.add(componentArray);
        this.table.setOutputMarkupId(true);
        Component[] componentArray2 = new Component[1];
        this.dialog = new GeoServerDialog("dialog");
        componentArray2[0] = this.dialog;
        this.add(componentArray2);
        this.setHeaderPanel(this.headerPanel());
    }

    protected Component headerPanel() {
        Fragment header = new Fragment("headerPanel", "header", (MarkupContainer)this);
        header.add(new Component[]{new BookmarkablePageLink("addNew", StyleNewPage.class)});
        Component[] componentArray = new Component[1];
        this.removal = new SelectionRemovalLink("removeSelected", this.table, this.dialog){

            protected StringResourceModel canRemove(CatalogInfo object) {
                if (StylePage.isDefaultStyle(object)) {
                    return new StringResourceModel("cantRemoveDefaultStyle", (Component)StylePage.this, null);
                }
                return null;
            }
        };
        componentArray[0] = this.removal;
        header.add(componentArray);
        this.removal.setOutputMarkupId(true);
        this.removal.setEnabled(false);
        return header;
    }

    Component styleLink(String id, IModel<StyleInfo> model) {
        IModel nameModel = StyleProvider.NAME.getModel(model);
        IModel wsModel = StyleProvider.WORKSPACE.getModel(model);
        String name = (String)nameModel.getObject();
        String wsName = (String)wsModel.getObject();
        return new SimpleBookmarkableLink(id, StyleEditPage.class, nameModel, new String[]{"name", name, "workspace", wsName});
    }

    Component workspaceLink(String id, IModel<StyleInfo> model) {
        IModel wsNameModel = StyleProvider.WORKSPACE.getModel(model);
        String wsName = (String)wsNameModel.getObject();
        if (wsName != null) {
            return new SimpleBookmarkableLink(id, WorkspaceEditPage.class, (IModel)new Model((Serializable)((Object)wsName)), new String[]{"name", wsName});
        }
        return new WebMarkupContainer(id);
    }

    protected ComponentAuthorizer getPageAuthorizer() {
        return ComponentAuthorizer.WORKSPACE_ADMIN;
    }

    protected static boolean isDefaultStyle(CatalogInfo catalogInfo) {
        if (catalogInfo instanceof StyleInfo) {
            StyleInfo s = (StyleInfo)catalogInfo;
            return s.getWorkspace() == null && ("point".equals(s.getName()) || "line".equals(s.getName()) || "polygon".equals(s.getName()) || "raster".equals(s.getName()) || "generic".equals(s.getName()));
        }
        return false;
    }
}

