/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data;

import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.request.mapper.parameter.INamedParameters;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.wms.web.data.StyleEditPage;
import org.geoserver.wms.web.data.StylePage;
import org.geoserver.wms.web.data.StyleProvider;
import org.geotools.api.filter.Filter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StylePageTest
extends GeoServerWicketTestSupport {
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        WorkspaceInfo cite = this.getCatalog().getWorkspaceByName("cite");
        testData.addStyle(cite, "simplePoint", "simplePoint.sld", StylePageTest.class, this.getCatalog());
    }

    @Before
    public void clearFilter() {
        tester.getSession().removeAttribute("userInput");
    }

    @Test
    public void testPageLoad() {
        this.login();
        tester.startPage(StylePage.class);
        tester.assertRenderedPage(StylePage.class);
    }

    @Test
    public void testStyleProvider() {
        this.login();
        tester.startPage(StylePage.class);
        tester.assertRenderedPage(StylePage.class);
        DataView dv = (DataView)tester.getComponentFromLastRenderedPage("table:listContainer:items");
        Catalog catalog = this.getCatalog();
        Assert.assertEquals((long)dv.size(), (long)catalog.getStyles().size());
        IDataProvider dataProvider = dv.getDataProvider();
        Assert.assertTrue((boolean)(dataProvider instanceof StyleProvider));
        StyleProvider provider = (StyleProvider)dataProvider;
        boolean catchedException = false;
        try {
            provider.getItems();
        }
        catch (UnsupportedOperationException e) {
            catchedException = true;
        }
        Assert.assertTrue((boolean)catchedException);
        StyleInfo actual = (StyleInfo)provider.iterator(0L, 1L).next();
        try (CloseableIterator list = catalog.list(StyleInfo.class, (Filter)Filter.INCLUDE, Integer.valueOf(0), Integer.valueOf(1), Predicates.sortBy((String)"name", (boolean)true));){
            Assert.assertTrue((boolean)list.hasNext());
            StyleInfo expected = (StyleInfo)list.next();
            Assert.assertEquals((Object)expected, (Object)actual);
        }
    }

    @Test
    public void testIsDefaultStyle() {
        Catalog cat = this.getCatalog();
        Assert.assertTrue((boolean)StylePage.isDefaultStyle((CatalogInfo)cat.getStyleByName("line")));
        StyleInfo s = cat.getFactory().createStyle();
        s.setName("line");
        s.setFilename("line.sld");
        s.setWorkspace(cat.getDefaultWorkspace());
        Assert.assertFalse((boolean)StylePage.isDefaultStyle((CatalogInfo)s));
    }

    @Test
    public void testTimeColumnsToggle() {
        GeoServerInfo info = this.getGeoServerApplication().getGeoServer().getGlobal();
        info.getSettings().setShowCreatedTimeColumnsInAdminList(true);
        info.getSettings().setShowModifiedTimeColumnsInAdminList(true);
        this.getGeoServerApplication().getGeoServer().save(info);
        this.login();
        tester.startPage(StylePage.class);
        tester.assertRenderedPage(StylePage.class);
        DataView dv = (DataView)tester.getComponentFromLastRenderedPage("table:listContainer:items");
        Catalog catalog = this.getCatalog();
        Assert.assertEquals((long)dv.size(), (long)catalog.getStyles().size());
        IDataProvider dataProvider = dv.getDataProvider();
        Assert.assertTrue((boolean)(dataProvider instanceof StyleProvider));
        StyleProvider provider = (StyleProvider)dataProvider;
        Assert.assertTrue((boolean)provider.getProperties().contains(StyleProvider.CREATED_TIMESTAMP));
        Assert.assertTrue((boolean)provider.getProperties().contains(StyleProvider.MODIFIED_TIMESTAMP));
    }

    @Test
    public void testFilter() {
        this.login();
        Catalog catalog = this.getCatalog();
        tester.startPage(StylePage.class);
        tester.assertRenderedPage(StylePage.class);
        DataView dv = (DataView)tester.getComponentFromLastRenderedPage("table:listContainer:items");
        Assert.assertEquals((long)dv.size(), (long)catalog.getStyles().size());
        FormTester ft = tester.newFormTester("table:filterForm");
        ft.setValue("filter", "polygon");
        ft.submit("submit");
        dv = (DataView)tester.getComponentFromLastRenderedPage("table:listContainer:items");
        Assert.assertEquals((long)dv.size(), (long)2L);
        tester.assertVisible("table:filterForm:clear");
        tester.assertModelValue("table:filterForm:filter", (Object)"polygon");
        tester.startPage((Page)new StyleEditPage((StyleInfo)catalog.getStyles().get(0)));
        tester.assertRenderedPage(StyleEditPage.class);
        tester.assertNoErrorMessage();
        tester.executeAjaxEvent("save", "click");
        tester.assertRenderedPage(StylePage.class);
        tester.assertVisible("table:filterForm:clear");
        tester.assertModelValue("table:filterForm:filter", (Object)"polygon");
        dv = (DataView)tester.getComponentFromLastRenderedPage("table:listContainer:items");
        Assert.assertEquals((long)dv.size(), (long)2L);
        tester.clickLink("table:filterForm:clear", true);
        tester.assertInvisible("table:filterForm:clear");
        tester.assertModelValue("table:filterForm:filter", (Object)"");
        dv = (DataView)tester.getComponentFromLastRenderedPage("table:listContainer:items");
        Assert.assertEquals((long)dv.size(), (long)catalog.getStyles().size());
    }

    @Test
    public void testWorkspaceFilter() {
        this.login();
        Catalog catalog = this.getCatalog();
        tester.startPage(StylePage.class);
        tester.assertRenderedPage(StylePage.class);
        DataView dv = (DataView)tester.getComponentFromLastRenderedPage("table:listContainer:items");
        Assert.assertEquals((long)dv.size(), (long)catalog.getStyles().size());
        FormTester ft = tester.newFormTester("table:filterForm");
        ft.setValue("filter", "cite");
        ft.submit("submit");
        this.print((Component)tester.getLastRenderedPage(), true, true);
        dv = (DataView)tester.getComponentFromLastRenderedPage("table:listContainer:items");
        Assert.assertEquals((long)1L, (long)dv.size());
    }

    @Test
    public void testFilterReset() {
        this.login();
        Catalog catalog = this.getCatalog();
        tester.startPage(StylePage.class);
        tester.assertRenderedPage(StylePage.class);
        DataView dv = (DataView)tester.getComponentFromLastRenderedPage("table:listContainer:items");
        Assert.assertEquals((long)dv.size(), (long)catalog.getStyles().size());
        FormTester ft = tester.newFormTester("table:filterForm");
        ft.setValue("filter", "polygon");
        ft.submit("submit");
        dv = (DataView)tester.getComponentFromLastRenderedPage("table:listContainer:items");
        Assert.assertEquals((long)dv.size(), (long)2L);
        tester.assertVisible("table:filterForm:clear");
        tester.assertModelValue("table:filterForm:filter", (Object)"polygon");
        PageParameters pageParms = new PageParameters();
        pageParms.set("filter", (Object)false, INamedParameters.Type.PATH);
        tester.startPage(StylePage.class, pageParms);
        tester.assertRenderedPage(StylePage.class);
        tester.assertNoErrorMessage();
        tester.assertInvisible("table:filterForm:clear");
        tester.assertModelValue("table:filterForm:filter", null);
        dv = (DataView)tester.getComponentFromLastRenderedPage("table:listContainer:items");
        Assert.assertEquals((long)dv.size(), (long)catalog.getStyles().size());
    }
}

