/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data;

import java.util.HashMap;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.SLDHandler;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wms.web.data.StylePage;
import org.geoserver.wms.web.data.StylePageTest;
import org.geoserver.wms.web.data.StyleProvider;
import org.geotools.util.Version;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StylePageFormatColumnTest
extends StylePageTest {
    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        HashMap<SystemTestData.StyleProperty, Version> propertiesSld10 = new HashMap<SystemTestData.StyleProperty, Version>();
        propertiesSld10.put(SystemTestData.StyleProperty.FORMAT_VERSION, SLDHandler.VERSION_10);
        testData.addStyle(null, "testStyleFormatLabelSld10", "testStyleFormatLabelSld10.sld", StylePageTest.class, this.getCatalog(), propertiesSld10);
        HashMap<SystemTestData.StyleProperty, Version> propertiesSld11 = new HashMap<SystemTestData.StyleProperty, Version>();
        propertiesSld11.put(SystemTestData.StyleProperty.FORMAT_VERSION, SLDHandler.VERSION_11);
        testData.addStyle(null, "testStyleFormatLabelSld11", "testStyleFormatLabelSld11.sld", StylePageTest.class, this.getCatalog(), propertiesSld11);
    }

    @Before
    public void loadStylePage() {
        this.login();
        tester.startPage(StylePage.class);
        tester.assertRenderedPage(StylePage.class);
    }

    private int findFormatColumnIndex(DataView dv) {
        IDataProvider dataProvider = dv.getDataProvider();
        Assert.assertTrue((boolean)(dataProvider instanceof StyleProvider));
        StyleProvider provider = (StyleProvider)dataProvider;
        return provider.getProperties().indexOf(StyleProvider.FORMAT);
    }

    private String findFormatLabelText(DataView dv, int formatColumnIndex) {
        Item i = (Item)dv.getItems().next();
        Label label = (Label)i.get("itemProperties:" + formatColumnIndex + ":component:styleFormatLabel");
        return label.getDefaultModelObjectAsString();
    }

    @Test
    public void formatColumnPresenceTest() {
        Catalog catalog = this.getCatalog();
        DataView dv = (DataView)tester.getComponentFromLastRenderedPage("table:listContainer:items");
        Assert.assertEquals((long)dv.size(), (long)catalog.getStyles().size());
        IDataProvider dataProvider = dv.getDataProvider();
        Assert.assertTrue((boolean)(dataProvider instanceof StyleProvider));
        StyleProvider provider = (StyleProvider)dataProvider;
        Assert.assertTrue((boolean)provider.getProperties().contains(StyleProvider.FORMAT));
    }

    @Test
    public void testSLD11Label() {
        FormTester ft = tester.newFormTester("table:filterForm");
        ft.setValue("filter", "testStyleFormatLabelSld11");
        ft.submit("submit");
        DataView dv = (DataView)tester.getComponentFromLastRenderedPage("table:listContainer:items");
        Assert.assertEquals((long)dv.size(), (long)1L);
        int formatColumnIndex = this.findFormatColumnIndex(dv);
        Assert.assertTrue((formatColumnIndex > -1 ? 1 : 0) != 0);
        String formatLabelText = this.findFormatLabelText(dv, formatColumnIndex);
        this.assertEqualsIgnoreNewLineStyle(formatLabelText, "SLD 1.1");
    }

    @Test
    public void testSLD10Label() {
        FormTester ft = tester.newFormTester("table:filterForm");
        ft.setValue("filter", "testStyleFormatLabelSld10");
        ft.submit("submit");
        DataView dv = (DataView)tester.getComponentFromLastRenderedPage("table:listContainer:items");
        Assert.assertEquals((long)dv.size(), (long)1L);
        int formatColumnIndex = this.findFormatColumnIndex(dv);
        Assert.assertTrue((formatColumnIndex > -1 ? 1 : 0) != 0);
        String formatLabelText = this.findFormatLabelText(dv, formatColumnIndex);
        this.assertEqualsIgnoreNewLineStyle(formatLabelText, "SLD 1.0");
    }
}

