/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data;

import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.apache.wicket.validation.validator.RangeValidator;
import org.geoserver.catalog.LegendInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.wicket.GeoServerAjaxFormLink;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.wms.web.data.AbstractStylePage;
import org.geoserver.wms.web.data.ChooseImagePanel;
import org.geotools.util.logging.Logging;

public class ExternalGraphicPanel
extends Panel {
    private static final long serialVersionUID = 5098470683723890874L;
    static final Logger LOGGER = Logging.getLogger(ExternalGraphicPanel.class);
    private static final String[] EXTENSIONS = new String[]{"png", "gif", "jpeg", "jpg"};
    private TextField<String> onlineResource;
    private TextField<String> format;
    private TextField<Integer> width;
    private TextField<Integer> height;
    private WebMarkupContainer table;
    private GeoServerAjaxFormLink autoFill;
    private Form<StyleInfo> showhideForm;
    private AjaxButton show;
    private AjaxButton hide;
    private Model<String> showhideStyleModel = new Model((Serializable)((Object)""));

    public ExternalGraphicPanel(String id, CompoundPropertyModel<StyleInfo> styleModel, Form<?> styleForm, AbstractStylePage stylePage) {
        super(id, styleModel);
        WebMarkupContainer container = new WebMarkupContainer("externalGraphicContainer");
        container.setOutputMarkupId(true);
        this.add(new Component[]{container});
        this.table = new WebMarkupContainer("list");
        this.table.setOutputMarkupId(true);
        IModel bind = styleModel.bind("legend.onlineResource");
        this.onlineResource = new TextField("onlineResource", bind);
        this.onlineResource.add((IValidator)new OnlineResourceValidator(styleModel));
        this.onlineResource.setOutputMarkupId(true);
        this.table.add(new Component[]{this.onlineResource});
        ChooseImageLink chooseImage = new ChooseImageLink(styleForm, stylePage, styleModel);
        this.table.add(new Component[]{chooseImage});
        this.autoFill = new GeoServerAjaxFormLink("autoFill", styleForm){

            public void onClick(AjaxRequestTarget target, Form<?> form) {
                URLConnection conn = ExternalGraphicPanel.this.getExternalGraphic(target, form);
                if (conn == null) {
                    ValidationError error = new ValidationError();
                    error.setMessage("Unable to access image");
                    error.addKey("imageUnavailable");
                    ExternalGraphicPanel.this.onlineResource.error((IValidationError)error);
                } else {
                    ExternalGraphicPanel.this.format.setModelValue(new String[]{conn.getContentType()});
                    try {
                        BufferedImage image = ImageIO.read(conn.getInputStream());
                        ExternalGraphicPanel.this.width.setModelValue(new String[]{"" + image.getWidth()});
                        ExternalGraphicPanel.this.height.setModelValue(new String[]{"" + image.getHeight()});
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "", e);
                    }
                    target.add(new Component[]{ExternalGraphicPanel.this.format});
                    target.add(new Component[]{ExternalGraphicPanel.this.width});
                    target.add(new Component[]{ExternalGraphicPanel.this.height});
                }
            }
        };
        this.table.add(new Component[]{this.autoFill});
        this.format = new TextField("format", styleModel.bind("legend.format"));
        this.format.setOutputMarkupId(true);
        this.table.add(new Component[]{this.format});
        this.width = new TextField("width", styleModel.bind("legend.width"), Integer.class);
        this.width.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(0)));
        this.width.setRequired(true);
        this.width.setOutputMarkupId(true);
        this.table.add(new Component[]{this.width});
        this.height = new TextField("height", styleModel.bind("legend.height"), Integer.class);
        this.height.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(0)));
        this.height.setRequired(true);
        this.height.setOutputMarkupId(true);
        this.table.add(new Component[]{this.height});
        this.table.add(new Behavior[]{AttributeModifier.replace((String)"class", this.showhideStyleModel)});
        container.add(new Component[]{this.table});
        this.showhideForm = new Form<StyleInfo>("showhide"){

            protected void onSubmit() {
                super.onSubmit();
            }
        };
        this.showhideForm.setMarkupId("showhideForm");
        container.add(new Component[]{this.showhideForm});
        this.showhideForm.setMultiPart(true);
        this.show = new AjaxButton("show"){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target) {
                ExternalGraphicPanel.this.updateVisibility(true);
                target.add(new Component[]{ExternalGraphicPanel.this});
            }
        };
        container.add(new Component[]{this.show});
        this.showhideForm.add(new Component[]{this.show});
        this.hide = new AjaxButton("hide"){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target) {
                ExternalGraphicPanel.this.onlineResource.setModelObject((Object)"");
                ExternalGraphicPanel.this.onlineResource.clearInput();
                ExternalGraphicPanel.this.format.setModelObject((Object)"");
                ExternalGraphicPanel.this.format.clearInput();
                ExternalGraphicPanel.this.width.setModelObject((Object)0);
                ExternalGraphicPanel.this.width.clearInput();
                ExternalGraphicPanel.this.height.setModelObject((Object)0);
                ExternalGraphicPanel.this.height.clearInput();
                ExternalGraphicPanel.this.updateVisibility(false);
                target.add(new Component[]{ExternalGraphicPanel.this});
            }
        };
        container.add(new Component[]{this.hide});
        this.showhideForm.add(new Component[]{this.hide});
        LegendInfo legend = ((StyleInfo)styleModel.getObject()).getLegend();
        boolean visible = legend != null && legend.getOnlineResource() != null && !legend.getOnlineResource().isEmpty();
        this.updateVisibility(visible);
    }

    protected String baseURL(Form<?> form) {
        GeoServer gs;
        HttpServletRequest httpServletRequest = (HttpServletRequest)form.getRequest().getContainerRequest();
        String baseUrl = GeoServerExtensions.getProperty((String)"PROXY_BASE_URL");
        if (StringUtils.isEmpty((CharSequence)baseUrl) && StringUtils.isEmpty((CharSequence)(baseUrl = (gs = GeoServerApplication.get().getGeoServer()).getGlobal().getSettings().getProxyBaseUrl()))) {
            return ResponseUtils.baseURL((HttpServletRequest)httpServletRequest);
        }
        return baseUrl;
    }

    protected URLConnection getExternalGraphic(AjaxRequestTarget target, Form<?> form) {
        this.onlineResource.processInput();
        if (this.onlineResource.getModelObject() != null) {
            URL url = null;
            try {
                String external = ((String)this.onlineResource.getModelObject()).toString();
                URI uri = new URI(external);
                if (uri.isAbsolute() && this.isUrl(external)) {
                    url = uri.toURL();
                } else {
                    WorkspaceInfo wsInfo = ((StyleInfo)this.getDefaultModelObject()).getWorkspace();
                    Resource icon = this.getIconFromStyleDirectory(wsInfo, external);
                    if (icon == null) {
                        throw new FileNotFoundException();
                    }
                    url = icon.file().toURI().toURL();
                }
                URLConnection conn = url.openConnection();
                if ("text/html".equals(conn.getContentType())) {
                    form.error((Serializable)((Object)"Unable to access url"));
                    return null;
                }
                return conn;
            }
            catch (FileNotFoundException notFound) {
                form.error((Serializable)((Object)("Unable to access " + url)));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "", e);
                form.error((Serializable)((Object)("Recommend use of styles directory at " + e)));
            }
        }
        return null;
    }

    protected String getOnlineResource() {
        return this.onlineResource.getInput();
    }

    private void updateVisibility(boolean b) {
        this.showhideStyleModel.setObject((Serializable)((Object)(b ? "" : "hidden")));
        this.autoFill.setVisible(b);
        this.hide.setVisible(b);
        this.show.setVisible(!b);
    }

    private boolean isUrl(String uri) {
        return uri.startsWith("http");
    }

    private Resource getIconFromStyleDirectory(WorkspaceInfo wsInfo, String value) throws Exception {
        GeoServerResourceLoader resources = GeoServerApplication.get().getResourceLoader();
        GeoServerDataDirectory gsDataDir = new GeoServerDataDirectory(resources);
        Resource icon = null;
        if (wsInfo != null) {
            icon = gsDataDir.getStyles(wsInfo, new String[]{value});
        }
        if (icon == null) {
            icon = gsDataDir.getStyles(new String[]{value});
            if (icon == null) {
                throw new FileNotFoundException("file not found");
            }
            if (icon.getType() != Resource.Type.RESOURCE) {
                throw new Exception("given path is a directory");
            }
        }
        return icon;
    }

    private class OnlineResourceValidator
    implements IValidator<String> {
        private final CompoundPropertyModel<StyleInfo> styleModel;

        public OnlineResourceValidator(CompoundPropertyModel<StyleInfo> styleModel) {
            this.styleModel = styleModel;
        }

        public void validate(IValidatable<String> input) {
            int last;
            String value = (String)input.getValue();
            int n = last = value == null ? -1 : value.lastIndexOf(46);
            if (last == -1 || !Arrays.asList(EXTENSIONS).contains(value.substring(last + 1).toLowerCase())) {
                ValidationError error = new ValidationError();
                error.setMessage("Not an image");
                error.addKey("nonImage");
                input.error((IValidationError)error);
                return;
            }
            URI uri = null;
            try {
                uri = new URI(value);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            if (uri != null && uri.isAbsolute() && ExternalGraphicPanel.this.isUrl(value)) {
                try {
                    URL url = uri.toURL();
                    URLConnection conn = url.openConnection();
                    if ("text/html".equals(conn.getContentType())) {
                        ValidationError error = new ValidationError();
                        error.setMessage("Unable to access image");
                        error.addKey("imageUnavailable");
                        input.error((IValidationError)error);
                    }
                }
                catch (IOException e) {
                    ValidationError error = new ValidationError();
                    error.setMessage("Unable to access image");
                    error.addKey("imageUnavailable");
                    input.error((IValidationError)error);
                }
            } else {
                try {
                    WorkspaceInfo wsInfo = ((StyleInfo)this.styleModel.getObject()).getWorkspace();
                    ExternalGraphicPanel.this.getIconFromStyleDirectory(wsInfo, value);
                }
                catch (Exception e) {
                    ValidationError error = new ValidationError();
                    error.setMessage("File not found in styles directory or given path is invalid");
                    error.addKey("imageNotFound");
                    input.error((IValidationError)error);
                }
            }
        }
    }

    private class ChooseImageLink
    extends GeoServerAjaxFormLink {
        private final AbstractStylePage stylePage;
        private final CompoundPropertyModel<StyleInfo> styleModel;

        public ChooseImageLink(Form<?> styleForm, AbstractStylePage stylePage, CompoundPropertyModel<StyleInfo> styleModel) {
            super("chooseImage", styleForm);
            this.stylePage = stylePage;
            this.styleModel = styleModel;
        }

        protected void onClick(AjaxRequestTarget target, Form<?> form) {
            this.stylePage.getDialog().setTitle((IModel)new ParamResourceModel("chooseImage", (Component)this.stylePage, new Object[0]));
            this.stylePage.getDialog().setInitialWidth(385);
            this.stylePage.getDialog().setInitialHeight(175);
            GeoServerDialog.DialogDelegate delegate = new GeoServerDialog.DialogDelegate(){
                private ChooseImagePanel imagePanel;

                protected Component getContents(String id) {
                    this.imagePanel = new ChooseImagePanel(id, ((StyleInfo)ChooseImageLink.this.styleModel.getObject()).getWorkspace(), EXTENSIONS);
                    return this.imagePanel;
                }

                protected boolean onSubmit(AjaxRequestTarget target, Component contents) {
                    String imageFileName = this.imagePanel.getChoice();
                    if (Strings.isEmpty((String)imageFileName)) {
                        FileUpload fu = this.imagePanel.getFileUpload();
                        imageFileName = fu.getClientFileName();
                        int teller = 0;
                        GeoServerDataDirectory dd = (GeoServerDataDirectory)GeoServerApplication.get().getBeanOfType(GeoServerDataDirectory.class);
                        Resource res = dd.getStyles(((StyleInfo)ChooseImageLink.this.styleModel.getObject()).getWorkspace(), new String[]{imageFileName});
                        while (Resources.exists((Resource)res)) {
                            imageFileName = this.getImageFileName(fu, teller++);
                            res = dd.getStyles(((StyleInfo)ChooseImageLink.this.styleModel.getObject()).getWorkspace(), new String[]{imageFileName});
                        }
                        try (InputStream is = fu.getInputStream();
                             OutputStream os = res.out();){
                            IOUtils.copy((InputStream)is, (OutputStream)os);
                        }
                        catch (IOException e) {
                            ChooseImageLink.this.error((Serializable)((Object)e.getMessage()));
                            target.add(new Component[]{this.imagePanel.getFeedback()});
                            return false;
                        }
                    }
                    ExternalGraphicPanel.this.onlineResource.setModelObject((Object)imageFileName);
                    target.add(new Component[]{ExternalGraphicPanel.this.onlineResource});
                    return true;
                }

                private String getImageFileName(FileUpload fu, int teller) {
                    String name = fu.getClientFileName();
                    return FilenameUtils.getBaseName((String)name) + "." + teller + "." + FilenameUtils.getExtension((String)name);
                }

                public void onError(AjaxRequestTarget target, Form<?> form) {
                    target.add(new Component[]{this.imagePanel.getFeedback()});
                }
            };
            this.stylePage.getDialog().showOkCancel(target, delegate);
        }
    }
}

