/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.web.publish;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.validation.FormComponentFeedbackBorder;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.RangeValidator;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.web.publish.PublishedConfigurationPanel;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.LiveCollectionModel;
import org.geoserver.web.wicket.SRSListTextArea;

public class WFSLayerConfig
extends PublishedConfigurationPanel<LayerInfo> {
    private static final long serialVersionUID = 4264296611272179367L;
    protected GeoServerDialog dialog;

    public WFSLayerConfig(String id, IModel<LayerInfo> model) {
        super(id, model);
        TextField maxFeatures = new TextField("perReqFeatureLimit", (IModel)new PropertyModel(model, "resource.maxFeatures"));
        maxFeatures.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(0)));
        FormComponentFeedbackBorder mfb = new FormComponentFeedbackBorder("perReqFeaturesBorder");
        mfb.add(new Component[]{maxFeatures});
        this.add(new Component[]{mfb});
        TextField maxDecimals = new TextField("maxDecimals", (IModel)new PropertyModel(model, "resource.numDecimals"));
        maxFeatures.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(0)));
        FormComponentFeedbackBorder mdb = new FormComponentFeedbackBorder("maxDecimalsBorder");
        mdb.add(new Component[]{maxDecimals});
        this.add(new Component[]{mdb});
        CheckBox padWithZeros = new CheckBox("padWithZeros", (IModel)new PropertyModel(model, "resource.padWithZeros"));
        FormComponentFeedbackBorder pwzb = new FormComponentFeedbackBorder("padWithZerosBorder");
        pwzb.add(new Component[]{padWithZeros});
        this.add(new Component[]{pwzb});
        CheckBox forcedDecimal = new CheckBox("forcedDecimal", (IModel)new PropertyModel(model, "resource.forcedDecimal"));
        FormComponentFeedbackBorder fdb = new FormComponentFeedbackBorder("forcedDecimalBorder");
        fdb.add(new Component[]{forcedDecimal});
        this.add(new Component[]{fdb});
        CheckBox skipNumberMatched = new CheckBox("skipNumberMatched", (IModel)new PropertyModel(model, "resource.skipNumberMatched"));
        this.add(new Component[]{skipNumberMatched});
        CheckBox encodeMeasures = new CheckBox("encodeMeasures", (IModel)new PropertyModel(model, "resource.encodeMeasures"));
        this.add(new Component[]{encodeMeasures});
        CheckBox complexToSimple = new CheckBox("complexToSimple", (IModel)new PropertyModel(model, "resource.simpleConversionEnabled"));
        FormComponentFeedbackBorder complexToSimpleBorder = new FormComponentFeedbackBorder("complexToSimpleBorder");
        complexToSimpleBorder.add(new Component[]{complexToSimple});
        this.add(new Component[]{complexToSimpleBorder});
        this.dialog = new GeoServerDialog("wfsDialog");
        this.add(new Component[]{this.dialog});
        PropertyModel overrideServiceSRSModel = new PropertyModel(model, "resource.overridingServiceSRS");
        final CheckBox overrideServiceSRS = new CheckBox("overridingServiceSRS", (IModel)overrideServiceSRSModel);
        this.add(new Component[]{overrideServiceSRS});
        WebMarkupContainer otherSrsContainer = new WebMarkupContainer("otherSRSContainer");
        otherSrsContainer.setOutputMarkupId(true);
        this.add(new Component[]{otherSrsContainer});
        SRSListTextArea srsList = new SRSListTextArea("srs", (IModel)LiveCollectionModel.list((IModel)new PropertyModel(model, "resource.responseSRS")));
        srsList.setOutputMarkupId(true);
        srsList.setVisible(Boolean.TRUE.equals(overrideServiceSRSModel.getObject()));
        otherSrsContainer.add(new Component[]{srsList});
        overrideServiceSRS.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change", (TextArea)srsList, otherSrsContainer){
            private static final long serialVersionUID = -6590810763209350915L;
            final /* synthetic */ TextArea val$srsList;
            final /* synthetic */ WebMarkupContainer val$otherSrsContainer;
            {
                this.val$srsList = textArea;
                this.val$otherSrsContainer = webMarkupContainer;
                super(event);
            }

            protected void onUpdate(AjaxRequestTarget target) {
                Boolean visible = (Boolean)overrideServiceSRS.getConvertedInput();
                this.val$srsList.setVisible(visible.booleanValue());
                target.add(new Component[]{this.val$otherSrsContainer});
            }
        }});
        this.add(new Component[]{new AjaxLink<String>("skipNumberMatchedHelp"){
            private static final long serialVersionUID = 9222171216768726057L;

            public void onClick(AjaxRequestTarget target) {
                WFSLayerConfig.this.dialog.showInfo(target, (IModel)new StringResourceModel("skipNumberMatched", (Component)WFSLayerConfig.this, null), new IModel[]{new StringResourceModel("skipNumberMatched.message", (Component)WFSLayerConfig.this, null)});
            }
        }});
        this.add(new Component[]{new AjaxLink<String>("otherSRSHelp"){
            private static final long serialVersionUID = -1239179491855142211L;

            public void onClick(AjaxRequestTarget target) {
                WFSLayerConfig.this.dialog.showInfo(target, (IModel)new StringResourceModel("otherSRS", (Component)WFSLayerConfig.this, null), new IModel[]{new StringResourceModel("otherSRS.message", (Component)WFSLayerConfig.this, null)});
            }
        }});
        this.add(new Component[]{new AjaxLink<String>("coordinatesEncodingHelp"){
            private static final long serialVersionUID = 926171216768726057L;

            public void onClick(AjaxRequestTarget target) {
                WFSLayerConfig.this.dialog.showInfo(target, (IModel)new StringResourceModel("coordinatesEncodingTitle", (Component)WFSLayerConfig.this, null), new IModel[]{new StringResourceModel("coordinatesEncodingHelp.message", (Component)WFSLayerConfig.this, null)});
            }
        }});
    }
}

