/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.EnumChoiceRenderer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.Radio;
import org.apache.wicket.markup.html.form.RadioGroup;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.model.util.CollectionModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.validation.validator.RangeValidator;
import org.geoserver.config.ServiceInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Paths;
import org.geoserver.platform.resource.Resource;
import org.geoserver.web.data.resource.LocalesDropdown;
import org.geoserver.web.services.BaseServiceAdminPage;
import org.geoserver.web.util.MapModel;
import org.geoserver.web.wicket.LiveCollectionModel;
import org.geoserver.web.wicket.SRSListTextArea;
import org.geoserver.wfs.GMLInfo;
import org.geoserver.wfs.WFSGetFeatureOutputFormat;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.web.OutputTypesFormComponent;

public class WFSAdminPage
extends BaseServiceAdminPage<WFSInfo> {
    OutputTypesFormComponent getFeatureOutputTypesComponent;
    TreeSet<String> getFeatureAvailable;

    public WFSAdminPage() {
    }

    public WFSAdminPage(PageParameters pageParams) {
        super(pageParams);
    }

    public WFSAdminPage(WFSInfo service) {
        super((ServiceInfo)service);
    }

    protected Class<WFSInfo> getServiceClass() {
        return WFSInfo.class;
    }

    protected void build(final IModel info, Form form) {
        form.add(new Component[]{new TextField("maxFeatures").add(new Behavior[]{RangeValidator.minimum((Comparable)Integer.valueOf(0))})});
        form.add(new Component[]{new TextField("maxNumberOfFeaturesForPreview")});
        TextField dateFormatField = new TextField("csvDateFormat");
        dateFormatField.setModel((IModel)new PropertyModel((Object)info, "csvDateFormat"));
        form.add(new Component[]{dateFormatField});
        form.add(new Component[]{new CheckBox("featureBounding")});
        form.add(new Component[]{new CheckBox("hitsIgnoreMaxFeatures")});
        form.add(new Component[]{new CheckBox("simpleConversionEnabled")});
        RadioGroup sl = new RadioGroup("serviceLevel");
        form.add(new Component[]{sl});
        sl.add(new Component[]{new Radio("basic", (IModel)new Model((Serializable)WFSInfo.ServiceLevel.BASIC))});
        sl.add(new Component[]{new Radio("transactional", (IModel)new Model((Serializable)WFSInfo.ServiceLevel.TRANSACTIONAL))});
        sl.add(new Component[]{new Radio("complete", (IModel)new Model((Serializable)WFSInfo.ServiceLevel.COMPLETE))});
        this.getFeatureAvailable = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        for (WFSGetFeatureOutputFormat format : GeoServerExtensions.extensions(WFSGetFeatureOutputFormat.class)) {
            this.getFeatureAvailable.addAll(format.getOutputFormats());
        }
        ArrayList getFeatureSelected = new ArrayList();
        getFeatureSelected.addAll((Collection)new PropertyModel((Object)info, "getFeatureOutputTypes").getObject());
        ArrayList<String> getFeatureChoices = new ArrayList<String>();
        getFeatureChoices.addAll(this.getFeatureAvailable);
        Component[] componentArray = new Component[1];
        this.getFeatureOutputTypesComponent = new OutputTypesFormComponent("getFeatureOutputTypes", (IModel<List<String>>)new ListModel(getFeatureSelected), (IModel<Collection<String>>)new CollectionModel(getFeatureChoices), (Boolean)new PropertyModel((Object)info, "getFeatureOutputTypeCheckingEnabled").getObject());
        componentArray[0] = this.getFeatureOutputTypesComponent;
        form.add(componentArray);
        LoadableDetachableModel gml2Model = new LoadableDetachableModel(){

            public Object load() {
                return ((WFSInfo)info.getObject()).getGML().get(WFSInfo.Version.V_10);
            }
        };
        LoadableDetachableModel gml3Model = new LoadableDetachableModel(){

            public Object load() {
                return ((WFSInfo)info.getObject()).getGML().get(WFSInfo.Version.V_11);
            }
        };
        LoadableDetachableModel gml32Model = new LoadableDetachableModel(){

            protected Object load() {
                return ((WFSInfo)info.getObject()).getGML().get(WFSInfo.Version.V_20);
            }
        };
        form.add(new Component[]{new GMLPanel("gml2", (IModel<GMLInfo>)gml2Model, new String[0])});
        form.add(new Component[]{new GMLPanel("gml3", (IModel<GMLInfo>)gml3Model, new String[0])});
        form.add(new Component[]{new GMLPanel("gml32", (IModel<GMLInfo>)gml32Model, "application/gml+xml; version=3.2", "text/xml; subtype=gml/3.2", "text/xml")});
        form.add(new Component[]{new CheckBox("canonicalSchemaLocation")});
        RadioGroup eo = new RadioGroup("encodeFeatureMember");
        form.add(new Component[]{eo});
        eo.add(new Component[]{new Radio("featureMembers", (IModel)new Model((Serializable)Boolean.FALSE))});
        eo.add(new Component[]{new Radio("featureMember", (IModel)new Model((Serializable)Boolean.TRUE))});
        PropertyModel metadataModel = new PropertyModel((Object)info, "metadata");
        MapModel prjFormatModel = new MapModel((IModel)metadataModel, "SHAPE-ZIP_DEFAULT_PRJ_IS_ESRI");
        CheckBox defaultPrjFormat = new CheckBox("shapeZipPrjFormat", (IModel)prjFormatModel);
        form.add(new Component[]{defaultPrjFormat});
        form.add(new Component[]{new CheckBox("includeWFSRequestDumpFile")});
        try {
            GeoServerResourceLoader resourceLoader = (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class);
            Resource esriProjs = resourceLoader.get(Paths.path((String[])new String[]{"user_projections", "esri.properties"}));
            if (esriProjs.getType() != Resource.Type.RESOURCE) {
                defaultPrjFormat.setEnabled(false);
                defaultPrjFormat.getModel().setObject((Object)Boolean.FALSE);
                defaultPrjFormat.add(new Behavior[]{new AttributeModifier("title", (IModel)new Model((Serializable)((Object)"No esri.properties file found in the data directory's user_projections folder. This option is not available")))});
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, e.getMessage(), e);
        }
        SRSListTextArea srsList = new SRSListTextArea("srs", (IModel)LiveCollectionModel.list((IModel)new PropertyModel((Object)info, "sRS")));
        form.add(new Component[]{srsList});
        form.add(new Component[]{new AjaxLink<Object>("otherSRSHelp"){

            public void onClick(AjaxRequestTarget target) {
                WFSAdminPage.this.dialog.showInfo(target, (IModel)new StringResourceModel("otherSRS", (Component)WFSAdminPage.this, null), new IModel[]{new StringResourceModel("otherSRS.message", (Component)WFSAdminPage.this, null)});
            }
        }});
        form.add(new Component[]{new CheckBox("allowGlobalQueries")});
        form.add(new Component[]{new CheckBox("disableStoredQueriesManagement")});
        form.add(new Component[]{new LocalesDropdown("defaultLocale", (IModel)new PropertyModel((Object)info, "defaultLocale"))});
    }

    protected String getServiceName() {
        return "WFS";
    }

    protected boolean supportInternationalContent() {
        return true;
    }

    protected void handleSubmit(WFSInfo info) {
        info.setGetFeatureOutputTypeCheckingEnabled(this.getFeatureOutputTypesComponent.isOutputTypeCheckingEnabled());
        if (info.isGetFeatureOutputTypeCheckingEnabled()) {
            info.getGetFeatureOutputTypes().clear();
            info.getGetFeatureOutputTypes().addAll(this.getFeatureOutputTypesComponent.getPalette().getModelCollection());
        } else {
            info.getGetFeatureOutputTypes().clear();
        }
        super.handleSubmit((ServiceInfo)info);
    }

    static class GMLPanel
    extends Panel {
        public GMLPanel(String id, IModel<GMLInfo> gmlModel, String ... mimeTypes) {
            super(id, (IModel)new CompoundPropertyModel(gmlModel));
            List<GMLInfo.SrsNameStyle> choices = Arrays.asList(GMLInfo.SrsNameStyle.values());
            DropDownChoice srsNameStyle = new DropDownChoice("srsNameStyle", choices, (IChoiceRenderer)new EnumChoiceRenderer());
            this.add(new Component[]{srsNameStyle});
            this.add(new Component[]{new CheckBox("overrideGMLAttributes")});
            final GMLInfo gmlInfo = (GMLInfo)gmlModel.getObject();
            boolean mimesTypesProvided = mimeTypes.length != 0;
            boolean activated = gmlInfo.getMimeTypeToForce().isPresent();
            final DropDownChoice mimeTypeToForce = new DropDownChoice("mimeTypeToForce", (IModel)new Model((Serializable)((Object)((String)gmlInfo.getMimeTypeToForce().orElse(null)))), Arrays.asList(mimeTypes));
            mimeTypeToForce.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){

                protected void onUpdate(AjaxRequestTarget target) {
                    String value = (String)mimeTypeToForce.getModelObject();
                    gmlInfo.setMimeTypeToForce(value);
                }
            }});
            if (mimesTypesProvided) {
                mimeTypeToForce.setModelObject((Object)gmlInfo.getMimeTypeToForce().orElse(mimeTypes[0]));
            }
            mimeTypeToForce.setOutputMarkupId(mimesTypesProvided);
            mimeTypeToForce.setOutputMarkupPlaceholderTag(mimesTypesProvided);
            mimeTypeToForce.setVisible(mimesTypesProvided && activated);
            this.add(new Component[]{mimeTypeToForce});
            AjaxCheckBox checkBox = new AjaxCheckBox("forceGmlMimeType", (IModel)new Model((Serializable)Boolean.valueOf(activated))){

                protected void onUpdate(AjaxRequestTarget target) {
                    boolean checked = (Boolean)this.getModelObject();
                    if (checked) {
                        mimeTypeToForce.setVisible(true);
                        String value = (String)mimeTypeToForce.getModelObject();
                        gmlInfo.setMimeTypeToForce(value);
                    } else {
                        mimeTypeToForce.setVisible(false);
                        gmlInfo.setMimeTypeToForce(null);
                    }
                    target.add(new Component[]{mimeTypeToForce});
                }
            };
            checkBox.setVisible(mimesTypesProvided);
            this.add(new Component[]{checkBox});
            Label checkBoxLabel = new Label("forceGmlMimeTypeLabel", (IModel)new StringResourceModel("WFSAdminPage$GMLPanel.forceGmlMimeTypeLabel"));
            checkBoxLabel.setVisible(mimesTypesProvided);
            this.add(new Component[]{checkBoxLabel});
        }
    }
}

