/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.web;

import java.util.List;
import java.util.stream.Collectors;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.web.ServiceDescription;
import org.geoserver.web.ServiceLinkDescription;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSResourceVoter;
import org.geoserver.wfs.web.WFSServiceDescriptionProvider;
import org.junit.Assert;
import org.junit.Test;

public class WFSServiceDescriptionProviderTest
extends GeoServerSystemTestSupport {
    protected void setUpTestData(SystemTestData testData) throws Exception {
        testData.setUpDefault();
        testData.setUpDefaultRasterLayers();
    }

    @Test
    public void serviceDescriptorAndLinks() {
        WFSServiceDescriptionProvider provider = (WFSServiceDescriptionProvider)GeoServerExtensions.bean(WFSServiceDescriptionProvider.class);
        List services = provider.getServices(null, null);
        List links = provider.getServiceLinks(null, null);
        Assert.assertEquals((long)1L, (long)services.size());
        ServiceDescription wfs = (ServiceDescription)services.get(0);
        for (ServiceLinkDescription link : links) {
            Assert.assertEquals((String)"crosslink", (Object)wfs.getServiceType(), (Object)link.getServiceType());
            if (link.getVersion().getMajor().equals(2)) {
                Assert.assertTrue((String)"acceptversions", (boolean)link.getLink().contains("&acceptversions="));
                continue;
            }
            Assert.assertTrue((String)"version", (boolean)link.getLink().contains("&version="));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void disabledServiceCheck() {
        WFSServiceDescriptionProvider provider = (WFSServiceDescriptionProvider)GeoServerExtensions.bean(WFSServiceDescriptionProvider.class);
        Catalog catalog = this.getCatalog();
        GeoServer geoServer = this.getGeoServer();
        GeoServerInfo global = geoServer.getGlobal();
        WFSInfo wfs = (WFSInfo)geoServer.getService(WFSInfo.class);
        WorkspaceInfo cite = catalog.getWorkspaceByName("cite");
        LayerInfo buildings = catalog.getLayerByName("Buildings");
        try {
            List services = provider.getServices(null, null).stream().filter(s -> s.isAvailable()).collect(Collectors.toList());
            Assert.assertEquals((long)1L, (long)services.size());
            services = provider.getServices(cite, null).stream().filter(s -> s.isAvailable()).collect(Collectors.toList());
            Assert.assertEquals((long)1L, (long)services.size());
            services = provider.getServices(cite, (PublishedInfo)buildings).stream().filter(s -> s.isAvailable()).collect(Collectors.toList());
            Assert.assertEquals((long)1L, (long)services.size());
            global.setGlobalServices(Boolean.valueOf(false));
            geoServer.save(global);
            services = provider.getServices(null, null).stream().filter(s -> s.isAvailable()).collect(Collectors.toList());
            Assert.assertEquals((long)0L, (long)services.size());
            services = provider.getServices(cite, null).stream().filter(s -> s.isAvailable()).collect(Collectors.toList());
            Assert.assertEquals((long)1L, (long)services.size());
            services = provider.getServices(cite, (PublishedInfo)buildings).stream().filter(s -> s.isAvailable()).collect(Collectors.toList());
            Assert.assertEquals((long)1L, (long)services.size());
            global.setGlobalServices(Boolean.valueOf(true));
            geoServer.save(global);
            services = provider.getServices(null, null).stream().filter(s -> s.isAvailable()).collect(Collectors.toList());
            Assert.assertEquals((long)1L, (long)services.size());
            services = provider.getServices(cite, null).stream().filter(s -> s.isAvailable()).collect(Collectors.toList());
            Assert.assertEquals((long)1L, (long)services.size());
            services = provider.getServices(cite, (PublishedInfo)buildings).stream().filter(s -> s.isAvailable()).collect(Collectors.toList());
            Assert.assertEquals((long)1L, (long)services.size());
            wfs.setEnabled(false);
            geoServer.save((ServiceInfo)wfs);
            services = provider.getServices(null, null).stream().filter(s -> s.isAvailable()).collect(Collectors.toList());
            Assert.assertEquals((long)0L, (long)services.size());
            services = provider.getServices(cite, null).stream().filter(s -> s.isAvailable()).collect(Collectors.toList());
            Assert.assertEquals((long)0L, (long)services.size());
            services = provider.getServices(cite, (PublishedInfo)buildings).stream().filter(s -> s.isAvailable()).collect(Collectors.toList());
            Assert.assertEquals((long)0L, (long)services.size());
        }
        finally {
            global.setGlobalServices(Boolean.valueOf(true));
            geoServer.save(global);
            wfs.setEnabled(true);
            geoServer.save((ServiceInfo)wfs);
        }
    }

    @Test
    public void ignoreCoverage() {
        WFSServiceDescriptionProvider provider = (WFSServiceDescriptionProvider)GeoServerExtensions.bean(WFSServiceDescriptionProvider.class);
        Catalog catalog = this.getCatalog();
        WorkspaceInfo gs = catalog.getWorkspaceByName("gs");
        LayerInfo world = catalog.getLayerByName("World");
        WFSResourceVoter voter = new WFSResourceVoter();
        Assert.assertTrue((boolean)voter.hideService("WFS", world.getResource()));
        List services = provider.getServices(gs, (PublishedInfo)world);
        Assert.assertEquals((long)1L, (long)services.size());
    }
}

