/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.web;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.Service;
import org.geoserver.web.ServiceDescription;
import org.geoserver.web.ServiceDescriptionProvider;
import org.geoserver.web.ServiceLinkDescription;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSResourceVoter;
import org.geoserver.wfs.WebFeatureService;
import org.geoserver.wfs.WebFeatureService20;
import org.geotools.util.logging.Logging;

public class WFSServiceDescriptionProvider
extends ServiceDescriptionProvider {
    static final Logger LOGGER = Logging.getLogger(WFSServiceDescriptionProvider.class);
    public static final String SERVICE_TYPE = "WFS";
    GeoServer geoserver;
    Catalog catalog;

    public WFSServiceDescriptionProvider(GeoServer gs) {
        super(SERVICE_TYPE);
        this.geoserver = gs;
        this.catalog = gs.getCatalog();
    }

    protected WFSInfo info(WorkspaceInfo workspaceInfo, PublishedInfo layerInfo) {
        WFSInfo info = null;
        if (workspaceInfo != null) {
            info = (WFSInfo)this.geoserver.getService(workspaceInfo, WFSInfo.class);
        }
        if (info == null) {
            info = (WFSInfo)this.geoserver.getService(WFSInfo.class);
        }
        return info;
    }

    protected boolean isAvailable(String serviceType, ServiceInfo serviceInfo, PublishedInfo layerInfo) {
        WFSResourceVoter voter;
        if (layerInfo != null && layerInfo instanceof LayerInfo && (voter = new WFSResourceVoter()).hideService(serviceType, ((LayerInfo)layerInfo).getResource())) {
            return false;
        }
        return super.isAvailable(serviceType, serviceInfo, layerInfo);
    }

    public List<ServiceDescription> getServices(WorkspaceInfo workspaceInfo, PublishedInfo layerInfo) {
        ArrayList<ServiceDescription> descriptions = new ArrayList<ServiceDescription>();
        WFSInfo info = this.info(workspaceInfo, layerInfo);
        if (workspaceInfo != null || this.geoserver.getGlobal().isGlobalServices().booleanValue()) {
            descriptions.add(this.description(this.serviceType, (ServiceInfo)info, workspaceInfo, layerInfo));
        }
        return descriptions;
    }

    protected String getVersionParameterName(Service service) {
        if (service.getVersion().getMajor().toString().equals("2")) {
            return "acceptversions";
        }
        return "version";
    }

    public List<ServiceLinkDescription> getServiceLinks(WorkspaceInfo workspaceInfo, PublishedInfo layerInfo) {
        ArrayList<ServiceLinkDescription> links = new ArrayList<ServiceLinkDescription>();
        if (workspaceInfo == null && !this.geoserver.getGlobal().isGlobalServices().booleanValue()) {
            return links;
        }
        List extensions = GeoServerExtensions.extensions(Service.class);
        for (Service service : extensions) {
            if (!(service.getService() instanceof WebFeatureService20) && !(service.getService() instanceof WebFeatureService)) continue;
            String link = null;
            if (service.getOperations().contains("GetCapabilities")) {
                link = this.getCapabilitiesURL(workspaceInfo, layerInfo, service);
            } else if (service.getCustomCapabilitiesLink() != null) {
                link = service.getCustomCapabilitiesLink();
            }
            if (link == null) continue;
            links.add(new ServiceLinkDescription(this.serviceType, service.getVersion(), link, workspaceInfo != null ? workspaceInfo.getName() : null, layerInfo != null ? layerInfo.getName() : null));
        }
        return links;
    }
}

