/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.web;

import java.io.Serializable;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.web.ComponentBuilder;
import org.geoserver.web.FormTestPage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.wfs.web.publish.WFSLayerConfig;
import org.junit.Test;

public final class WFSLayerConfigTest
extends GeoServerWicketTestSupport {
    @Test
    public void testEncodeMeasuresCheckbox() {
        LayerInfo layer = this.getCatalog().getLayerByName(MockData.PONDS.getLocalPart());
        Model model = new Model((Serializable)layer);
        FormTestPage page = new FormTestPage((ComponentBuilder & Serializable)id -> new WFSLayerConfig(id, (IModel)model));
        tester.startPage((Page)page);
        tester.assertRenderedPage(FormTestPage.class);
        tester.assertComponent("form", Form.class);
        tester.assertComponent("form:panel:encodeMeasures", CheckBox.class);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("panel:encodeMeasures", false);
        ft.submit();
        tester.assertModelValue("form:panel:encodeMeasures", (Object)false);
    }

    @Test
    public void testForceDecimalCheckbox() {
        LayerInfo layer = this.getCatalog().getLayerByName(MockData.PONDS.getLocalPart());
        Model model = new Model((Serializable)layer);
        FormTestPage page = new FormTestPage((ComponentBuilder & Serializable)id -> new WFSLayerConfig(id, (IModel)model));
        tester.startPage((Page)page);
        tester.assertRenderedPage(FormTestPage.class);
        tester.assertComponent("form", Form.class);
        tester.assertComponent("form:panel:forcedDecimalBorder:forcedDecimalBorder_body:forcedDecimal", CheckBox.class);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("panel:forcedDecimalBorder:forcedDecimalBorder_body:forcedDecimal", true);
        ft.submit();
        tester.assertModelValue("form:panel:forcedDecimalBorder:forcedDecimalBorder_body:forcedDecimal", (Object)true);
    }

    @Test
    public void testPadWithZerosCheckbox() {
        LayerInfo layer = this.getCatalog().getLayerByName(MockData.PONDS.getLocalPart());
        Model model = new Model((Serializable)layer);
        FormTestPage page = new FormTestPage((ComponentBuilder & Serializable)id -> new WFSLayerConfig(id, (IModel)model));
        tester.startPage((Page)page);
        tester.assertRenderedPage(FormTestPage.class);
        tester.assertComponent("form", Form.class);
        tester.assertComponent("form:panel:padWithZerosBorder:padWithZerosBorder_body:padWithZeros", CheckBox.class);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("panel:padWithZerosBorder:padWithZerosBorder_body:padWithZeros", true);
        ft.submit();
        tester.assertModelValue("form:panel:padWithZerosBorder:padWithZerosBorder_body:padWithZeros", (Object)true);
    }
}

