/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.web;

import java.util.Arrays;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.RangeValidator;
import org.geoserver.config.ServiceInfo;
import org.geoserver.wcs.WCSInfo;
import org.geoserver.web.data.resource.LocalesDropdown;
import org.geoserver.web.services.BaseServiceAdminPage;
import org.geoserver.web.wicket.LiveCollectionModel;
import org.geoserver.web.wicket.SRSListTextArea;
import org.geotools.coverage.grid.io.OverviewPolicy;

public class WCSAdminPage
extends BaseServiceAdminPage<WCSInfo> {
    public WCSAdminPage() {
    }

    public WCSAdminPage(PageParameters pageParams) {
        super(pageParams);
    }

    public WCSAdminPage(WCSInfo service) {
        super((ServiceInfo)service);
    }

    protected Class<WCSInfo> getServiceClass() {
        return WCSInfo.class;
    }

    protected void build(IModel info, Form form) {
        form.add(new Component[]{new DropDownChoice("overviewPolicy", Arrays.asList(OverviewPolicy.values()), (IChoiceRenderer)new OverviewPolicyRenderer())});
        form.add(new Component[]{new CheckBox("subsamplingEnabled")});
        SRSListTextArea srsList = new SRSListTextArea("srs", (IModel)LiveCollectionModel.list((IModel)new PropertyModel((Object)info, "sRS")));
        form.add(new Component[]{srsList});
        TextField maxInputMemory = new TextField("maxInputMemory");
        maxInputMemory.add(new Behavior[]{RangeValidator.minimum((Comparable)Long.valueOf(0L))});
        form.add(new Component[]{maxInputMemory});
        TextField maxOutputMemory = new TextField("maxOutputMemory");
        maxOutputMemory.add(new Behavior[]{RangeValidator.minimum((Comparable)Long.valueOf(0L))});
        form.add(new Component[]{maxOutputMemory});
        TextField defaultDeflateCompressionLevel = new TextField("defaultDeflateCompressionLevel");
        defaultDeflateCompressionLevel.add((IValidator)RangeValidator.range((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(9)));
        form.add(new Component[]{defaultDeflateCompressionLevel});
        TextField maxRequestedDimensionValues = new TextField("maxRequestedDimensionValues");
        maxRequestedDimensionValues.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(0)));
        form.add(new Component[]{maxRequestedDimensionValues});
        form.add(new Component[]{new CheckBox("latLon")});
        form.add(new Component[]{new LocalesDropdown("defaultLocale", (IModel)new PropertyModel((Object)info, "defaultLocale"))});
    }

    protected String getServiceName() {
        return "WCS";
    }

    protected boolean supportInternationalContent() {
        return true;
    }

    private class OverviewPolicyRenderer
    extends ChoiceRenderer<OverviewPolicy> {
        private OverviewPolicyRenderer() {
        }

        public Object getDisplayValue(OverviewPolicy object) {
            return new StringResourceModel(object.name(), (Component)WCSAdminPage.this, null).getString();
        }

        public String getIdValue(OverviewPolicy object, int index) {
            return object.name();
        }
    }
}

