/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.web.publish;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.extensions.markup.html.form.palette.theme.DefaultTheme;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.ListMultipleChoice;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.web.publish.PublishedConfigurationPanel;
import org.geoserver.web.wicket.LiveCollectionModel;
import org.geoserver.web.wicket.SimpleChoiceRenderer;
import org.geotools.util.SuppressFBWarnings;

public class WCSLayerConfig
extends PublishedConfigurationPanel<LayerInfo> {
    private static final long serialVersionUID = 6120092654147588736L;
    private static final List<String> WCS_FORMATS = Arrays.asList("GIF", "PNG", "JPEG", "TIFF", "GEOTIFF", "IMAGEMOSAIC");
    private static final List<String> INTERPOLATIONS = Arrays.asList("nearest neighbor", "bilinear", "bicubic");
    @SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD"})
    private List<String> selectedRequestSRSs;
    @SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD"})
    private List<String> selectedResponseSRSs;
    private String newRequestSRS;
    private String newResponseSRS;

    public WCSLayerConfig(String id, IModel<LayerInfo> model) {
        super(id, model);
        final CoverageInfo coverage = (CoverageInfo)((LayerInfo)this.getPublishedInfo()).getResource();
        this.add(new Component[]{new ListMultipleChoice("requestSRS", (IModel)new PropertyModel((Object)this, "selectedRequestSRSs"), coverage.getRequestSRS())});
        this.add(new Component[]{new TextField("newRequestSRS", (IModel)new PropertyModel((Object)this, "newRequestSRS"))});
        this.add(new Component[]{new Button("deleteSelectedRequestSRSs"){
            private static final long serialVersionUID = 8363252127939759315L;

            public void onSubmit() {
                coverage.getRequestSRS().removeAll(WCSLayerConfig.this.selectedRequestSRSs);
                WCSLayerConfig.this.selectedRequestSRSs.clear();
            }
        }});
        this.add(new Component[]{new Button("addNewRequestSRS"){
            private static final long serialVersionUID = -3493317500980471055L;

            public void onSubmit() {
                coverage.getRequestSRS().add(WCSLayerConfig.this.newRequestSRS);
                WCSLayerConfig.this.newRequestSRS = "";
            }
        }});
        this.add(new Component[]{new ListMultipleChoice("responseSRS", (IModel)new PropertyModel((Object)this, "selectedResponseSRSs"), coverage.getResponseSRS())});
        this.add(new Component[]{new TextField("newResponseSRS", (IModel)new PropertyModel((Object)this, "newResponseSRS"))});
        this.add(new Component[]{new Button("deleteSelectedResponseSRSs"){
            private static final long serialVersionUID = -8727831157546262491L;

            public void onSubmit() {
                coverage.getResponseSRS().removeAll(WCSLayerConfig.this.selectedResponseSRSs);
                WCSLayerConfig.this.selectedResponseSRSs.clear();
            }
        }});
        this.add(new Component[]{new Button("addNewResponseSRS"){
            private static final long serialVersionUID = -2888152896129259019L;

            public void onSubmit() {
                coverage.getResponseSRS().add(WCSLayerConfig.this.newResponseSRS);
                WCSLayerConfig.this.newResponseSRS = "";
            }
        }});
        this.add(new Component[]{new DropDownChoice("defaultInterpolationMethod", (IModel)new PropertyModel((Object)coverage, "defaultInterpolationMethod"), (IModel)new WCSInterpolationModel())});
        Palette<String> interpolationMethods = new Palette<String>("interpolationMethods", (IModel)LiveCollectionModel.list((IModel)new PropertyModel((Object)coverage, "interpolationMethods")), (IModel)new WCSInterpolationModel(), (IChoiceRenderer)new SimpleChoiceRenderer(), 7, false){
            private static final long serialVersionUID = 6815545819673802290L;

            public Component newSelectedHeader(String componentId) {
                return new Label(componentId, (IModel)new ResourceModel("InterpolationMethodsPalette.selectedHeader"));
            }

            public Component newAvailableHeader(String componentId) {
                return new Label(componentId, (IModel)new ResourceModel("InterpolationMethodsPalette.availableHeader"));
            }
        };
        interpolationMethods.add(new Behavior[]{new DefaultTheme()});
        this.add(new Component[]{interpolationMethods});
        TextField nativeFormat = new TextField("nativeFormat", (IModel)new PropertyModel((Object)coverage, "nativeFormat"));
        nativeFormat.setEnabled(false);
        this.add(new Component[]{nativeFormat});
        Palette<String> formatPalette = new Palette<String>("formatPalette", (IModel)LiveCollectionModel.list((IModel)new PropertyModel((Object)coverage, "supportedFormats")), (IModel)new WCSFormatsModel(), (IChoiceRenderer)new SimpleChoiceRenderer(), 10, false){
            private static final long serialVersionUID = -2463012775305597908L;

            public Component newSelectedHeader(String componentId) {
                return new Label(componentId, (IModel)new ResourceModel("FormatsPalette.selectedHeader"));
            }

            public Component newAvailableHeader(String componentId) {
                return new Label(componentId, (IModel)new ResourceModel("FormatsPalette.availableHeader"));
            }
        };
        formatPalette.add(new Behavior[]{new DefaultTheme()});
        this.add(new Component[]{formatPalette});
    }

    static class WCSInterpolationModel
    extends LoadableDetachableModel<ArrayList<String>> {
        private static final long serialVersionUID = 7328612985196203413L;

        WCSInterpolationModel() {
            super(new ArrayList<String>(INTERPOLATIONS));
        }

        protected ArrayList<String> load() {
            return new ArrayList<String>(INTERPOLATIONS);
        }
    }

    static class WCSFormatsModel
    extends LoadableDetachableModel<ArrayList<String>> {
        private static final long serialVersionUID = 1802421566341456007L;

        WCSFormatsModel() {
            super(new ArrayList<String>(WCS_FORMATS));
        }

        protected ArrayList<String> load() {
            return new ArrayList<String>(WCS_FORMATS);
        }
    }
}

