/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.web;

import java.util.HashMap;
import javax.xml.namespace.QName;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.Catalog;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.AccessMode;
import org.geoserver.web.GeoServerWicketTestSupport;

public abstract class GeoServerWicketCoverageTestSupport
extends GeoServerWicketTestSupport {
    protected static Catalog catalog;
    protected static XpathEngine xp;
    public static String WCS_PREFIX;
    public static String WCS_URI;
    public static QName TASMANIA_DEM;
    public static QName TASMANIA_BM;
    public static QName ROTATED_CAD;
    public static QName WORLD;
    public static String TIFF;

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        this.addLayerAccessRule("*", "*", AccessMode.READ, new String[]{"*"});
        this.addLayerAccessRule("*", "*", AccessMode.WRITE, new String[]{"*"});
        catalog = this.getCatalog();
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("ows", "http://www.opengis.net/ows/1.1");
        namespaces.put("gml", "http://www.opengis.net/gml");
        namespaces.put("wfs", "http://www.opengis.net/wfs");
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        namespaces.put("feature", "http://geoserver.sf.net");
        SystemTestData.registerNamespaces(namespaces);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        xp = XMLUnit.newXpathEngine();
        this.addWcs11Coverages(testData);
    }

    public void addWcs11Coverages(SystemTestData testData) throws Exception {
        String styleName = "raster";
        testData.addStyle(styleName, "raster.sld", MockData.class, this.getCatalog());
        HashMap<SystemTestData.LayerProperty, String> props = new HashMap<SystemTestData.LayerProperty, String>();
        props.put(SystemTestData.LayerProperty.STYLE, styleName);
        testData.addRasterLayer(TASMANIA_DEM, "tazdem.tiff", TIFF, props, MockData.class, this.getCatalog());
        testData.addRasterLayer(TASMANIA_BM, "tazbm.tiff", TIFF, props, MockData.class, this.getCatalog());
        testData.addRasterLayer(ROTATED_CAD, "rotated.tiff", TIFF, props, MockData.class, this.getCatalog());
        testData.addRasterLayer(WORLD, "world.tiff", TIFF, props, MockData.class, this.getCatalog());
    }

    static {
        WCS_PREFIX = "wcs";
        WCS_URI = "http://www.opengis.net/wcs/1.1.1";
        TASMANIA_DEM = new QName(WCS_URI, "DEM", WCS_PREFIX);
        TASMANIA_BM = new QName(WCS_URI, "BlueMarble", WCS_PREFIX);
        ROTATED_CAD = new QName(WCS_URI, "RotatedCad", WCS_PREFIX);
        WORLD = new QName(WCS_URI, "World", WCS_PREFIX);
        TIFF = "tiff";
    }
}

