/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.security.ldap;

import java.util.Optional;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.security.ldap.LDAPBaseSecurityServiceConfig;
import org.geoserver.security.ldap.LDAPRoleServiceConfig;
import org.geoserver.security.web.role.RoleServicePanel;

public class LDAPRoleServicePanel
extends RoleServicePanel<LDAPRoleServiceConfig> {
    private static final long serialVersionUID = -67788557484913489L;
    private static final String USE_NESTED_PARENT_GROUPS = "useNestedParentGroups";
    private static final String MAX_GROUP_SEARCH_LEVEL = "maxGroupSearchLevel";
    private static final String NESTED_GROUP_SEARCH_FILTER = "nestedGroupSearchFilter";
    private static final String NESTED_SEARCH_FIELDS_CONTAINER = "nestedSearchFieldsContainer";

    public LDAPRoleServicePanel(String id, IModel<LDAPRoleServiceConfig> model) {
        super(id, model);
        this.add(new Component[]{new TextField("serverURL").setRequired(true)});
        this.add(new Component[]{new CheckBox("useTLS")});
        this.add(new Component[]{new TextField("groupSearchBase").setRequired(true)});
        this.add(new Component[]{new TextField("groupSearchFilter")});
        this.add(new Component[]{new TextField("allGroupsSearchFilter")});
        this.add(new Component[]{new TextField("userFilter")});
        TextField rolePrefixField = new TextField("rolePrefix");
        rolePrefixField.setConvertEmptyInputStringToNull(false);
        this.add(new Component[]{rolePrefixField});
        this.add(new Component[]{new CheckBox("convertToUpperCase")});
        this.add(new Component[]{new AjaxCheckBox("bindBeforeGroupSearch"){
            private static final long serialVersionUID = -1675695153498067857L;

            protected void onUpdate(AjaxRequestTarget target) {
                WebMarkupContainer c = (WebMarkupContainer)LDAPRoleServicePanel.this.get("authenticationPanelContainer");
                LDAPAuthenticationPanel ldapAuthenticationPanel = (LDAPAuthenticationPanel)c.get("authenticationPanel");
                ldapAuthenticationPanel.resetModel();
                ldapAuthenticationPanel.setVisible((Boolean)this.getModelObject());
                target.add(new Component[]{c});
            }
        }});
        this.hierarchicalGroupsInit();
        LDAPAuthenticationPanel authPanel = new LDAPAuthenticationPanel("authenticationPanel");
        authPanel.setVisible(((LDAPRoleServiceConfig)model.getObject()).isBindBeforeGroupSearch());
        this.add(new Component[]{new WebMarkupContainer("authenticationPanelContainer").add(new Component[]{authPanel}).setOutputMarkupId(true)});
    }

    private void hierarchicalGroupsInit() {
        final WebMarkupContainer nestedSearchFieldsContainer = new WebMarkupContainer(NESTED_SEARCH_FIELDS_CONTAINER);
        nestedSearchFieldsContainer.setOutputMarkupPlaceholderTag(true);
        nestedSearchFieldsContainer.setOutputMarkupId(true);
        this.add(new Component[]{nestedSearchFieldsContainer});
        Optional<LDAPRoleServiceConfig> useNestedOpt = Optional.of(this).map(x -> x.configModel).map(IModel::getObject);
        boolean useNestedActivated = useNestedOpt.map(LDAPBaseSecurityServiceConfig::isUseNestedParentGroups).orElse(false);
        nestedSearchFieldsContainer.setVisible(useNestedActivated);
        AjaxCheckBox useNestedCheckbox = new AjaxCheckBox(USE_NESTED_PARENT_GROUPS){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                AjaxCheckBox cb = (AjaxCheckBox)LDAPRoleServicePanel.this.get(LDAPRoleServicePanel.USE_NESTED_PARENT_GROUPS);
                boolean value = (Boolean)cb.getModelObject();
                nestedSearchFieldsContainer.setVisible(value);
                target.add(new Component[]{nestedSearchFieldsContainer});
            }
        };
        this.add(new Component[]{useNestedCheckbox});
        nestedSearchFieldsContainer.add(new Component[]{new TextField(MAX_GROUP_SEARCH_LEVEL)});
        nestedSearchFieldsContainer.add(new Component[]{new TextField(NESTED_GROUP_SEARCH_FILTER)});
    }

    class LDAPAuthenticationPanel
    extends FormComponentPanel<String> {
        private static final long serialVersionUID = 8919421089437979222L;

        public LDAPAuthenticationPanel(String id) {
            super(id, (IModel)new Model());
            this.add(new Component[]{new TextField("user")});
            PasswordTextField pwdField = new PasswordTextField("password");
            pwdField.setResetPassword(false);
            this.add(new Component[]{pwdField});
        }

        public void resetModel() {
            this.get("user").setDefaultModelObject(null);
            this.get("password").setDefaultModelObject(null);
        }
    }
}

