/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.csp;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.DefaultItemReuseStrategy;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.geoserver.security.csp.CSPPolicy;
import org.geoserver.security.csp.CSPRule;
import org.geoserver.security.web.csp.CSPRulePage;
import org.geoserver.web.CatalogIconFactory;
import org.geoserver.web.GeoServerBasePage;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.Icon;
import org.geoserver.web.wicket.ImageAjaxLink;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.ReorderableTablePanel;
import org.geoserver.web.wicket.SimpleAjaxLink;

public class CSPRulePanel
extends Panel {
    private static final long serialVersionUID = 6368251831224251873L;
    private static final GeoServerDataProvider.Property<CSPRule> ENABLED = new GeoServerDataProvider.BeanProperty("enabled", "enabled");
    private static final GeoServerDataProvider.Property<CSPRule> NAME = new GeoServerDataProvider.BeanProperty("name", "name");
    private static final GeoServerDataProvider.Property<CSPRule> DESCRIPTION = new GeoServerDataProvider.BeanProperty("description", "description");
    private static final GeoServerDataProvider.Property<CSPRule> FILTER = new GeoServerDataProvider.BeanProperty("filter", "filter");
    private static final GeoServerDataProvider.Property<CSPRule> DIRECTIVES = new GeoServerDataProvider.BeanProperty("directives", "directives");
    private static final GeoServerDataProvider.Property<CSPRule> REMOVE = new GeoServerDataProvider.PropertyPlaceholder("remove");
    private static final List<GeoServerDataProvider.Property<CSPRule>> PROPERTIES = List.of(ENABLED, NAME, DESCRIPTION, FILTER, DIRECTIVES, REMOVE);
    private CSPPolicy policy = null;
    private CSPRuleTablePanel tablePanel = null;

    public CSPRulePanel(String id, final CSPPolicy policy) {
        super(id);
        this.policy = policy;
        this.add(new Component[]{new AjaxLink<Void>("add"){
            private static final long serialVersionUID = 7028097965705654491L;

            public void onClick(AjaxRequestTarget target) {
                CSPRulePage page = new CSPRulePage(new CSPRule(), policy);
                this.setResponsePage((IRequestablePage)page.setReturnPage(this.getPage()));
            }
        }});
        this.tablePanel = new CSPRuleTablePanel("table", policy.getRules());
        this.add(new Component[]{this.tablePanel});
    }

    private static IModel<List<GeoServerDataProvider.Property<CSPRule>>> getProperties() {
        return new LoadableDetachableModel<List<GeoServerDataProvider.Property<CSPRule>>>(){
            private static final long serialVersionUID = 1880449575748893130L;

            protected List<GeoServerDataProvider.Property<CSPRule>> load() {
                return PROPERTIES;
            }
        };
    }

    private class CSPRuleTablePanel
    extends ReorderableTablePanel<CSPRule> {
        private static final long serialVersionUID = -4762272059375502701L;

        public CSPRuleTablePanel(String id, List<CSPRule> rules) {
            super(id, CSPRule.class, rules, CSPRulePanel.getProperties());
            this.setItemReuseStrategy(DefaultItemReuseStrategy.getInstance());
            this.setFilterable(false);
            this.setPageable(false);
        }

        protected Component getComponentForProperty(String id, IModel<CSPRule> itemModel, GeoServerDataProvider.Property<CSPRule> property) {
            if (property == NAME) {
                return this.editLink(id, itemModel, property.getModel(itemModel));
            }
            if (property == DESCRIPTION) {
                return new Icon(id, new PackageResourceReference(GeoServerBasePage.class, "img/icons/silk/information.png"), (IModel)Model.of((Serializable)((Object)((String)property.getModel(itemModel).getObject())))).setOutputMarkupId(true);
            }
            if (property == REMOVE) {
                return this.removeLink(id, (CSPRule)itemModel.getObject());
            }
            if (Boolean.TRUE.equals(property.getModel(itemModel).getObject())) {
                return new Icon(id, CatalogIconFactory.ENABLED_ICON);
            }
            if (Boolean.FALSE.equals(property.getModel(itemModel).getObject())) {
                return new Label(id, (Serializable)((Object)""));
            }
            return new Label(id, property.getModel(itemModel));
        }

        private Component editLink(String id, final IModel<CSPRule> model, IModel<?> label) {
            return new SimpleAjaxLink<CSPRule>(id, model, label){
                private static final long serialVersionUID = 1567366293977781250L;

                protected void onClick(AjaxRequestTarget target) {
                    CSPPolicy policy = CSPRulePanel.this.policy;
                    CSPRulePage page = new CSPRulePage((CSPRule)model.getObject(), policy);
                    this.setResponsePage((IRequestablePage)page.setReturnPage(this.getPage()));
                }
            };
        }

        private Component removeLink(String id, final CSPRule rule) {
            ImageAjaxLink<Void> link = new ImageAjaxLink<Void>(id, new PackageResourceReference(((Object)((Object)this)).getClass(), "../img/icons/silk/delete.png")){
                private static final long serialVersionUID = -3140594684451087223L;

                protected void onClick(AjaxRequestTarget target) {
                    CSPRulePanel.this.policy.getRules().remove(rule);
                    target.add(new Component[]{CSPRulePanel.this.tablePanel});
                }
            };
            link.getImage().add(new Behavior[]{new AttributeModifier("alt", (IModel)new ParamResourceModel("th.remove", (Component)CSPRulePanel.this, new Object[0]))});
            return link;
        }
    }
}

