/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.role;

import java.io.Serializable;
import org.apache.wicket.Page;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.web.AbstractSecurityPage;
import org.geoserver.security.web.AbstractSecurityWicketTestSupport;
import org.geoserver.security.web.SecurityNamedServiceEditPage;
import org.geoserver.security.web.role.EditRolePage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EditRolePageTest
extends AbstractSecurityWicketTestSupport {
    EditRolePage page;

    @Before
    public void init() throws Exception {
        this.doInitialize();
        this.clearServices();
        this.deactivateRORoleService();
        this.deactivateROUGService();
    }

    protected void doInitialize() throws Exception {
        this.initializeForXML();
    }

    @Test
    public void testFill() throws Exception {
        this.doTestFill();
    }

    @Test
    public void testFill2() throws Exception {
        this.doTestFill2();
    }

    protected void doTestFill() throws Exception {
        this.insertValues();
        AbstractSecurityPage returnPage = this.initializeForRoleServiceNamed(this.getRoleServiceName());
        this.page = (EditRolePage)new EditRolePage(this.getRoleServiceName(), this.gaService.getRoleByName("ROLE_WFS")).setReturnPage((Page)returnPage);
        tester.startPage((Page)this.page);
        tester.assertRenderedPage(EditRolePage.class);
        Assert.assertFalse((boolean)tester.getComponentFromLastRenderedPage("form:name").isEnabled());
        Assert.assertTrue((boolean)tester.getComponentFromLastRenderedPage("form:properties").isEnabled());
        Assert.assertTrue((boolean)tester.getComponentFromLastRenderedPage("form:parent").isEnabled());
        tester.assertVisible("form:save");
        tester.assertModelValue("form:name", (Object)"ROLE_WFS");
        tester.assertModelValue("form:parent", (Object)"ROLE_AUTHENTICATED");
        FormTester form = tester.newFormTester("form");
        form.setValue("parent", null);
        form.submit("save");
        tester.assertRenderedPage(SecurityNamedServiceEditPage.class);
        tester.assertErrorMessages((Serializable[])new String[0]);
        GeoServerRole role = this.gaService.getRoleByName("ROLE_WFS");
        Assert.assertNotNull((Object)role);
        GeoServerRole parentRole = this.gaService.getParentRole(role);
        Assert.assertNull((Object)parentRole);
    }

    protected void doTestFill2() throws Exception {
        this.insertValues();
        AbstractSecurityPage returnPage = this.initializeForRoleServiceNamed(this.getRoleServiceName());
        this.page = (EditRolePage)new EditRolePage(this.getRoleServiceName(), this.gaService.getRoleByName("ROLE_AUTHENTICATED")).setReturnPage((Page)returnPage);
        tester.startPage((Page)this.page);
        tester.assertRenderedPage(EditRolePage.class);
        tester.assertModelValue("form:name", (Object)"ROLE_AUTHENTICATED");
        tester.assertModelValue("form:parent", null);
        tester.assertModelValue("form:properties:container:list:0:key", (Object)"bbox");
        tester.assertModelValue("form:properties:container:list:0:value", (Object)"lookupAtRuntime");
        tester.assertModelValue("form:properties:container:list:1:key", (Object)"employee");
        tester.assertModelValue("form:properties:container:list:1:value", (Object)"");
        tester.executeAjaxEvent("form:properties:container:list:1:remove", "click");
        FormTester form = tester.newFormTester("form");
        form.submit("save");
        tester.assertRenderedPage(SecurityNamedServiceEditPage.class);
        GeoServerRole role = this.gaService.getRoleByName("ROLE_AUTHENTICATED");
        Assert.assertNotNull((Object)role);
        Assert.assertEquals((long)1L, (long)role.getProperties().size());
        Assert.assertEquals((Object)"lookupAtRuntime", (Object)role.getProperties().get("bbox"));
    }

    @Test
    public void testReadOnlyRoleService() throws Exception {
        this.activateRORoleService();
        AbstractSecurityPage returnPage = this.initializeForRoleServiceNamed(this.getRORoleServiceName());
        this.page = (EditRolePage)new EditRolePage(this.getRORoleServiceName(), GeoServerRole.ADMIN_ROLE).setReturnPage((Page)returnPage);
        tester.startPage((Page)this.page);
        tester.assertRenderedPage(EditRolePage.class);
        Assert.assertFalse((boolean)tester.getComponentFromLastRenderedPage("form:name").isEnabled());
        Assert.assertFalse((boolean)tester.getComponentFromLastRenderedPage("form:properties").isEnabled());
        Assert.assertFalse((boolean)tester.getComponentFromLastRenderedPage("form:parent").isEnabled());
        tester.assertInvisible("form:save");
    }
}

