/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.group;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.validation.RoleStoreValidationWrapper;
import org.geoserver.security.validation.UserGroupStoreValidationWrapper;
import org.geoserver.security.web.group.ConfirmRemovalGroupPanel;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ParamResourceModel;

public class SelectionGroupRemovalLink
extends AjaxLink<Object> {
    private static final long serialVersionUID = 1L;
    GeoServerTablePanel<GeoServerUserGroup> groups;
    GeoServerDialog dialog;
    boolean disassociateRoles = false;
    ConfirmRemovalGroupPanel removePanel;
    GeoServerDialog.DialogDelegate delegate;
    String userGroupsServiceName;

    public SelectionGroupRemovalLink(String userGroupServiceName, String id, GeoServerTablePanel<GeoServerUserGroup> groups, GeoServerDialog dialog, boolean disassociateRoles) {
        super(id);
        this.groups = groups;
        this.dialog = dialog;
        this.disassociateRoles = disassociateRoles;
        this.userGroupsServiceName = userGroupServiceName;
    }

    public void onClick(AjaxRequestTarget target) {
        final List selection = this.groups.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        this.dialog.setTitle((IModel)new ParamResourceModel("confirmRemoval", (Component)this, new Object[0]));
        this.delegate = new GeoServerDialog.DialogDelegate(){

            protected Component getContents(String id) {
                Model model = new Model((Serializable)Boolean.valueOf(SelectionGroupRemovalLink.this.disassociateRoles));
                SelectionGroupRemovalLink.this.removePanel = new ConfirmRemovalGroupPanel(id, model, selection){

                    @Override
                    protected IModel<String> canRemove(GeoServerUserGroup group) {
                        return SelectionGroupRemovalLink.this.canRemove(group);
                    }
                };
                return SelectionGroupRemovalLink.this.removePanel;
            }

            protected boolean onSubmit(AjaxRequestTarget target, Component contents) {
                UserGroupStoreValidationWrapper ugStore = null;
                try {
                    GeoServerUserGroupService ugService = GeoServerApplication.get().getSecurityManager().loadUserGroupService(SelectionGroupRemovalLink.this.userGroupsServiceName);
                    ugStore = new UserGroupStoreValidationWrapper(ugService.createStore());
                    for (GeoServerUserGroup group : SelectionGroupRemovalLink.this.removePanel.getRoots()) {
                        ugStore.removeGroup(group);
                    }
                    ugStore.store();
                }
                catch (IOException ex) {
                    try {
                        if (ugStore != null) {
                            ugStore.load();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw new RuntimeException(ex);
                }
                GeoServerRoleStore gaStore = null;
                if (SelectionGroupRemovalLink.this.disassociateRoles) {
                    try {
                        gaStore = GeoServerApplication.get().getSecurityManager().getActiveRoleService().createStore();
                        gaStore = new RoleStoreValidationWrapper(gaStore, new GeoServerUserGroupService[0]);
                        for (GeoServerUserGroup group : SelectionGroupRemovalLink.this.removePanel.getRoots()) {
                            ArrayList list = new ArrayList();
                            list.addAll(gaStore.getRolesForGroup(group.getGroupname()));
                            for (GeoServerRole role : list) {
                                gaStore.disAssociateRoleFromGroup(role, group.getGroupname());
                            }
                        }
                        gaStore.store();
                    }
                    catch (IOException ex) {
                        try {
                            if (gaStore != null) {
                                gaStore.load();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw new RuntimeException(ex);
                    }
                }
                SelectionGroupRemovalLink.this.groups.clearSelection();
                return true;
            }

            public void onClose(AjaxRequestTarget target) {
                if (SelectionGroupRemovalLink.this.groups.getSelection().isEmpty()) {
                    SelectionGroupRemovalLink.this.setEnabled(false);
                    target.add(new Component[]{SelectionGroupRemovalLink.this});
                    target.add(new Component[]{SelectionGroupRemovalLink.this.groups});
                }
            }
        };
        this.dialog.showOkCancel(target, this.delegate);
    }

    protected StringResourceModel canRemove(GeoServerUserGroup group) {
        return null;
    }
}

