/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.group;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.ListModel;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.validation.AbstractSecurityException;
import org.geoserver.security.web.AbstractSecurityPage;
import org.geoserver.security.web.role.RolePaletteFormComponent;
import org.geoserver.web.wicket.ParamResourceModel;

public abstract class AbstractGroupPage
extends AbstractSecurityPage {
    protected String userGroupServiceName;
    protected RolePaletteFormComponent rolePalette;

    protected AbstractGroupPage(String userGroupServiceName, final GeoServerUserGroup group) {
        ArrayList roles;
        this.userGroupServiceName = userGroupServiceName;
        boolean hasUserGroupStore = this.hasUserGroupStore(userGroupServiceName);
        boolean hasRoleStore = this.hasRoleStore(this.getSecurityManager().getActiveRoleService().getName());
        Form form = new Form("form", (IModel)new CompoundPropertyModel((Object)group));
        this.add(new Component[]{form});
        form.add(new Component[]{new TextField("groupname").setEnabled(hasUserGroupStore)});
        form.add(new Component[]{new CheckBox("enabled").setEnabled(hasUserGroupStore)});
        try {
            roles = new ArrayList(this.getSecurityManager().getActiveRoleService().getRolesForGroup(group.getGroupname()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Component[] componentArray = new Component[1];
        this.rolePalette = new RolePaletteFormComponent("roles", (IModel<List<GeoServerRole>>)new ListModel(roles));
        componentArray[0] = this.rolePalette;
        form.add(componentArray);
        this.rolePalette.setEnabled(hasRoleStore);
        form.add(new Component[]{new SubmitLink("save"){

            public void onSubmit() {
                try {
                    AbstractGroupPage.this.onFormSubmit(group);
                    AbstractGroupPage.this.setReturnPageDirtyAndReturn(true);
                }
                catch (IOException e) {
                    if (e.getCause() instanceof AbstractSecurityException) {
                        this.error(e.getCause());
                    } else {
                        this.error((Serializable)new ParamResourceModel("saveError", (Component)this.getPage(), new Object[]{e.getMessage()}).getObject());
                    }
                    LOGGER.log(Level.SEVERE, "Error occurred while saving group", e);
                }
            }
        }.setEnabled(hasUserGroupStore || this.hasRoleStore(this.getSecurityManager().getActiveRoleService().getName()))});
        form.add(new Component[]{this.getCancelLink()});
    }

    protected abstract void onFormSubmit(GeoServerUserGroup var1) throws IOException;
}

