/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.url;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.urlchecks.AbstractURLCheck;
import org.geoserver.security.urlchecks.RegexURLCheck;
import org.geoserver.security.urlchecks.URLCheckDAO;
import org.geoserver.security.web.url.RegexCheckPage;
import org.geoserver.security.web.url.URLChecksPage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.wicket.Icon;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class URLChecksPageTest
extends GeoServerWicketTestSupport {
    private static final RegexURLCheck TEST_RULE = new RegexURLCheck("test", "just a test", "^http://geoserver.org/.*$");
    private static final String ALL_GEOTOOLS_REGEX = "^http://geotools.org/.*$";

    @BeforeClass
    public static void setLanguage() {
        Locale.setDefault(Locale.ENGLISH);
    }

    protected void setUpTestData(SystemTestData testData) throws Exception {
    }

    @Before
    public void setup() throws IOException {
        this.login();
        URLCheckDAO dao = this.getDao();
        dao.saveChecks(Collections.emptyList());
    }

    private URLCheckDAO getDao() {
        URLCheckDAO dao = (URLCheckDAO)this.getGeoServerApplication().getBeanOfType(URLCheckDAO.class);
        return dao;
    }

    @Test
    public void testEmptyPage() throws Exception {
        tester.startPage(URLChecksPage.class);
        tester.assertNoErrorMessage();
        tester.assertRenderedPage(URLChecksPage.class);
    }

    private void startWithOneRule() {
        URLCheckDAO dao = this.getDao();
        dao.save((AbstractURLCheck)TEST_RULE);
        tester.startPage(URLChecksPage.class);
        tester.assertNoErrorMessage();
        tester.assertRenderedPage(URLChecksPage.class);
    }

    @Test
    public void testRenderOneRule() throws Exception {
        this.startWithOneRule();
        tester.assertLabel("table:listContainer:items:1:itemProperties:0:component:link:label", TEST_RULE.getName());
        tester.assertLabel("table:listContainer:items:1:itemProperties:1:component", TEST_RULE.getDescription());
        tester.assertLabel("table:listContainer:items:1:itemProperties:2:component", TEST_RULE.getRegex());
        tester.assertComponent("table:listContainer:items:1:itemProperties:3:component", Icon.class);
    }

    @Test
    public void testDeleteRule() throws Exception {
        this.startWithOneRule();
        CheckBox selection = (CheckBox)tester.getComponentFromLastRenderedPage("table:listContainer:items:1:selectItemContainer:selectItem");
        selection.setModelObject((Object)true);
        tester.clickLink("removeSelected", true);
        tester.clickLink("dialog:dialog:modal:overlay:dialog:content:content:form:submit");
        MatcherAssert.assertThat((Object)this.getDao().getChecks(), (Matcher)Matchers.empty());
    }

    @Test
    public void testAddNewRuleWorkflow() throws Exception {
        tester.startPage(URLChecksPage.class);
        tester.clickLink("addNew", true);
        tester.assertRenderedPage(RegexCheckPage.class);
        FormTester form = tester.newFormTester("form");
        form.setValue("name", TEST_RULE.getName());
        form.setValue("description", TEST_RULE.getDescription());
        form.setValue("regex", TEST_RULE.getRegex());
        form.setValue("enabled", TEST_RULE.isEnabled());
        form.submit("submit");
        tester.assertNoErrorMessage();
        tester.assertRenderedPage(URLChecksPage.class);
        Assert.assertEquals(Arrays.asList(TEST_RULE), (Object)this.getDao().getChecks());
    }

    @Test
    public void testEditRuleWorkflow() throws Exception {
        this.startWithOneRule();
        tester.clickLink("table:listContainer:items:1:itemProperties:0:component:link");
        tester.assertRenderedPage(RegexCheckPage.class);
        tester.assertModelValue("form:name", (Object)TEST_RULE.getName());
        tester.assertModelValue("form:description", (Object)TEST_RULE.getDescription());
        tester.assertModelValue("form:regex", (Object)TEST_RULE.getRegex());
        tester.assertModelValue("form:enabled", (Object)TEST_RULE.isEnabled());
        FormTester form = tester.newFormTester("form");
        form.setValue("regex", ALL_GEOTOOLS_REGEX);
        form.submit("submit");
        tester.assertNoErrorMessage();
        tester.assertRenderedPage(URLChecksPage.class);
        List checks = this.getDao().getChecks();
        Assert.assertEquals((long)1L, (long)checks.size());
        RegexURLCheck savedCheck = (RegexURLCheck)checks.get(0);
        Assert.assertEquals((Object)TEST_RULE.getName(), (Object)savedCheck.getName());
        Assert.assertEquals((Object)TEST_RULE.getDescription(), (Object)savedCheck.getDescription());
        Assert.assertEquals((Object)ALL_GEOTOOLS_REGEX, (Object)savedCheck.getRegex());
        Assert.assertEquals((Object)TEST_RULE.isEnabled(), (Object)savedCheck.isEnabled());
    }

    @Test
    public void testEditCancelWorkflow() throws Exception {
        this.startWithOneRule();
        tester.clickLink("table:listContainer:items:1:itemProperties:0:component:link");
        tester.assertRenderedPage(RegexCheckPage.class);
        tester.assertModelValue("form:name", (Object)TEST_RULE.getName());
        tester.assertModelValue("form:description", (Object)TEST_RULE.getDescription());
        tester.assertModelValue("form:regex", (Object)TEST_RULE.getRegex());
        tester.assertModelValue("form:enabled", (Object)TEST_RULE.isEnabled());
        FormTester form = tester.newFormTester("form");
        form.setValue("regex", ALL_GEOTOOLS_REGEX);
        form.submit();
        tester.assertNoErrorMessage();
        tester.clickLink("form:cancel");
        tester.assertRenderedPage(URLChecksPage.class);
        List checks = this.getDao().getChecks();
        Assert.assertEquals((long)1L, (long)checks.size());
        RegexURLCheck savedCheck = (RegexURLCheck)checks.get(0);
        Assert.assertEquals((Object)TEST_RULE.getName(), (Object)savedCheck.getName());
        Assert.assertEquals((Object)TEST_RULE.getDescription(), (Object)savedCheck.getDescription());
        Assert.assertEquals((Object)TEST_RULE.getRegex(), (Object)savedCheck.getRegex());
        Assert.assertEquals((Object)TEST_RULE.isEnabled(), (Object)savedCheck.isEnabled());
    }
}

