/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.service;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Page;
import org.apache.wicket.extensions.markup.html.form.palette.component.Recorder;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.ServiceAccessRule;
import org.geoserver.security.impl.ServiceAccessRuleDAO;
import org.geoserver.security.web.AbstractSecurityWicketTestSupport;
import org.geoserver.security.web.role.NewRolePage;
import org.geoserver.security.web.service.EditServiceAccessRulePage;
import org.geoserver.security.web.service.ServiceAccessRulePage;
import org.junit.Assert;
import org.junit.Test;

public class EditServiceAccessRulePageTest
extends AbstractSecurityWicketTestSupport {
    EditServiceAccessRulePage page;

    @Test
    public void testFill() throws Exception {
        this.initializeForXML();
        this.page = new EditServiceAccessRulePage(this.getRule("wms.GetMap"));
        tester.startPage((Page)this.page);
        tester.assertRenderedPage(EditServiceAccessRulePage.class);
        tester.assertModelValue("form:service", (Object)"wms");
        tester.assertModelValue("form:method", (Object)"GetMap");
        tester.assertModelValue("form:roles:anyRole", (Object)Boolean.FALSE);
        tester.assertComponent("form:roles:palette:recorder", Recorder.class);
        FormTester form = tester.newFormTester("form");
        form.setValue("roles:anyRole", true);
        form.submit("roles:addRole");
        tester.assertRenderedPage(NewRolePage.class);
        tester.clickLink("form:cancel");
        tester.assertRenderedPage(EditServiceAccessRulePage.class);
        form = tester.newFormTester("form");
        form.submit("save");
        tester.assertErrorMessages((Serializable[])new String[0]);
        tester.assertRenderedPage(ServiceAccessRulePage.class);
        ServiceAccessRule rule = this.getRule("wms.GetMap");
        Assert.assertNotNull((Object)rule);
        Assert.assertEquals((long)1L, (long)rule.getRoles().size());
        Assert.assertEquals((Object)GeoServerRole.ANY_ROLE, rule.getRoles().iterator().next());
    }

    @Test
    public void testEmptyRoles() throws Exception {
        this.initializeForXML();
        this.initializeServiceRules();
        this.page = new EditServiceAccessRulePage(this.getRule("wms.GetMap"));
        tester.startPage((Page)this.page);
        FormTester form = tester.newFormTester("form");
        form.setValue("roles:palette:recorder", "");
        form.submit("save");
        Assert.assertTrue((boolean)this.testErrorMessagesWithRegExp(".*no role.*"));
        tester.assertRenderedPage(EditServiceAccessRulePage.class);
    }

    @Test
    public void testReadOnlyRoleService() throws Exception {
        this.initializeForXML();
        this.activateRORoleService();
        this.page = new EditServiceAccessRulePage(this.getRule("wms.GetMap"));
        tester.startPage((Page)this.page);
        tester.assertInvisible("form:roles:addRole");
    }

    protected int indexOf(List<? extends String> strings, String searchValue) {
        int index = 0;
        for (String string : strings) {
            if (string.equals(searchValue)) {
                return index;
            }
            ++index;
        }
        Assert.assertNotEquals((long)index, (long)-1L);
        return -1;
    }

    ServiceAccessRule getRule(String key) {
        for (ServiceAccessRule rule : ServiceAccessRuleDAO.get().getRules()) {
            if (!key.equals(rule.getKey())) continue;
            return rule;
        }
        return null;
    }
}

