/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.group;

import java.io.Serializable;
import java.util.SortedSet;
import org.apache.wicket.Page;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.web.AbstractSecurityPage;
import org.geoserver.security.web.AbstractSecurityWicketTestSupport;
import org.geoserver.security.web.SecurityNamedServiceEditPage;
import org.geoserver.security.web.group.EditGroupPage;
import org.geoserver.security.web.role.NewRolePage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EditGroupPageTest
extends AbstractSecurityWicketTestSupport {
    EditGroupPage page;

    @Before
    public void init() throws Exception {
        this.doInitialize();
        this.clearServices();
        this.deactivateRORoleService();
        this.deactivateROUGService();
    }

    protected void doInitialize() throws Exception {
        this.initializeForXML();
    }

    @Test
    public void testFill() throws Exception {
        this.doTestFill();
    }

    protected void doTestFill() throws Exception {
        this.insertValues();
        AbstractSecurityPage returnPage = this.initializeForUGServiceNamed(this.getUserGroupServiceName());
        this.page = (EditGroupPage)new EditGroupPage(this.getUserGroupServiceName(), this.ugService.getGroupByGroupname("group1")).setReturnPage((Page)returnPage);
        tester.startPage((Page)this.page);
        tester.assertRenderedPage(EditGroupPage.class);
        tester.assertRenderedPage(EditGroupPage.class);
        Assert.assertFalse((boolean)tester.getComponentFromLastRenderedPage("form:groupname").isEnabled());
        Assert.assertTrue((boolean)tester.getComponentFromLastRenderedPage("form:enabled").isEnabled());
        Assert.assertTrue((boolean)tester.getComponentFromLastRenderedPage("form:roles").isEnabled());
        tester.assertVisible("form:save");
        tester.assertModelValue("form:groupname", (Object)"group1");
        tester.assertModelValue("form:enabled", (Object)Boolean.TRUE);
        FormTester form = tester.newFormTester("form");
        form.setValue("enabled", Boolean.FALSE.booleanValue());
        form.submit("roles:addRole");
        tester.assertRenderedPage(NewRolePage.class);
        form = tester.newFormTester("form");
        form.setValue("name", "ROLE_NEW");
        form.submit("save");
        form = tester.newFormTester("form");
        tester.assertRenderedPage(EditGroupPage.class);
        form.setValue("roles:palette:recorder", this.gaService.getRoleByName("ROLE_NEW").getAuthority());
        form.submit("roles:addRole");
        tester.assertRenderedPage(NewRolePage.class);
        tester.clickLink("form:cancel");
        tester.assertRenderedPage(EditGroupPage.class);
        form = tester.newFormTester("form");
        form.submit("save");
        tester.assertRenderedPage(SecurityNamedServiceEditPage.class);
        tester.assertErrorMessages((Serializable[])new String[0]);
        GeoServerUserGroup group = this.ugService.getGroupByGroupname("group1");
        Assert.assertNotNull((Object)group);
        Assert.assertFalse((boolean)group.isEnabled());
        SortedSet roleList = this.gaService.getRolesForGroup("group1");
        Assert.assertEquals((long)1L, (long)roleList.size());
        Assert.assertEquals((Object)"ROLE_NEW", (Object)((GeoServerRole)roleList.iterator().next()).getAuthority());
    }

    @Test
    public void testReadOnlyUserGroupService() throws Exception {
        this.doTestReadOnlyUserGroupService();
    }

    protected void doTestReadOnlyUserGroupService() throws Exception {
        this.insertValues();
        this.activateROUGService();
        AbstractSecurityPage returnPage = this.initializeForUGServiceNamed(this.getROUserGroupServiceName());
        this.page = (EditGroupPage)new EditGroupPage(this.getROUserGroupServiceName(), this.ugService.getGroupByGroupname("group1")).setReturnPage((Page)returnPage);
        tester.startPage((Page)this.page);
        tester.assertRenderedPage(EditGroupPage.class);
        Assert.assertFalse((boolean)tester.getComponentFromLastRenderedPage("form:groupname").isEnabled());
        Assert.assertFalse((boolean)tester.getComponentFromLastRenderedPage("form:enabled").isEnabled());
        Assert.assertTrue((boolean)tester.getComponentFromLastRenderedPage("form:roles").isEnabled());
        Assert.assertTrue((boolean)tester.getComponentFromLastRenderedPage("form:save").isEnabled());
        FormTester form = tester.newFormTester("form");
        form.setValue("roles:palette:recorder", this.gaService.getRoleByName("ROLE_WFS").getAuthority());
        form.submit("save");
        tester.assertRenderedPage(SecurityNamedServiceEditPage.class);
        SortedSet roleList = this.gaService.getRolesForGroup("group1");
        Assert.assertEquals((long)1L, (long)roleList.size());
        Assert.assertEquals((Object)"ROLE_WFS", (Object)((GeoServerRole)roleList.iterator().next()).getAuthority());
    }

    @Test
    public void testReadOnlyRoleService() throws Exception {
        this.doTestReadOnlyRoleService();
    }

    protected void doTestReadOnlyRoleService() throws Exception {
        this.insertValues();
        this.activateRORoleService();
        AbstractSecurityPage returnPage = this.initializeForUGServiceNamed(this.getUserGroupServiceName());
        this.page = (EditGroupPage)new EditGroupPage(this.getUserGroupServiceName(), this.ugService.getGroupByGroupname("group1")).setReturnPage((Page)returnPage);
        tester.startPage((Page)this.page);
        tester.assertRenderedPage(EditGroupPage.class);
        Assert.assertFalse((boolean)tester.getComponentFromLastRenderedPage("form:groupname").isEnabled());
        Assert.assertTrue((boolean)tester.getComponentFromLastRenderedPage("form:enabled").isEnabled());
        Assert.assertFalse((boolean)tester.getComponentFromLastRenderedPage("form:roles").isEnabled());
        tester.assertVisible("form:save");
        FormTester form = tester.newFormTester("form");
        form.setValue("enabled", Boolean.FALSE.booleanValue());
        form.submit("save");
        tester.assertRenderedPage(SecurityNamedServiceEditPage.class);
        GeoServerUserGroup group = this.ugService.getGroupByGroupname("group1");
        Assert.assertNotNull((Object)group);
        Assert.assertFalse((boolean)group.isEnabled());
    }

    @Test
    public void testAllServicesReadOnly() throws Exception {
        this.activateROUGService();
        this.activateRORoleService();
        AbstractSecurityPage returnPage = this.initializeForUGServiceNamed(this.getROUserGroupServiceName());
        this.page = (EditGroupPage)new EditGroupPage(this.getROUserGroupServiceName(), this.ugService.getGroupByGroupname("group1")).setReturnPage((Page)returnPage);
        tester.startPage((Page)this.page);
        tester.assertRenderedPage(EditGroupPage.class);
        Assert.assertFalse((boolean)tester.getComponentFromLastRenderedPage("form:groupname").isEnabled());
        Assert.assertFalse((boolean)tester.getComponentFromLastRenderedPage("form:enabled").isEnabled());
        Assert.assertFalse((boolean)tester.getComponentFromLastRenderedPage("form:roles").isEnabled());
        Assert.assertFalse((boolean)tester.getComponentFromLastRenderedPage("form:save").isEnabled());
    }
}

