/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.group;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.web.AbstractConfirmRemovalPanelTest;
import org.geoserver.security.web.group.ConfirmRemovalGroupPanel;
import org.geoserver.security.web.group.SelectionGroupRemovalLink;
import org.geoserver.web.ComponentBuilder;
import org.geoserver.web.FormTestPage;
import org.junit.Before;
import org.junit.Test;

public class ConfirmRemovalGroupPanelTest
extends AbstractConfirmRemovalPanelTest<GeoServerUserGroup> {
    private static final long serialVersionUID = 1L;
    protected boolean disassociateRoles = false;

    @Override
    protected void setupPanel(final List<GeoServerUserGroup> roots) {
        tester.startPage((Page)new FormTestPage(new ComponentBuilder(){
            private static final long serialVersionUID = 1L;

            public Component buildComponent(String id) {
                Model model = new Model((Serializable)Boolean.valueOf(ConfirmRemovalGroupPanelTest.this.disassociateRoles));
                return new ConfirmRemovalGroupPanel(id, model, roots.toArray(new GeoServerUserGroup[roots.size()])){
                    private static final long serialVersionUID = 1L;

                    protected IModel<String> canRemove(GeoServerUserGroup data) {
                        SelectionGroupRemovalLink link = new SelectionGroupRemovalLink(ConfirmRemovalGroupPanelTest.this.getUserGroupServiceName(), "XXX", null, null, ConfirmRemovalGroupPanelTest.this.disassociateRoles);
                        return link.canRemove(data);
                    }
                };
            }
        }));
    }

    @Before
    public void init() throws Exception {
        this.initializeForXML();
        this.clearServices();
    }

    @Test
    public void testRemoveGroup() throws Exception {
        this.disassociateRoles = false;
        this.removeObject();
    }

    @Test
    public void testRemoveGroupWithRoles() throws Exception {
        this.disassociateRoles = true;
        this.removeObject();
    }

    @Override
    protected GeoServerUserGroup getRemoveableObject() throws Exception {
        if (this.disassociateRoles) {
            return this.ugService.createGroupObject("g_all", true);
        }
        return this.ugService.getGroupByGroupname("group1");
    }

    @Override
    protected GeoServerUserGroup getProblematicObject() throws Exception {
        return null;
    }

    @Override
    protected String getProblematicObjectRegExp() throws Exception {
        return "";
    }

    @Override
    protected String getRemoveableObjectRegExp() throws Exception {
        if (this.disassociateRoles) {
            return ".*" + this.getRemoveableObject().getGroupname() + ".*ROLE_WMS.*";
        }
        return ".*" + this.getRemoveableObject().getGroupname() + ".*";
    }
}

