/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.AccessMode;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.auth.UsernamePasswordAuthenticationProvider;
import org.geoserver.security.config.SecurityAuthProviderConfig;
import org.geoserver.security.config.SecurityManagerConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.config.SecurityRoleServiceConfig;
import org.geoserver.security.config.SecurityUserGroupServiceConfig;
import org.geoserver.security.config.UsernamePasswordAuthenticationProviderConfig;
import org.geoserver.security.config.impl.MemoryRoleServiceConfigImpl;
import org.geoserver.security.config.impl.MemoryUserGroupServiceConfigImpl;
import org.geoserver.security.impl.AbstractRoleServiceTest;
import org.geoserver.security.impl.AbstractUserGroupServiceTest;
import org.geoserver.security.impl.DataAccessRule;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.MemoryRoleStore;
import org.geoserver.security.impl.MemoryUserGroupStore;
import org.geoserver.security.impl.ReadOnlyRoleService;
import org.geoserver.security.impl.ReadOnlyUGService;
import org.geoserver.security.impl.ServiceAccessRule;
import org.geoserver.security.impl.ServiceAccessRuleDAO;
import org.geoserver.security.password.GeoServerDigestPasswordEncoder;
import org.geoserver.security.password.GeoServerPBEPasswordEncoder;
import org.geoserver.security.password.GeoServerPlainTextPasswordEncoder;
import org.geoserver.security.web.AbstractSecurityPage;
import org.geoserver.security.web.SecurityNamedServicesPanel;
import org.geoserver.security.web.UserGroupRoleServicesPage;
import org.geoserver.security.xml.XMLRoleServiceTest;
import org.geoserver.security.xml.XMLUserGroupServiceTest;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.wicket.GSModalWindow;
import org.junit.Before;

public abstract class AbstractSecurityWicketTestSupport
extends GeoServerWicketTestSupport {
    protected static final String NATURE_GROUP = "nature";
    protected static final String CITE_NATURE_GROUP = "citeNature";
    protected AbstractRoleServiceTest gaTest;
    protected AbstractUserGroupServiceTest ugTest;
    protected GeoServerUserGroupService ugService;
    protected GeoServerRoleService gaService;
    protected GeoServerRoleStore gaStore;
    protected GeoServerUserGroupStore ugStore;

    public String getRoleServiceName() {
        return "test";
    }

    public String getUserGroupServiceName() {
        return "test";
    }

    protected void setUpSpring(List<String> springContextLocations) {
        super.setUpSpring(springContextLocations);
        springContextLocations.add("classpath*:/applicationTestContext.xml");
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog catalog = this.getCatalog();
        LayerInfo lakes = catalog.getLayerByName(this.getLayerId(MockData.LAKES));
        LayerInfo forests = catalog.getLayerByName(this.getLayerId(MockData.FORESTS));
        if (lakes != null && forests != null) {
            LayerGroupInfo nature = this.buildGroup(NATURE_GROUP, lakes, forests);
            catalog.add(nature);
            LayerGroupInfo citeNature = this.buildGroup(CITE_NATURE_GROUP, lakes, forests);
            citeNature.setWorkspace(catalog.getWorkspaceByName(MockData.CITE_PREFIX));
            catalog.add(citeNature);
        }
    }

    private LayerGroupInfo buildGroup(String name, LayerInfo ... layers) throws Exception {
        Catalog catalog = this.getCatalog();
        LayerGroupInfo group = catalog.getFactory().createLayerGroup();
        group.setName(name);
        for (LayerInfo layer : layers) {
            group.getLayers().add(layer);
        }
        CatalogBuilder cb = new CatalogBuilder(catalog);
        cb.calculateLayerGroupBounds(group);
        return group;
    }

    @Before
    public void setUp() throws Exception {
        this.login();
        Locale.setDefault(Locale.ENGLISH);
        SecurityManagerConfig config = this.getSecurityManager().getSecurityConfig();
        config.setEncryptingUrlParams(true);
        this.getSecurityManager().saveSecurityConfig(config);
    }

    protected void initialize(AbstractUserGroupServiceTest ugTest, AbstractRoleServiceTest gaTest) throws Exception {
        this.ugTest = ugTest;
        this.gaTest = gaTest;
        this.gaService = gaTest.createRoleService(this.getRoleServiceName());
        this.getSecurityManager().setActiveRoleService(this.gaService);
        this.ugService = ugTest.createUserGroupService(this.getUserGroupServiceName());
        this.gaStore = gaTest.createStore(this.gaService);
        this.ugStore = ugTest.createStore(this.ugService);
        this.initializeServiceRules();
        this.initializeDataAccessRules();
    }

    protected void initializeForXML() throws Exception {
        this.initialize((AbstractUserGroupServiceTest)new XMLUserGroupServiceTest(), (AbstractRoleServiceTest)new XMLRoleServiceTest());
    }

    protected void addAdditonalData() throws Exception {
        this.gaStore.associateRoleToGroup(this.gaStore.getRoleByName("ROLE_WMS"), "group1");
        this.gaStore.associateRoleToGroup(this.gaStore.getRoleByName("ROLE_WFS"), "group1");
        this.gaStore.store();
    }

    protected void insertValues() throws Exception {
        this.gaTest.insertValues(this.gaStore);
        this.gaStore.store();
        this.ugTest.insertValues(this.ugStore);
        this.ugStore.store();
    }

    protected void modifyValues() throws Exception {
        this.gaTest.modifyValues(this.gaStore);
        this.gaStore.store();
        this.ugTest.modifyValues(this.ugStore);
        this.ugStore.store();
    }

    protected void removeValues() throws IOException {
        if (this.gaStore != null) {
            this.gaTest.removeValues(this.gaStore);
            this.gaStore.store();
        }
        if (this.ugStore != null) {
            this.ugTest.removeValues(this.ugStore);
            this.ugStore.store();
        }
    }

    protected void clearServices() throws IOException {
        if (this.gaStore != null) {
            this.gaStore.clear();
            this.gaStore.store();
        }
        if (this.ugStore != null) {
            this.ugStore.clear();
            this.ugStore.store();
        }
    }

    public String getRORoleServiceName() {
        return "ReadOnlyRoleService";
    }

    public String getROUserGroupServiceName() {
        return "ReadOnlyUGService";
    }

    protected void activateRORoleService() throws Exception {
        MemoryRoleServiceConfigImpl config = new MemoryRoleServiceConfigImpl();
        config.setName(this.getRORoleServiceName());
        config.setClassName(ReadOnlyRoleService.class.getName());
        this.getSecurityManager().saveRoleService((SecurityRoleServiceConfig)config);
        this.gaService = this.getSecurityManager().loadRoleService(this.getRORoleServiceName());
        this.gaService.initializeFromConfig((SecurityNamedServiceConfig)config);
        this.gaService.setSecurityManager(GeoServerApplication.get().getSecurityManager());
        this.gaStore = new MemoryRoleStore();
        this.gaStore.initializeFromService(this.gaService);
        this.gaTest.insertValues(this.gaStore);
        this.gaStore.store();
        this.getSecurityManager().setActiveRoleService(this.gaService);
        this.gaStore = null;
    }

    protected void deactivateRORoleService() throws Exception {
        GeoServerSecurityManager secMgr = this.getSecurityManager();
        if (secMgr.listRoleServices().contains(this.getRORoleServiceName())) {
            SecurityRoleServiceConfig config = secMgr.loadRoleServiceConfig(this.getRORoleServiceName());
            secMgr.removeRoleService(config);
        }
    }

    protected GeoServerDigestPasswordEncoder getDigestPasswordEncoder() {
        return (GeoServerDigestPasswordEncoder)this.getSecurityManager().loadPasswordEncoder(GeoServerDigestPasswordEncoder.class);
    }

    protected GeoServerPBEPasswordEncoder getPBEPasswordEncoder() {
        return (GeoServerPBEPasswordEncoder)this.getSecurityManager().loadPasswordEncoder(GeoServerPBEPasswordEncoder.class, null, Boolean.valueOf(false));
    }

    protected GeoServerPlainTextPasswordEncoder getPlainTextPasswordEncoder() {
        return (GeoServerPlainTextPasswordEncoder)this.getSecurityManager().loadPasswordEncoder(GeoServerPlainTextPasswordEncoder.class);
    }

    protected void activateROUGService() throws Exception {
        MemoryUserGroupServiceConfigImpl config = new MemoryUserGroupServiceConfigImpl();
        config.setName(this.getROUserGroupServiceName());
        config.setClassName(ReadOnlyUGService.class.getName());
        config.setPasswordEncoderName(this.getDigestPasswordEncoder().getName());
        config.setPasswordPolicyName("default");
        this.getSecurityManager().saveUserGroupService((SecurityUserGroupServiceConfig)config);
        this.ugService = this.getSecurityManager().loadUserGroupService(this.getROUserGroupServiceName());
        this.ugService.initializeFromConfig((SecurityNamedServiceConfig)config);
        this.ugService.setSecurityManager(GeoServerApplication.get().getSecurityManager());
        this.ugStore = new MemoryUserGroupStore();
        this.ugStore.initializeFromService(this.ugService);
        this.ugTest.insertValues(this.ugStore);
        this.ugStore.store();
        this.ugStore = null;
    }

    protected void deactivateROUGService() throws Exception {
        GeoServerSecurityManager secMgr = this.getSecurityManager();
        if (secMgr.listUserGroupServices().contains(this.getROUserGroupServiceName())) {
            SecurityUserGroupServiceConfig config = secMgr.loadUserGroupServiceConfig(this.getROUserGroupServiceName());
            secMgr.removeUserGroupService(config);
        }
    }

    public void executeModalWindowClosedCallback(GSModalWindow modalWindow) {
        for (Behavior behavior : modalWindow.getBehaviors()) {
            String name;
            if (!(behavior instanceof AbstractDefaultAjaxBehavior) || !(name = behavior.getClass().getSimpleName()).startsWith("WindowClosedBehavior")) continue;
            tester.executeBehavior((AbstractAjaxBehavior)behavior);
        }
    }

    public void executeModalWindowCloseButtonCallback(GSModalWindow modalWindow) {
        for (Behavior behavior : modalWindow.getBehaviors()) {
            String name;
            if (!(behavior instanceof AbstractDefaultAjaxBehavior) || !(name = behavior.getClass().getSimpleName()).startsWith("CloseButtonBehavior")) continue;
            tester.executeBehavior((AbstractAjaxBehavior)behavior);
        }
    }

    protected void initializeServiceRules() throws IOException {
        ServiceAccessRuleDAO dao = ServiceAccessRuleDAO.get();
        dao.getRules();
        dao.addRule((Comparable)new ServiceAccessRule("wms", "GetMap", new String[]{"ROLE_AUTHENTICATED"}));
        dao.addRule((Comparable)new ServiceAccessRule("wms", "*", new String[]{"ROLE_WMS"}));
        dao.addRule((Comparable)new ServiceAccessRule("wfs", "GetFeature", new String[]{"ROLE_AUTHENTICATED"}));
        dao.addRule((Comparable)new ServiceAccessRule("wfs", "*", new String[]{"ROLE_WFS"}));
        dao.addRule((Comparable)new ServiceAccessRule("*", "*", new String[]{GeoServerRole.ADMIN_ROLE.getAuthority()}));
        dao.storeRules();
    }

    protected void initializeDataAccessRules() throws IOException {
        DataAccessRuleDAO dao = DataAccessRuleDAO.get();
        dao.getRules();
        dao.addRule((Comparable)new DataAccessRule("*", "*", AccessMode.WRITE, new String[]{GeoServerRole.ADMIN_ROLE.getAuthority()}));
        dao.addRule((Comparable)new DataAccessRule(MockData.CITE_PREFIX, "*", AccessMode.READ, new String[]{"ROLE_AUTENTICATED"}));
        dao.addRule((Comparable)new DataAccessRule(MockData.CITE_PREFIX, MockData.LAKES.getLocalPart(), AccessMode.WRITE, new String[]{"ROLE_WMS,ROLE_WFS"}));
        dao.addRule((Comparable)new DataAccessRule(MockData.CITE_PREFIX, MockData.BRIDGES.getLocalPart(), AccessMode.WRITE, new String[]{"ROLE_WMS,ROLE_WFS"}));
        dao.storeRules();
    }

    protected boolean testErrorMessagesWithRegExp(String regExp) {
        List msgs = tester.getMessages(400);
        for (Serializable msg : msgs) {
            if (!msg.toString().matches(regExp)) continue;
            return true;
        }
        return false;
    }

    protected void createUserPasswordAuthProvider(String name, String ugName) throws Exception {
        UsernamePasswordAuthenticationProviderConfig config = new UsernamePasswordAuthenticationProviderConfig();
        config.setName(name);
        config.setClassName(UsernamePasswordAuthenticationProvider.class.getName());
        config.setUserGroupServiceName(ugName);
        this.getSecurityManager().saveAuthenticationProvider((SecurityAuthProviderConfig)config);
    }

    protected AbstractSecurityPage initializeForRoleServiceNamed(String name) {
        this.initializeForService(name, "roleServices");
        return (AbstractSecurityPage)tester.getLastRenderedPage();
    }

    protected AbstractSecurityPage initializeForUGServiceNamed(String name) {
        this.initializeForService(name, "userGroupServices");
        return (AbstractSecurityPage)tester.getLastRenderedPage();
    }

    private void initializeForService(String name, String panelName) {
        UserGroupRoleServicesPage page = new UserGroupRoleServicesPage();
        tester.startPage((Page)page);
        tester.assertRenderedPage(page.getPageClass());
        SecurityNamedServicesPanel panel = (SecurityNamedServicesPanel)page.get("panel:panel:" + panelName);
        DataView dv = (DataView)panel.get("table:listContainer:items");
        Iterator it = dv.getItems();
        while (it.hasNext()) {
            Item item = (Item)it.next();
            if (!name.equals(((SecurityNamedServiceConfig)item.getModelObject()).getName())) continue;
            tester.clickLink(item.getPageRelativePath() + ":itemProperties:0:component:link");
        }
    }
}

