/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.url;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.geoserver.ows.ProxifyingURLMangler;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.security.urlchecks.AbstractURLCheck;
import org.geoserver.security.urlchecks.RegexURLCheck;
import org.geoserver.security.urlchecks.URLCheckDAO;
import org.geoserver.security.web.url.URLChecksPage;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.util.logging.Logging;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

public class RegexCheckPage
extends GeoServerSecuredPage {
    static final Logger LOGGER = Logging.getLogger(RegexCheckPage.class);
    public static final String NAME = "name";
    private boolean isNew = false;
    Form<RegexURLCheck> form;

    public RegexCheckPage(PageParameters parameters) throws Exception {
        String name = parameters.get(NAME).toString();
        this.isNew = name == null;
        URLCheckDAO dao = this.getUrlCheckDAO();
        RegexURLCheck entry = (RegexURLCheck)dao.getCheckByName(name);
        if (entry == null) {
            entry = new RegexURLCheck();
        }
        this.initUI((IModel<RegexURLCheck>)new Model((Serializable)entry));
    }

    private URLCheckDAO getUrlCheckDAO() {
        return (URLCheckDAO)this.getGeoServerApplication().getBeanOfType(URLCheckDAO.class);
    }

    private void initUI(IModel<RegexURLCheck> bean) {
        this.form = new Form("form", (IModel)new CompoundPropertyModel(bean));
        TextField nameField = new TextField(NAME, (IModel)new PropertyModel(bean, NAME));
        nameField.setEnabled(this.isNew);
        nameField.setRequired(true);
        if (this.isNew) {
            nameField.add((IValidator)new DuplicationValidator());
        }
        TextField descriptionField = new TextField("description", (IModel)new PropertyModel(bean, "description"));
        TextField regexField = new TextField("regex", (IModel)new PropertyModel(bean, "regex"));
        regexField.add((IValidator)new RegexValidator());
        if (regexField.getModelObject() == null) {
            regexField.setModelObject((Object)this.getDefaultRegex());
        }
        regexField.setRequired(true);
        CheckBox enabledCheckBox = new CheckBox("enabled", (IModel)new PropertyModel(bean, "enabled"));
        this.form.add(new Component[]{nameField});
        this.form.add(new Component[]{descriptionField});
        this.form.add(new Component[]{regexField});
        this.form.add(new Component[]{enabledCheckBox});
        this.form.add(new Component[]{this.submitLink()});
        this.form.add(new Component[]{new BookmarkablePageLink("cancel", URLChecksPage.class)});
        this.add(new Component[]{this.form});
    }

    private String getDefaultRegex() {
        String url = this.getOWSURL();
        url = url.replace(".", "\\.");
        return "^" + url + "\\?.*$";
    }

    private String getOWSURL() {
        String proxyBase = this.getGeoServer().getSettings().getProxyBaseUrl();
        if (proxyBase != null) {
            ProxifyingURLMangler mangler = (ProxifyingURLMangler)this.getGeoServerApplication().getBeanOfType(ProxifyingURLMangler.class);
            String baseURL = ServletUriComponentsBuilder.fromCurrentContextPath().build().toUriString();
            StringBuilder base = new StringBuilder(baseURL);
            StringBuilder path = new StringBuilder("ows");
            mangler.mangleURL(base, path, new HashMap(), URLMangler.URLType.SERVICE);
            return ResponseUtils.appendPath((String[])new String[]{base.toString(), path.toString()});
        }
        return "http://localhost:8080/geoserver/ows";
    }

    private SubmitLink submitLink() {
        return new SubmitLink("submit"){
            private static final long serialVersionUID = -3462848930497720229L;

            public void onSubmit() {
                try {
                    RegexURLCheck check = (RegexURLCheck)RegexCheckPage.this.form.getModelObject();
                    if (RegexCheckPage.this.isNew) {
                        RegexCheckPage.this.getUrlCheckDAO().add((AbstractURLCheck)check);
                    } else {
                        RegexCheckPage.this.getUrlCheckDAO().save((AbstractURLCheck)check);
                    }
                    RegexCheckPage.this.doReturn(URLChecksPage.class);
                }
                catch (Exception e) {
                    this.error((Serializable)((Object)("An Error occurred " + e.getMessage())));
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        };
    }

    private class DuplicationValidator
    implements IValidator<String> {
        private DuplicationValidator() {
        }

        public void validate(IValidatable<String> validatable) {
            String name = (String)validatable.getValue();
            URLCheckDAO dao = RegexCheckPage.this.getUrlCheckDAO();
            try {
                if (dao.getCheckByName(name) != null) {
                    String message = new ParamResourceModel("duplicateRule", (Component)RegexCheckPage.this, new Object[]{name}).getString();
                    validatable.error((IValidationError)new ValidationError(message));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class RegexValidator
    implements IValidator<String> {
        private RegexValidator() {
        }

        public void validate(IValidatable<String> validatable) {
            String regex = (String)validatable.getValue();
            try {
                Pattern.compile(regex);
            }
            catch (Exception e) {
                String message = new ParamResourceModel("invalidRegex", (Component)RegexCheckPage.this, new Object[]{regex}).getString();
                validatable.error((IValidationError)new ValidationError(message));
            }
        }
    }
}

