/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.group;

import java.util.List;
import java.util.SortedSet;
import org.apache.wicket.model.Model;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.web.AbstractConfirmRemovalPanel;
import org.geoserver.web.GeoServerApplication;

public class ConfirmRemovalGroupPanel
extends AbstractConfirmRemovalPanel<GeoServerUserGroup> {
    private static final long serialVersionUID = 1L;

    public ConfirmRemovalGroupPanel(String id, Model<Boolean> model, List<GeoServerUserGroup> roots) {
        super(id, model, roots);
    }

    public ConfirmRemovalGroupPanel(String id, Model<Boolean> model, GeoServerUserGroup ... roots) {
        super(id, (Model<?>)model, (T[])roots);
    }

    @Override
    protected String getConfirmationMessage(GeoServerUserGroup object) throws Exception {
        StringBuffer buffer = new StringBuffer((String)OwsUtils.property((Object)object, (String)"groupname", String.class));
        if (((Boolean)this.getDefaultModelObject()).booleanValue()) {
            SortedSet roles = GeoServerApplication.get().getSecurityManager().getActiveRoleService().getRolesForGroup(object.getGroupname());
            buffer.append(" [");
            for (GeoServerRole role : roles) {
                buffer.append(role.getAuthority()).append(" ");
            }
            if (!roles.isEmpty()) {
                buffer.setLength(buffer.length() - 1);
            }
            buffer.append("]");
        }
        return buffer.toString();
    }
}

