/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web;

import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geotools.util.logging.Logging;

public abstract class SecurityNamedServicePanel<T extends SecurityNamedServiceConfig>
extends FormComponentPanel<T> {
    protected static Logger LOGGER = Logging.getLogger((String)"org.geoserver.web.security");
    protected IModel<T> configModel;
    protected GeoServerDialog dialog;

    public SecurityNamedServicePanel(String id, IModel<T> model) {
        super(id, (IModel)new Model());
        this.configModel = model;
        boolean isAdmin = this.getSecurityManager().checkAuthenticationForAdminRole();
        this.setEnabled(isAdmin);
        this.add(new Component[]{new Label("message", (IModel)(isAdmin ? new Model() : new StringResourceModel("notAdmin", (Component)this, null)))});
        if (!isAdmin) {
            this.get("message").add(new Behavior[]{new AttributeAppender("class", (IModel)new Model((Serializable)((Object)"info-link")), " ")});
        }
        this.setOutputMarkupId(true);
        this.add(new Component[]{new TextField("name").setRequired(true).setEnabled(((SecurityNamedServiceConfig)model.getObject()).getId() == null)});
        Component[] componentArray = new Component[1];
        this.dialog = new GeoServerDialog("dialog");
        componentArray[0] = this.dialog;
        this.add(componentArray);
    }

    protected GeoServerSecurityManager getSecurityManager() {
        return GeoServerApplication.get().getSecurityManager();
    }

    protected boolean isNew() {
        return ((SecurityNamedServiceConfig)this.configModel.getObject()).getId() == null;
    }

    public abstract void doSave(T var1) throws Exception;

    public abstract void doLoad(T var1) throws Exception;
}

