/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.url;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.urlchecks.RegexURLCheck;
import org.geoserver.security.urlchecks.URLCheckDAO;
import org.geoserver.security.web.url.RegexCheckPage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class RegexCheckPageTest
extends GeoServerWicketTestSupport {
    private static final String NAME = "tester";
    private static final String DESCRIPTION = "description";
    private static final String REGEX = ".*";

    @BeforeClass
    public static void setLanguage() {
        Locale.setDefault(Locale.ENGLISH);
    }

    protected void setUpTestData(SystemTestData testData) throws Exception {
    }

    @Before
    public void setup() throws IOException {
        this.login();
        URLCheckDAO dao = (URLCheckDAO)this.getGeoServerApplication().getBeanOfType(URLCheckDAO.class);
        dao.saveChecks(Collections.emptyList());
    }

    private static void startEmptyPage() {
        tester.startPage(RegexCheckPage.class);
        tester.assertNoErrorMessage();
        tester.assertRenderedPage(RegexCheckPage.class);
    }

    @Test
    public void testNewRule() throws Exception {
        RegexCheckPageTest.fillNewRule(REGEX);
        tester.assertNoErrorMessage();
        URLCheckDAO dao = (URLCheckDAO)this.getGeoServerApplication().getBeanOfType(URLCheckDAO.class);
        List checks = dao.getChecks();
        Assert.assertEquals((long)1L, (long)checks.size());
        RegexURLCheck check = (RegexURLCheck)checks.get(0);
        Assert.assertEquals((Object)NAME, (Object)check.getName());
        Assert.assertEquals((Object)DESCRIPTION, (Object)check.getDescription());
        Assert.assertEquals((Object)REGEX, (Object)check.getRegex());
        Assert.assertTrue((boolean)check.isEnabled());
    }

    @Test
    public void testDefaultRegex() throws Exception {
        RegexCheckPageTest.startEmptyPage();
        FormTester form = tester.newFormTester("form");
        String regex = form.getTextComponentValue("regex");
        Assert.assertTrue((String)"query", (boolean)regex.contains("\\?.*"));
        Assert.assertTrue((String)"line", (boolean)regex.endsWith("$"));
    }

    private static void fillNewRule(String regex) {
        RegexCheckPageTest.startEmptyPage();
        FormTester form = tester.newFormTester("form");
        form.setValue("name", NAME);
        form.setValue(DESCRIPTION, DESCRIPTION);
        form.setValue("regex", regex);
        form.setValue("enabled", true);
        form.submit("submit");
    }

    @Test
    public void testRegexValidator() throws Exception {
        RegexCheckPageTest.fillNewRule("[.*");
        tester.assertErrorMessages((Serializable[])new String[]{"Invalid regular expression: [.*"});
    }

    @Test
    public void testMandatoryFields() throws Exception {
        RegexCheckPageTest.startEmptyPage();
        FormTester form = tester.newFormTester("form");
        form.setValue("enabled", true);
        form.setValue("regex", null);
        form.submit("submit");
        tester.assertErrorMessages((Serializable[])new String[]{"Field 'Name' is required.", "Field 'regex' is required."});
    }

    @Test
    public void testDuplicateRule() throws Exception {
        RegexCheckPageTest.startEmptyPage();
        RegexCheckPageTest.fillNewRule(REGEX);
        tester.assertNoErrorMessage();
        RegexCheckPageTest.fillNewRule(REGEX);
        tester.assertErrorMessages((Serializable[])new String[]{"Another rule with the same name already exists: 'tester'"});
    }
}

