/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.auth;

import org.apache.wicket.Component;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.auth.UsernamePasswordAuthenticationProvider;
import org.geoserver.security.config.SecurityAuthProviderConfig;
import org.geoserver.security.config.UsernamePasswordAuthenticationProviderConfig;
import org.geoserver.security.web.AbstractSecurityNamedServicePanelTest;
import org.geoserver.security.web.AbstractSecurityPage;
import org.geoserver.security.web.SecurityNamedServiceEditPage;
import org.geoserver.security.web.SecurityNamedServiceNewPage;
import org.geoserver.security.web.auth.AuthenticationPage;
import org.geoserver.security.web.auth.AuthenticationProviderPanel;
import org.geoserver.security.web.auth.UsernamePasswordAuthProviderPanelInfo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UsernamePasswordDetailsPanelTest
extends AbstractSecurityNamedServicePanelTest {
    @Override
    protected String getDetailsFormComponentId() {
        return "authenticationProviderPanel:namedConfig";
    }

    @Override
    protected AbstractSecurityPage getBasePage() {
        return new AuthenticationPage();
    }

    @Override
    protected String getBasePanelId() {
        return "form:authProviders";
    }

    @Override
    protected Integer getTabIndex() {
        return 2;
    }

    @Override
    protected Class<? extends Component> getNamedServicesClass() {
        return AuthenticationProviderPanel.class;
    }

    protected void setUGName(String serviceName) {
        this.formTester.setValue("panel:content:userGroupServiceName", serviceName);
    }

    protected String getUGServiceName() {
        return this.formTester.getForm().get("details:config.userGroupServiceName").getDefaultModelObjectAsString();
    }

    @Before
    public void clearAuthProvider() throws Exception {
        GeoServerSecurityManager secMgr = this.getSecurityManager();
        if (secMgr.listAuthenticationProviders().contains("default2")) {
            SecurityAuthProviderConfig config = secMgr.loadAuthenticationProviderConfig("default2");
            secMgr.removeAuthenticationProvider(config);
        }
    }

    @Test
    public void testAddModifyRemove() throws Exception {
        this.initializeForXML();
        this.activatePanel();
        Assert.assertEquals((long)1L, (long)this.countItems());
        Assert.assertNotNull((Object)this.getSecurityNamedServiceConfig("default"));
        Assert.assertNull((Object)this.getSecurityNamedServiceConfig("xxxxxxxx"));
        this.clickAddNew();
        tester.assertRenderedPage(SecurityNamedServiceNewPage.class);
        this.setSecurityConfigClassName(UsernamePasswordAuthProviderPanelInfo.class);
        this.newFormTester();
        this.setSecurityConfigName("default2");
        this.setUGName("default");
        this.clickCancel();
        tester.assertRenderedPage(this.basePage.getClass());
        Assert.assertEquals((long)1L, (long)this.countItems());
        Assert.assertNotNull((Object)this.getSecurityNamedServiceConfig("default"));
        this.clickAddNew();
        this.newFormTester();
        this.setSecurityConfigClassName(UsernamePasswordAuthProviderPanelInfo.class);
        this.newFormTester();
        this.setSecurityConfigName("default2");
        this.setUGName("default");
        tester.assertRenderedPage(SecurityNamedServiceNewPage.class);
        this.clickSave();
        tester.assertRenderedPage(this.basePage.getClass());
        Assert.assertEquals((long)2L, (long)this.countItems());
        Assert.assertNotNull((Object)this.getSecurityNamedServiceConfig("default"));
        UsernamePasswordAuthenticationProviderConfig authConfig = (UsernamePasswordAuthenticationProviderConfig)this.getSecurityNamedServiceConfig("default2");
        Assert.assertNotNull((Object)authConfig);
        Assert.assertEquals((Object)"default2", (Object)authConfig.getName());
        Assert.assertEquals((Object)UsernamePasswordAuthenticationProvider.class.getName(), (Object)authConfig.getClassName());
        Assert.assertEquals((Object)"default", (Object)authConfig.getUserGroupServiceName());
        authConfig = (UsernamePasswordAuthenticationProviderConfig)this.getSecurityManager().loadAuthenticationProviderConfig("default2");
        Assert.assertNotNull((Object)authConfig);
        Assert.assertEquals((Object)"default2", (Object)authConfig.getName());
        Assert.assertEquals((Object)UsernamePasswordAuthenticationProvider.class.getName(), (Object)authConfig.getClassName());
        Assert.assertEquals((Object)"default", (Object)authConfig.getUserGroupServiceName());
        this.clickAddNew();
        this.newFormTester();
        this.setSecurityConfigClassName(UsernamePasswordAuthProviderPanelInfo.class);
        this.newFormTester();
        this.setSecurityConfigName("default2");
        this.setUGName("default");
        this.clickSave();
        tester.assertRenderedPage(SecurityNamedServiceNewPage.class);
        this.testErrorMessagesWithRegExp(".*default2.*");
        this.clickCancel();
        tester.assertRenderedPage(this.basePage.getClass());
        this.clickNamedServiceConfig("default");
        tester.assertRenderedPage(SecurityNamedServiceEditPage.class);
        tester.debugComponentTrees();
        this.newFormTester("panel:panel:form");
        this.formTester.setValue("panel:userGroupServiceName", "test");
        this.clickCancel();
        tester.assertRenderedPage(this.basePage.getClass());
        authConfig = (UsernamePasswordAuthenticationProviderConfig)this.getSecurityNamedServiceConfig("default");
        Assert.assertEquals((Object)"default", (Object)authConfig.getUserGroupServiceName());
        this.clickNamedServiceConfig("default2");
        this.newFormTester("panel:panel:form");
        this.formTester.setValue("panel:userGroupServiceName", "test");
        this.clickSave();
        tester.assertRenderedPage(this.basePage.getClass());
        authConfig = (UsernamePasswordAuthenticationProviderConfig)this.getSecurityNamedServiceConfig("default2");
        Assert.assertEquals((Object)"test", (Object)authConfig.getUserGroupServiceName());
        authConfig = (UsernamePasswordAuthenticationProviderConfig)this.getSecurityManager().loadAuthenticationProviderConfig("default2");
        Assert.assertEquals((Object)"test", (Object)authConfig.getUserGroupServiceName());
    }

    @Test
    public void testMultipleAuthProviders() throws Exception {
        this.initializeForXML();
        this.activatePanel();
        Assert.assertNotNull((Object)this.getSecurityNamedServiceConfig("default"));
        Assert.assertNull((Object)this.getSecurityNamedServiceConfig("xxxxxxxx"));
        this.clickAddNew();
        tester.assertRenderedPage(SecurityNamedServiceNewPage.class);
        this.setSecurityConfigClassName(UsernamePasswordAuthProviderPanelInfo.class);
        this.newFormTester();
        this.setSecurityConfigName("default_001");
        this.setUGName("default");
        this.clickCancel();
        tester.assertRenderedPage(this.basePage.getClass());
        Assert.assertEquals((long)1L, (long)this.countItems());
        Assert.assertNotNull((Object)this.getSecurityNamedServiceConfig("default"));
        this.clickAddNew();
        this.newFormTester();
        this.setSecurityConfigClassName(UsernamePasswordAuthProviderPanelInfo.class);
        this.newFormTester();
        this.setSecurityConfigName("default_001");
        this.setUGName("default");
        tester.assertRenderedPage(SecurityNamedServiceNewPage.class);
        this.clickSave();
        this.clickAddNew();
        tester.assertRenderedPage(SecurityNamedServiceNewPage.class);
        this.setSecurityConfigClassName(UsernamePasswordAuthProviderPanelInfo.class);
        this.newFormTester();
        this.setSecurityConfigName("default_002");
        this.setUGName("default");
        this.clickCancel();
        tester.assertRenderedPage(this.basePage.getClass());
        Assert.assertEquals((long)2L, (long)this.countItems());
        Assert.assertNotNull((Object)this.getSecurityNamedServiceConfig("default"));
        this.clickAddNew();
        this.newFormTester();
        this.setSecurityConfigClassName(UsernamePasswordAuthProviderPanelInfo.class);
        this.newFormTester();
        this.setSecurityConfigName("default_002");
        this.setUGName("default");
        tester.assertRenderedPage(SecurityNamedServiceNewPage.class);
        this.clickSave();
        this.clickNamedServiceConfig("default_001");
        tester.assertRenderedPage(SecurityNamedServiceEditPage.class);
        tester.debugComponentTrees();
        this.newFormTester("panel:panel:form");
        this.clickCancel();
        tester.assertRenderedPage(this.basePage.getClass());
        this.clickNamedServiceConfig("default_002");
        tester.assertRenderedPage(SecurityNamedServiceEditPage.class);
        tester.debugComponentTrees();
        this.newFormTester("panel:panel:form");
        this.clickCancel();
        tester.assertRenderedPage(this.basePage.getClass());
        this.doRemove(null, "default_001");
        this.doRemove(null, "default_002");
    }

    @Test
    public void testRemove() throws Exception {
        this.initializeForXML();
        UsernamePasswordAuthenticationProviderConfig config = new UsernamePasswordAuthenticationProviderConfig();
        config.setName("default2");
        config.setClassName(UsernamePasswordAuthenticationProvider.class.getCanonicalName());
        config.setUserGroupServiceName("default");
        this.getSecurityManager().saveAuthenticationProvider((SecurityAuthProviderConfig)config);
        this.activatePanel();
        this.doRemove(null, "default2");
        Assert.assertNull((Object)this.getSecurityManager().loadAuthenticationProvider("default2"));
    }
}

