/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import org.apache.wicket.Page;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.SettingsInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.admin.GlobalSettingsPage;
import org.geoserver.web.data.workspace.WorkspaceEditPage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RESTPanelTest
extends GeoServerWicketTestSupport {
    private WorkspaceInfo citeWorkspace;

    @Before
    public void init() {
        this.login();
        this.citeWorkspace = this.getCatalog().getWorkspaceByName(MockData.CITE_PREFIX);
        GeoServer gs = this.getGeoServer();
        SettingsInfo s = gs.getSettings(this.citeWorkspace);
        if (s != null) {
            gs.remove(s);
        }
        NamespaceInfo citeNS = this.getCatalog().getNamespaceByPrefix(MockData.CITE_PREFIX);
        citeNS.setURI(MockData.CITE_URI);
        this.getCatalog().save(citeNS);
    }

    @Test
    public void testRootSettingOnWorkSpace() {
        tester.startPage((Page)new WorkspaceEditPage(this.citeWorkspace));
        tester.assertRenderedPage(WorkspaceEditPage.class);
        tester.assertNoErrorMessage();
        FormTester form = tester.newFormTester("form");
        form.setValue("tabs:panel:settings:enabled", true);
        form.submit("save");
        tester.assertNoErrorMessage();
        GeoServer gs = this.getGeoServer();
        Assert.assertNotNull((Object)gs.getSettings(this.citeWorkspace));
        tester.startPage((Page)new WorkspaceEditPage(this.citeWorkspace));
        tester.assertRenderedPage(WorkspaceEditPage.class);
        String root = ((SystemTestData)this.getTestData()).getDataDirectoryRoot().getAbsolutePath();
        FormTester form2 = tester.newFormTester("form");
        form2.setValue("tabs:panel:settings:settingsContainer:otherSettings:extensions:0:content:rootdir", root);
        form2.submit("save");
        tester.assertNoErrorMessage();
        Assert.assertEquals((Object)gs.getSettings(this.citeWorkspace).getMetadata().get("root", String.class), (Object)root);
    }

    @Test
    public void testRootSettingOnGlobal() {
        tester.startPage((Page)new GlobalSettingsPage());
        tester.assertRenderedPage(GlobalSettingsPage.class);
        tester.assertNoErrorMessage();
        GeoServer gs = this.getGeoServer();
        String root = ((SystemTestData)this.getTestData()).getDataDirectoryRoot().getAbsolutePath();
        FormTester form = tester.newFormTester("form");
        form.setValue("extensions:0:content:rootdir", root);
        form.submit("submit");
        tester.assertNoErrorMessage();
        Assert.assertEquals((Object)gs.getGlobal().getSettings().getMetadata().get("root", String.class), (Object)root);
    }

    @Test
    public void testQuietSettingOnGlobal() {
        tester.startPage((Page)new GlobalSettingsPage());
        tester.assertRenderedPage(GlobalSettingsPage.class);
        tester.assertNoErrorMessage();
        GeoServer gs = this.getGeoServer();
        FormTester form = tester.newFormTester("form");
        form.setValue("extensions:0:content:quiet", false);
        form.submit("submit");
        tester.assertNoErrorMessage();
        Assert.assertEquals((Object)gs.getGlobal().getSettings().getMetadata().get("quietOnNotFound", Boolean.class), (Object)false);
        tester.startPage((Page)new GlobalSettingsPage());
        tester.assertRenderedPage(GlobalSettingsPage.class);
        tester.assertNoErrorMessage();
        gs = this.getGeoServer();
        form = tester.newFormTester("form");
        form.setValue("extensions:0:content:quiet", true);
        form.submit("submit");
        tester.assertNoErrorMessage();
        Assert.assertEquals((Object)gs.getGlobal().getSettings().getMetadata().get("quietOnNotFound", Boolean.class), (Object)true);
    }
}

