/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web;

import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.gwc.ConfigurableBlobStore;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.web.CachingOptionsPanel;
import org.geoserver.gwc.web.GWCServicesPanel;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.web.GeoServerBasePage;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.GeoserverAjaxSubmitLink;
import org.geoserver.web.wicket.GeoServerAjaxFormLink;
import org.geotools.image.io.ImageIOExt;
import org.geotools.util.logging.Logging;

public class GWCSettingsPage
extends GeoServerSecuredPage {
    private static final Logger LOGGER = Logging.getLogger(GWCSettingsPage.class);

    public GWCSettingsPage() {
        this.setHeaderPanel(this.headerPanel());
        GWC gwc = GWC.get();
        GWCConfig gwcConfig = gwc.getConfig().clone();
        Model formModel = new Model((Serializable)gwcConfig);
        final Form form = new Form("form", (IModel)formModel);
        this.add(new Component[]{form});
        GWCServicesPanel gwcServicesPanel = new GWCServicesPanel("gwcServicesPanel", (IModel<GWCConfig>)formModel);
        CachingOptionsPanel defaultCachingOptionsPanel = new CachingOptionsPanel("cachingOptionsPanel", (IModel<GWCConfig>)formModel);
        form.add(new Component[]{gwcServicesPanel});
        form.add(new Component[]{defaultCachingOptionsPanel});
        form.add(new Component[]{new Button("submit"){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                GWCSettingsPage.this.save((Form<GWCConfig>)form, true);
            }
        }});
        form.add(new Component[]{this.applyLink(form)});
        form.add(new Component[]{new GeoServerAjaxFormLink("cancel"){
            private static final long serialVersionUID = 1L;

            protected void onClick(AjaxRequestTarget target, Form form) {
                GWCSettingsPage.this.doReturn();
            }
        }});
        this.checkWarnings();
    }

    public void save(Form<GWCConfig> form, boolean doReturn) {
        GWC gwc = GWC.get();
        IModel gwcConfigModel = form.getModel();
        GWCConfig gwcConfig = (GWCConfig)gwcConfigModel.getObject();
        try {
            gwc.saveConfig(gwcConfig);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error saving GWC config", e);
            form.error((Serializable)((Object)("Error saving GWC config: " + e.getMessage())));
            return;
        }
        ConfigurableBlobStore blobstore = (ConfigurableBlobStore)GeoServerExtensions.bean(ConfigurableBlobStore.class);
        if (blobstore != null) {
            blobstore.setChanged(gwcConfig, false);
        }
        if (doReturn) {
            this.doReturn();
        }
    }

    private GeoserverAjaxSubmitLink applyLink(final Form form) {
        return new GeoserverAjaxSubmitLink("apply", form, (GeoServerBasePage)this){

            protected void onError(AjaxRequestTarget target) {
                super.onError(target);
                target.add(new Component[]{form});
            }

            protected void onSubmitInternal(AjaxRequestTarget target) {
                try {
                    Form cast = form;
                    GWCSettingsPage.this.save((Form<GWCConfig>)cast, false);
                }
                catch (IllegalArgumentException e) {
                    form.error((Serializable)((Object)e.getMessage()));
                    target.add(new Component[]{form});
                }
            }
        };
    }

    private void checkWarnings() {
        Long imageIOFileCachingThreshold = ImageIOExt.getFilesystemThreshold();
        if (null == imageIOFileCachingThreshold || 0L >= imageIOFileCachingThreshold) {
            String warningMsg = new ResourceModel("GWC.ImageIOFileCachingThresholdUnsetWarning").getObject();
            super.warn((Serializable)((Object)warningMsg));
        }
    }

    protected Component headerPanel() {
        Fragment header = new Fragment("headerPanel", "header", (MarkupContainer)this);
        return header;
    }

    static CheckBox checkbox(String id, IModel<Boolean> model, String titleKey) {
        CheckBox checkBox = new CheckBox(id, model);
        if (null != titleKey) {
            AttributeModifier attributeModifier = new AttributeModifier("title", (IModel)new StringResourceModel(titleKey, null, null));
            checkBox.add(new Behavior[]{attributeModifier});
        }
        return checkBox;
    }
}

