/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.layer;

import java.io.Serializable;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.GWCSynchEnv;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.layer.GeoServerTileLayerInfoImpl;
import org.geoserver.gwc.layer.TileLayerInfoUtil;
import org.geoserver.gwc.web.layer.GeoServerTileLayerInfoModel;
import org.geoserver.gwc.web.layer.LayerEditCacheOptionsTabPanelInfo;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class LayerEditCacheOptionsTabPanelInfoTest {
    LayerEditCacheOptionsTabPanelInfo panelInfo;
    GWCConfig defaults;
    GWC gwc;
    GWCSynchEnv synchEnv;
    IModel<? extends ResourceInfo> resourceModel;
    LayerInfo layer;
    IModel<LayerInfo> layerModel;

    @Before
    public void setUpInternal() throws Exception {
        this.panelInfo = new LayerEditCacheOptionsTabPanelInfo();
        this.gwc = (GWC)Mockito.mock(GWC.class);
        this.synchEnv = (GWCSynchEnv)Mockito.mock(GWCSynchEnv.class);
        GWC.set((GWC)this.gwc, (GWCSynchEnv)this.synchEnv);
        this.defaults = GWCConfig.getOldDefaults();
        Mockito.when((Object)this.gwc.getConfig()).thenReturn((Object)this.defaults);
        FeatureTypeInfo resource = (FeatureTypeInfo)Mockito.mock(FeatureTypeInfo.class);
        Mockito.when((Object)resource.prefixedName()).thenReturn((Object)"topp:states");
        this.layer = (LayerInfo)Mockito.mock(LayerInfo.class);
        Mockito.when((Object)this.layer.getResource()).thenReturn((Object)resource);
        MetadataMap mdm = new MetadataMap();
        Mockito.when((Object)this.layer.getMetadata()).thenReturn((Object)mdm);
        this.resourceModel = new Model((Serializable)resource);
        this.layerModel = new Model((Serializable)this.layer);
    }

    @After
    public void tearDown() {
        GWC.set(null, null);
    }

    @Test
    public void testCreateOwnModelNew() {
        boolean isNew = true;
        GeoServerTileLayerInfoModel ownModel = this.panelInfo.createOwnModel(this.layerModel, true);
        Assert.assertNotNull((Object)ownModel);
        GeoServerTileLayerInfoImpl expected = TileLayerInfoUtil.loadOrCreate((LayerInfo)this.layer, (GWCConfig)this.defaults);
        Assert.assertEquals((Object)expected, (Object)ownModel.getObject());
    }

    @Test
    public void testCreateOwnModelExisting() {
        boolean isNew = false;
        GeoServerTileLayerInfoModel ownModel = this.panelInfo.createOwnModel(this.layerModel, false);
        Assert.assertNotNull((Object)ownModel);
        GeoServerTileLayerInfoImpl expected = TileLayerInfoUtil.loadOrCreate((LayerInfo)this.layer, (GWCConfig)this.defaults);
        Assert.assertEquals((Object)expected, (Object)ownModel.getObject());
        GeoServerTileLayer tileLayer = (GeoServerTileLayer)Mockito.mock(GeoServerTileLayer.class);
        expected = new GeoServerTileLayerInfoImpl();
        expected.setEnabled(true);
        Mockito.when((Object)tileLayer.getInfo()).thenReturn((Object)expected);
        Mockito.when((Object)this.gwc.getTileLayer((CatalogInfo)ArgumentMatchers.same((Object)this.layer))).thenReturn((Object)tileLayer);
        ownModel = this.panelInfo.createOwnModel(this.layerModel, false);
        Assert.assertEquals((Object)expected, (Object)ownModel.getObject());
    }

    @Test
    public void testCreateOwnModelExistingWithEnabledFalse() {
        boolean isNew = false;
        GeoServerTileLayerInfoModel ownModel = this.panelInfo.createOwnModel(this.layerModel, false);
        Assert.assertNotNull((Object)ownModel);
        GeoServerTileLayerInfoImpl expected = TileLayerInfoUtil.loadOrCreate((LayerInfo)this.layer, (GWCConfig)this.defaults);
        Assert.assertEquals((Object)expected, (Object)ownModel.getObject());
        GeoServerTileLayer tileLayer = (GeoServerTileLayer)Mockito.mock(GeoServerTileLayer.class);
        expected = new GeoServerTileLayerInfoImpl();
        expected.setEnabled(false);
        Mockito.when((Object)tileLayer.getInfo()).thenReturn((Object)expected);
        Mockito.when((Object)this.gwc.getTileLayer((CatalogInfo)ArgumentMatchers.same((Object)this.layer))).thenReturn((Object)tileLayer);
        ownModel = this.panelInfo.createOwnModel(this.layerModel, false);
        Assert.assertEquals((Object)expected, (Object)ownModel.getObject());
    }
}

