/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.layer;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.tester.TagTester;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.web.layer.CachedLayersPage;
import org.geoserver.gwc.web.layer.ConfigureCachedLayerAjaxLink;
import org.geoserver.gwc.web.layer.LayerCacheOptionsTabPanel;
import org.geoserver.gwc.web.layer.TileLayerDetachableModel;
import org.geoserver.ows.URLMangler;
import org.geoserver.platform.GeoServerExtensionsHelper;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.data.layergroup.LayerGroupEditPage;
import org.geowebcache.layer.TileLayer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class CachedLayersPageTest
extends GeoServerWicketTestSupport {
    @Rule
    public GeoServerExtensionsHelper.ExtensionsHelperRule extensions = new GeoServerExtensionsHelper.ExtensionsHelperRule();
    protected static final String NATURE_GROUP = "nature";

    @Before
    public void loginBefore() {
        super.login();
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog catalog = this.getCatalog();
        LayerGroupInfo group = catalog.getFactory().createLayerGroup();
        LayerInfo lakes = catalog.getLayerByName(this.getLayerId(MockData.LAKES));
        LayerInfo forests = catalog.getLayerByName(this.getLayerId(MockData.FORESTS));
        if (lakes != null && forests != null) {
            group.setName(NATURE_GROUP);
            group.getLayers().add(lakes);
            group.getLayers().add(forests);
            CatalogBuilder cb = new CatalogBuilder(catalog);
            cb.calculateLayerGroupBounds(group);
            catalog.add(group);
        }
    }

    @Test
    public void testPageLoad() {
        CachedLayersPage page = new CachedLayersPage();
        tester.startPage((Page)page);
        tester.assertRenderedPage(CachedLayersPage.class);
        List scripts = TagTester.createTags((String)tester.getLastResponseAsString(), tag -> tag.getName().equalsIgnoreCase("script"), (boolean)false).stream().map(tag -> tag.getAttribute("src")).collect(Collectors.toList());
        String regex = "^.*/" + CachedLayersPage.class.getName() + "/" + CachedLayersPage.class.getSimpleName() + ".*\\.js$";
        MatcherAssert.assertThat(scripts, (Matcher)Matchers.hasItem((Matcher)Matchers.matchesRegex((String)regex)));
    }

    @Test
    public void testLayerGroupLink() {
        GWC gwc = GWC.get();
        TileLayer tileLayer = gwc.getTileLayerByName(NATURE_GROUP);
        Assert.assertNotNull((Object)tileLayer);
        tester.startComponentInPage((Component)new ConfigureCachedLayerAjaxLink("test", (IModel)new TileLayerDetachableModel(tileLayer.getName()), null));
        tester.executeAjaxEvent("test:link", "click");
        tester.assertNoErrorMessage();
        tester.assertRenderedPage(LayerGroupEditPage.class);
    }

    @Test
    public void testNoMangleSeedLink() {
        CachedLayersPage page = new CachedLayersPage();
        tester.startPage((Page)page);
        tester.assertModelValue("table:listContainer:items:1:itemProperties:7:component:seedLink", (Object)"http://localhost/context/gwc/rest/seed/cgf:Polygons");
    }

    @Test
    public void testMangleSeedLink() {
        URLMangler testMangler = (base, path, map, type) -> {
            base.setLength(0);
            base.append("http://rewrite/");
        };
        this.extensions.singleton("testMangler", (Object)testMangler, new Class[]{URLMangler.class});
        CachedLayersPage page = new CachedLayersPage();
        tester.startPage((Page)page);
        tester.assertModelValue("table:listContainer:items:1:itemProperties:7:component:seedLink", (Object)"http://rewrite/gwc/rest/seed/cgf:Polygons");
    }

    @Test
    public void testNoManglePreviewLink() {
        CachedLayersPageTest.assertPreviewLinks("http://localhost/context/cgf/gwc/demo/cgf");
    }

    @Test
    public void testManglePreviewLink() {
        URLMangler testMangler = (base, path, map, type) -> {
            base.setLength(0);
            base.append("http://rewrite/");
        };
        this.extensions.singleton("testMangler", (Object)testMangler, new Class[]{URLMangler.class});
        CachedLayersPageTest.assertPreviewLinks("http://rewrite/gwc/demo/cgf");
    }

    private static void assertPreviewLinks(String url) {
        CachedLayersPage page = new CachedLayersPage();
        tester.startPage((Page)page);
        List tags = TagTester.createTags((String)tester.getLastResponseAsString(), tag -> {
            String value = tag.getAttributes().getString("value");
            return value != null && value.startsWith(url);
        }, (boolean)false);
        Assert.assertEquals((String)("Incorrect number of preview links starting with " + url), (long)20L, (long)tags.size());
    }

    @Test
    public void testAutoTileCachingTabSelection() {
        CachedLayersPage page = new CachedLayersPage();
        tester.startPage((Page)page);
        tester.assertRenderedPage(CachedLayersPage.class);
        tester.clickLink("table:listContainer:items:1:itemProperties:1:component:link", true);
        tester.assertComponent("publishedinfo:tabs:panel", LayerCacheOptionsTabPanel.class);
    }

    @Test
    public void testGWCClean() {
        CachedLayersPage page = new CachedLayersPage();
        tester.startPage((Page)page);
        tester.assertRenderedPage(CachedLayersPage.class);
        tester.clickLink("headerPanel:clearGwcLink", true);
        tester.assertVisible("dialog");
        tester.clickLink("dialog:dialog:modal:overlay:dialog:content:content:form:submit", true);
        tester.assertNoErrorMessage();
    }
}

