/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.gridset;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.Session;
import org.apache.wicket.ajax.AjaxRequestHandler;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.web.gridset.GridSetNewPage;
import org.geoserver.gwc.web.gridset.TileMatrixSetEditor;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.data.store.panel.TextParamPanel;
import org.geoserver.web.wicket.CRSPanel;
import org.geoserver.web.wicket.DecimalTextField;
import org.geoserver.web.wicket.EnvelopePanel;
import org.geoserver.web.wicket.GeoServerAjaxFormLink;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GridSetNewPageTest
extends GeoServerWicketTestSupport {
    @Before
    public void loginBefore() {
        super.login();
    }

    @Test
    public void testPageLoad() {
        GridSetNewPage page = new GridSetNewPage(new PageParameters());
        tester.startPage((Page)page);
        tester.assertRenderedPage(GridSetNewPage.class);
        tester.assertComponent("gridSetForm", Form.class);
        tester.assertComponent("gridSetForm:feedback", FeedbackPanel.class);
        tester.assertComponent("gridSetForm:name", TextParamPanel.class);
        tester.assertComponent("gridSetForm:description", TextArea.class);
        tester.assertComponent("gridSetForm:crs", CRSPanel.class);
        tester.assertComponent("gridSetForm:bounds", EnvelopePanel.class);
        tester.assertComponent("gridSetForm:tileMatrixSetEditor", TileMatrixSetEditor.class);
        tester.assertComponent("gridSetForm:cancel", BookmarkablePageLink.class);
        tester.assertComponent("gridSetForm:save", AjaxSubmitLink.class);
        tester.assertComponent("gridSetForm:addZoomLevel", GeoServerAjaxFormLink.class);
    }

    @Test
    public void testCreateFromTemplate() {
        PageParameters params = new PageParameters().add("template", (Object)"EPSG:4326");
        GridSetNewPage page = new GridSetNewPage(params);
        tester.startPage((Page)page);
        tester.assertModelValue("gridSetForm:name:border:border_body:paramValue", (Object)"My_EPSG:4326");
        FormTester ft = tester.newFormTester("gridSetForm");
        ft.setValue("name:border:border_body:paramValue", "customWGS84");
        tester.executeAjaxEvent("gridSetForm:addZoomLevel", "click");
        tester.executeAjaxEvent("gridSetForm:addZoomLevel", "click");
        tester.executeAjaxEvent("gridSetForm:save", "click");
        GWC mediator = GWC.get();
        GridSetBroker gridSetBroker = mediator.getGridSetBroker();
        Assert.assertTrue((String)gridSetBroker.getNames().toString(), (boolean)gridSetBroker.getNames().contains("customWGS84"));
        GridSet check = gridSetBroker.get("EPSG:4326");
        GridSet created = gridSetBroker.get("customWGS84");
        Assert.assertEquals((long)(check.getNumLevels() + 2), (long)created.getNumLevels());
    }

    @Test
    public void testCreateFromScratch() {
        GWC mediator = GWC.get();
        GridSetBroker gridSetBroker = mediator.getGridSetBroker();
        GridSetNewPage page = new GridSetNewPage(new PageParameters());
        tester.startPage((Page)page);
        String gridsetName = "fromScratch";
        FormTester ft = tester.newFormTester("gridSetForm");
        ft.setValue("crs:srs", "EPSG:3857");
        tester.executeAjaxEvent("gridSetForm:crs:srs", "blur");
        Component computeBounds = tester.getComponentFromLastRenderedPage("gridSetForm:computeBounds");
        Assert.assertTrue((boolean)computeBounds.isEnabled());
        page.computeBounds();
        BoundingBox expected = gridSetBroker.get("EPSG:900913").getOriginalExtent();
        Double minx = (Double)((DecimalTextField)tester.getComponentFromLastRenderedPage("gridSetForm:bounds:minX")).getModelObject();
        Double miny = (Double)((DecimalTextField)tester.getComponentFromLastRenderedPage("gridSetForm:bounds:minY")).getModelObject();
        Double maxx = (Double)((DecimalTextField)tester.getComponentFromLastRenderedPage("gridSetForm:bounds:maxX")).getModelObject();
        Double maxy = (Double)((DecimalTextField)tester.getComponentFromLastRenderedPage("gridSetForm:bounds:maxY")).getModelObject();
        Assert.assertEquals((double)expected.getMinX(), (double)minx, (double)0.01);
        Assert.assertEquals((double)expected.getMinY(), (double)miny, (double)0.01);
        Assert.assertEquals((double)expected.getMaxX(), (double)maxx, (double)0.01);
        Assert.assertEquals((double)expected.getMaxY(), (double)maxy, (double)0.01);
        EnvelopePanel envPanel = (EnvelopePanel)tester.getComponentFromLastRenderedPage("gridSetForm:bounds");
        Assert.assertNotNull((Object)envPanel.getModelObject());
        ft.setValue("bounds:minX", "-1000000");
        ft.setValue("bounds:minY", "-1000000");
        ft.setValue("bounds:maxX", "1000000");
        ft.setValue("bounds:maxY", "1000000");
        ft.setValue("tileWidth:border:border_body:paramValue", "512");
        ft.setValue("tileHeight:border:border_body:paramValue", "512");
        int numLevels = 6;
        for (int i = 0; i < 6; ++i) {
            AjaxRequestHandler target = new AjaxRequestHandler((Page)page);
            page.addZoomLevel((AjaxRequestTarget)target);
        }
        ft.setValue("name:border:border_body:paramValue", "fromScratch");
        ft.setValue("description", "sample description");
        Session.get().getFeedbackMessages().clear();
        tester.executeAjaxEvent("gridSetForm:save", "click");
        tester.assertNoErrorMessage();
        Assert.assertTrue((String)gridSetBroker.getNames().toString(), (boolean)gridSetBroker.getNames().contains("fromScratch"));
        GridSet created = gridSetBroker.get("fromScratch");
        Assert.assertEquals((long)6L, (long)created.getNumLevels());
    }

    @Test
    public void testDuplicateNames() {
        PageParameters params = new PageParameters().add("template", (Object)"EPSG:4326");
        GridSetNewPage page = new GridSetNewPage(params);
        tester.startPage((Page)page);
        FormTester ft = tester.newFormTester("gridSetForm");
        ft.setValue("name:border:border_body:paramValue", "customWGS84");
        tester.executeAjaxEvent("gridSetForm:addZoomLevel", "click");
        tester.executeAjaxEvent("gridSetForm:addZoomLevel", "click");
        ft = tester.newFormTester("gridSetForm");
        ft.setValue("tileMatrixSetEditor:container:table:gridLevels:0:name", "AName");
        ft.setValue("tileMatrixSetEditor:container:table:gridLevels:1:name", "AName");
        ft.submit();
        tester.executeAjaxEvent("gridSetForm:save", "click");
        tester.assertErrorMessages(new Serializable[]{"Tile matrix names should not include duplicates, but the following were found: [AName]. Mind, if you left some names empty, GeoServer has automatically added in some names for you."});
    }
}

