/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.layer;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.util.convert.IConverter;
import org.geoserver.gwc.web.layer.AbstractParameterFilterSubform;
import org.geowebcache.filter.parameters.StringParameterFilter;

public class StringParameterFilterSubform
extends AbstractParameterFilterSubform<StringParameterFilter> {
    private static final long serialVersionUID = -3815153551079914831L;
    private static final IConverter<List<String>> CONVERT = new IConverter<List<String>>(){
        private static final long serialVersionUID = -7486127358227242772L;

        public List<String> convertToObject(String value, Locale locale) {
            if (value == null) {
                return null;
            }
            String[] strings = StringUtils.split((String)value, (String)"\r\n");
            return Arrays.asList(strings);
        }

        public String convertToString(List<String> value, Locale locale) {
            Iterator<String> i = value.iterator();
            StringBuilder sb = new StringBuilder();
            if (i.hasNext()) {
                sb.append(i.next());
            }
            while (i.hasNext()) {
                sb.append("\r\n");
                sb.append(i.next());
            }
            return sb.toString();
        }
    };

    public StringParameterFilterSubform(String id, IModel<StringParameterFilter> model) {
        super(id, model);
        TextField defaultValue = new TextField("defaultValue", (IModel)new PropertyModel(model, "defaultValue"));
        this.add(new Component[]{defaultValue});
        TextArea<List<String>> values = new TextArea<List<String>>("values", (IModel)new PropertyModel(model, "values")){
            private static final long serialVersionUID = 1L;

            public <S> IConverter<S> getConverter(Class<S> type) {
                if (List.class.isAssignableFrom(type)) {
                    return CONVERT;
                }
                return super.getConverter(type);
            }
        };
        values.setConvertEmptyInputStringToNull(false);
        this.add(new Component[]{values});
        this.addNormalize(model);
    }
}

