/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.gridset;

import java.util.List;
import org.geoserver.gwc.web.gridset.GridSetInfo;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.Grid;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetFactory;
import org.geowebcache.grid.SRS;

class GridSetBuilder {
    GridSetBuilder() {
    }

    public static GridSet build(GridSetInfo info) throws IllegalStateException {
        double[] scaleDenoms;
        double[] resolutions;
        SRS srs;
        String name = GridSetBuilder.checkNotNull(info.getName(), "Name is not set");
        CoordinateReferenceSystem crs = GridSetBuilder.checkNotNull(info.getCrs(), "CRS is not set");
        String epsgCode = GridSetBuilder.checkNotNull(CRS.toSRS((CoordinateReferenceSystem)crs, (boolean)false), "EPSG code not found for CRS");
        if (!epsgCode.startsWith("EPSG:")) {
            throw new IllegalStateException("EPSG code didn't resolve to a EPSG:XXX identifier: " + epsgCode);
        }
        try {
            srs = SRS.getSRS((String)epsgCode);
        }
        catch (GeoWebCacheException e) {
            throw new IllegalStateException(e.getMessage());
        }
        ReferencedEnvelope bounds = GridSetBuilder.checkNotNull(info.getBounds(), "Bounds not set");
        if (bounds.isNull()) {
            throw new IllegalArgumentException("Bounds can't be null");
        }
        if (bounds.getWidth() <= 0.0 || bounds.getHeight() <= 0.0) {
            throw new IllegalArgumentException("Bounds can't be empty. Witdh: " + bounds.getWidth() + ". Height: " + bounds.getHeight());
        }
        BoundingBox extent = new BoundingBox(bounds.getMinimum(0), bounds.getMinimum(1), bounds.getMaximum(0), bounds.getMaximum(1));
        boolean alignTopLeft = info.isAlignTopLeft();
        List<Grid> levels = GridSetBuilder.checkNotNull(info.getLevels(), "GridSet levels not set");
        if (info.isResolutionsPreserved()) {
            resolutions = GridSetBuilder.resolutions(levels);
            scaleDenoms = null;
        } else {
            resolutions = null;
            scaleDenoms = GridSetBuilder.scaleDenominators(levels);
        }
        String[] scaleNames = GridSetBuilder.scaleNames(levels);
        Double metersPerUnit = GridSetBuilder.checkNotNull(info.getMetersPerUnit(), "Meters per unit not set");
        double pixelSize = 2.8E-4;
        int tileWidth = info.getTileWidth();
        int tileHeight = info.getTileHeight();
        boolean yCoordinateFirst = false;
        try {
            CoordinateReferenceSystem crsNoForceOrder = CRS.decode((String)("urn:ogc:def:crs:" + epsgCode));
            yCoordinateFirst = CRS.getAxisOrder((CoordinateReferenceSystem)crsNoForceOrder) == CRS.AxisOrder.NORTH_EAST;
        }
        catch (FactoryException e) {
            throw new IllegalStateException("EPSG code didn't resolve to a EPSG:XXX identifier: " + epsgCode);
        }
        GridSet gridSet = GridSetFactory.createGridSet((String)name, (SRS)srs, (BoundingBox)extent, (boolean)alignTopLeft, (double[])resolutions, (double[])scaleDenoms, (Double)metersPerUnit, (double)2.8E-4, (String[])scaleNames, (int)tileWidth, (int)tileHeight, (boolean)yCoordinateFirst);
        gridSet.setDescription(info.getDescription());
        return gridSet;
    }

    private static String[] scaleNames(List<Grid> levels) {
        String[] scaleNames = new String[levels.size()];
        for (int i = 0; i < scaleNames.length; ++i) {
            scaleNames[i] = levels.get(i).getName();
        }
        return scaleNames;
    }

    private static double[] resolutions(List<Grid> levels) {
        double[] resolutions = new double[levels.size()];
        for (int i = 0; i < resolutions.length; ++i) {
            resolutions[i] = levels.get(i).getResolution();
        }
        return resolutions;
    }

    private static double[] scaleDenominators(List<Grid> levels) {
        double[] scales = new double[levels.size()];
        for (int i = 0; i < scales.length; ++i) {
            scales[i] = levels.get(i).getScaleDenominator();
        }
        return scales;
    }

    private static <T> T checkNotNull(T val, String msg) throws IllegalStateException {
        if (val == null) {
            throw new IllegalStateException(msg);
        }
        return val;
    }
}

