/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.layer;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.layer.CatalogConfiguration;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.layer.GeoServerTileLayerInfoImpl;
import org.geoserver.gwc.layer.TileLayerInfoUtil;
import org.geoserver.gwc.web.layer.GeoServerTileLayerEditor;
import org.geoserver.gwc.web.layer.GeoServerTileLayerInfoModel;
import org.geoserver.gwc.web.layer.LayerCacheOptionsTabPanel;
import org.geoserver.util.DimensionWarning;
import org.geoserver.web.ComponentBuilder;
import org.geoserver.web.FormTestPage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geowebcache.layer.TileLayer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LayerCacheOptionsTabPanelTest
extends GeoServerWicketTestSupport {
    private IModel<LayerInfo> layerModel;
    private GeoServerTileLayerInfoModel tileLayerModel;

    @Before
    public void setUpInternal() {
        LayerInfo layerInfo = this.getCatalog().getLayerByName(this.getLayerId(MockData.BUILDINGS));
        Assert.assertTrue((boolean)CatalogConfiguration.isLayerExposable((LayerInfo)layerInfo));
        GeoServerTileLayer tileLayer = GWC.get().getTileLayer((CatalogInfo)layerInfo);
        Assert.assertNotNull((Object)tileLayer);
        this.layerModel = new Model((Serializable)layerInfo);
        this.tileLayerModel = new GeoServerTileLayerInfoModel(tileLayer.getInfo(), false);
        tileLayer.getInfo().getMimeFormats().remove("foo/bar");
    }

    @Test
    public void testPageLoad() {
        tester.startPage((Page)new FormTestPage(new ComponentBuilder(){
            private static final long serialVersionUID = -5907648151984337786L;

            public Component buildComponent(String id) {
                return new LayerCacheOptionsTabPanel(id, LayerCacheOptionsTabPanelTest.this.layerModel, (IModel)LayerCacheOptionsTabPanelTest.this.tileLayerModel);
            }
        }));
        tester.assertComponent("form:panel", LayerCacheOptionsTabPanel.class);
        tester.assertComponent("form:panel:tileLayerEditor", GeoServerTileLayerEditor.class);
        tester.assertComponent("form:panel:tileLayerEditor:container:configs:inMemoryCached", CheckBox.class);
    }

    @Test
    public void testPageLoadForGeometrylessLayer() {
        LayerInfo geometryless = this.getCatalog().getLayerByName(super.getLayerId(MockData.GEOMETRYLESS));
        Assert.assertFalse((boolean)CatalogConfiguration.isLayerExposable((LayerInfo)geometryless));
        Assert.assertNull((Object)GWC.get().getTileLayer((CatalogInfo)geometryless));
        this.layerModel = new Model((Serializable)geometryless);
        GWCConfig saneDefaults = GWC.get().getConfig().saneConfig();
        GeoServerTileLayerInfoImpl tileLayerInfo = TileLayerInfoUtil.loadOrCreate((LayerInfo)geometryless, (GWCConfig)saneDefaults);
        this.tileLayerModel = new GeoServerTileLayerInfoModel((GeoServerTileLayerInfo)tileLayerInfo, false);
        tester.startPage((Page)new FormTestPage(new ComponentBuilder(){
            private static final long serialVersionUID = -5907648151984337786L;

            public Component buildComponent(String id) {
                return new LayerCacheOptionsTabPanel(id, LayerCacheOptionsTabPanelTest.this.layerModel, (IModel)LayerCacheOptionsTabPanelTest.this.tileLayerModel);
            }
        }));
        tester.assertComponent("form:panel", LayerCacheOptionsTabPanel.class);
        tester.assertComponent("form:panel:tileLayerEditor", Label.class);
    }

    @Test
    public void testSaveExisting() {
        tester.startPage((Page)new FormTestPage(new ComponentBuilder(){
            private static final long serialVersionUID = -6705646666953650890L;

            public Component buildComponent(String id) {
                return new LayerCacheOptionsTabPanel(id, LayerCacheOptionsTabPanelTest.this.layerModel, (IModel)LayerCacheOptionsTabPanelTest.this.tileLayerModel);
            }
        }));
        tester.assertComponent("form:panel", LayerCacheOptionsTabPanel.class);
        GeoServerTileLayerInfo info = (GeoServerTileLayerInfo)this.tileLayerModel.getObject();
        info.setEnabled(!info.isEnabled());
        LayerCacheOptionsTabPanel panel = (LayerCacheOptionsTabPanel)tester.getComponentFromLastRenderedPage("form:panel");
        panel.save();
        TileLayer tileLayer = GWC.get().getTileLayerByName(info.getName());
        GeoServerTileLayerInfo actual = ((GeoServerTileLayer)tileLayer).getInfo();
        Assert.assertEquals((Object)info.isEnabled(), (Object)actual.isEnabled());
    }

    @Test
    public void testSaveNew() {
        GWC mediator = GWC.get();
        mediator.removeTileLayers(Arrays.asList(((GeoServerTileLayerInfo)this.tileLayerModel.getObject()).getName()));
        Assert.assertNull((Object)mediator.getTileLayer((CatalogInfo)this.layerModel.getObject()));
        GeoServerTileLayerInfoImpl newInfo = TileLayerInfoUtil.loadOrCreate((LayerInfo)((LayerInfo)this.layerModel.getObject()), (GWCConfig)mediator.getConfig());
        this.tileLayerModel = new GeoServerTileLayerInfoModel((GeoServerTileLayerInfo)newInfo, true);
        tester.startPage((Page)new FormTestPage(new ComponentBuilder(){
            private static final long serialVersionUID = -6705646666953650890L;

            public Component buildComponent(String id) {
                return new LayerCacheOptionsTabPanel(id, LayerCacheOptionsTabPanelTest.this.layerModel, (IModel)LayerCacheOptionsTabPanelTest.this.tileLayerModel);
            }
        }));
        tester.assertComponent("form:panel", LayerCacheOptionsTabPanel.class);
        LayerCacheOptionsTabPanel panel = (LayerCacheOptionsTabPanel)tester.getComponentFromLastRenderedPage("form:panel");
        panel.save();
        Assert.assertNotNull((Object)this.tileLayerModel.getEnabled());
        Assert.assertTrue((boolean)this.tileLayerModel.getEnabled());
        Assert.assertNotNull((Object)mediator.getTileLayer((CatalogInfo)this.layerModel.getObject()));
    }

    @Test
    public void testDontSaveNew() throws IOException {
        GWC mediator = GWC.get();
        GeoServerTileLayer tileLayer = (GeoServerTileLayer)mediator.getTileLayerByName(((GeoServerTileLayerInfo)this.tileLayerModel.getObject()).getName());
        mediator.removeTileLayers(Arrays.asList(((GeoServerTileLayerInfo)this.tileLayerModel.getObject()).getName()));
        Assert.assertNull((Object)mediator.getTileLayer((CatalogInfo)this.layerModel.getObject()));
        GWCConfig config = mediator.getConfig();
        boolean defaultCaching = config.isCacheLayersByDefault();
        config.setCacheLayersByDefault(true);
        mediator.saveConfig(config);
        GeoServerTileLayerInfoImpl newInfo = TileLayerInfoUtil.loadOrCreate((LayerInfo)((LayerInfo)this.layerModel.getObject()), (GWCConfig)mediator.getConfig());
        this.tileLayerModel = new GeoServerTileLayerInfoModel((GeoServerTileLayerInfo)newInfo, true);
        tester.startPage((Page)new FormTestPage(new ComponentBuilder(){
            private static final long serialVersionUID = -6705646666953650890L;

            public Component buildComponent(String id) {
                return new LayerCacheOptionsTabPanel(id, LayerCacheOptionsTabPanelTest.this.layerModel, (IModel)LayerCacheOptionsTabPanelTest.this.tileLayerModel);
            }
        }));
        tester.assertComponent("form:panel", LayerCacheOptionsTabPanel.class);
        tester.isVisible("form:panel:tileLayerEditor:container:configs");
        FormTester formTester = tester.newFormTester("form");
        formTester.setValue("panel:tileLayerEditor:createTileLayer", false);
        tester.executeAjaxEvent("form:panel:tileLayerEditor:createTileLayer", "change");
        tester.isInvisible("form:panel:tileLayerEditor:container:configs");
        LayerCacheOptionsTabPanel panel = (LayerCacheOptionsTabPanel)tester.getComponentFromLastRenderedPage("form:panel");
        formTester.getForm().onFormSubmitted(null);
        panel.save();
        Assert.assertNotNull((Object)this.tileLayerModel.getEnabled());
        Assert.assertFalse((boolean)this.tileLayerModel.getEnabled());
        Assert.assertNull((Object)mediator.getTileLayer((CatalogInfo)this.layerModel.getObject()));
        config.setCacheLayersByDefault(defaultCaching);
        mediator.saveConfig(config);
        mediator.add(tileLayer);
    }

    @Test
    public void testRemoveExisting() {
        LayerInfo layerInfo = this.getCatalog().getLayerByName(this.getLayerId(MockData.LAKES));
        GeoServerTileLayer tileLayer = GWC.get().getTileLayer((CatalogInfo)layerInfo);
        Assert.assertNotNull((Object)tileLayer);
        this.layerModel = new Model((Serializable)layerInfo);
        this.tileLayerModel = new GeoServerTileLayerInfoModel(tileLayer.getInfo(), false);
        GWC mediator = GWC.get();
        Assert.assertNotNull((Object)mediator.getTileLayer((CatalogInfo)this.layerModel.getObject()));
        tester.startPage((Page)new FormTestPage(new ComponentBuilder(){
            private static final long serialVersionUID = -6705646666953650890L;

            public Component buildComponent(String id) {
                return new LayerCacheOptionsTabPanel(id, LayerCacheOptionsTabPanelTest.this.layerModel, (IModel)LayerCacheOptionsTabPanelTest.this.tileLayerModel);
            }
        }));
        tester.assertComponent("form:panel", LayerCacheOptionsTabPanel.class);
        FormTester formTester = tester.newFormTester("form");
        formTester.setValue("panel:tileLayerEditor:createTileLayer", false);
        formTester.submit();
        LayerCacheOptionsTabPanel panel = (LayerCacheOptionsTabPanel)tester.getComponentFromLastRenderedPage("form:panel");
        panel.save();
        Assert.assertNull((Object)mediator.getTileLayer((CatalogInfo)this.layerModel.getObject()));
    }

    @Test
    public void testAddNullFilter() {
        FormTestPage page = new FormTestPage(new ComponentBuilder(){
            private static final long serialVersionUID = -5907648151984337786L;

            public Component buildComponent(String id) {
                return new LayerCacheOptionsTabPanel(id, LayerCacheOptionsTabPanelTest.this.layerModel, (IModel)LayerCacheOptionsTabPanelTest.this.tileLayerModel);
            }
        });
        tester.startPage((Page)page);
        tester.assertComponent("form:panel:tileLayerEditor", GeoServerTileLayerEditor.class);
        tester.executeAjaxEvent("form:panel:tileLayerEditor:container:configs:parameterFilters:addFilter", "click");
        tester.assertComponent("form:panel:tileLayerEditor", GeoServerTileLayerEditor.class);
        tester.assertErrorMessages((Serializable[])new String[]{"Filter should not be empty"});
        FormTester form = tester.newFormTester("form");
        form.submit();
        tester.assertNoErrorMessage();
    }

    @Test
    public void testExtraFormat() {
        ((GeoServerTileLayerInfo)this.tileLayerModel.getObject()).getMimeFormats().add("foo/bar");
        tester.startPage((Page)new FormTestPage(new ComponentBuilder(){
            private static final long serialVersionUID = -6705646666953650890L;

            public Component buildComponent(String id) {
                return new LayerCacheOptionsTabPanel(id, LayerCacheOptionsTabPanelTest.this.layerModel, (IModel)LayerCacheOptionsTabPanelTest.this.tileLayerModel);
            }
        }));
        ListView component = (ListView)tester.getComponentFromLastRenderedPage("form:panel:tileLayerEditor:container:configs:cacheFormatsGroup:cacheFormats");
        HashSet formatsInUI = new HashSet();
        component.visitChildren(ListItem.class, (object, visit) -> formatsInUI.add(object.getDefaultModelObjectAsString()));
        MatcherAssert.assertThat(formatsInUI, (Matcher)Matchers.hasItem((Object)"foo/bar"));
    }

    @Test
    public void testSaveWarningSkips() {
        FormTestPage page = new FormTestPage((ComponentBuilder & Serializable)id -> new LayerCacheOptionsTabPanel(id, this.layerModel, (IModel)this.tileLayerModel));
        tester.startPage((Page)page);
        tester.assertComponent("form:panel:tileLayerEditor", GeoServerTileLayerEditor.class);
        FormTester ft = tester.newFormTester("form");
        String checksPath = "panel:tileLayerEditor:container:configs:warningSkips:warningSkipsGroup";
        ft.select(checksPath, 0);
        ft.select(checksPath, 2);
        ft.submit();
        tester.assertNoErrorMessage();
        GeoServerTileLayer tileLayer = (GeoServerTileLayer)GWC.get().getTileLayerByName(this.getLayerId(MockData.BUILDINGS));
        Assert.assertNotNull((Object)tileLayer);
        MatcherAssert.assertThat((Object)tileLayer.getInfo().getCacheWarningSkips(), (Matcher)Matchers.containsInAnyOrder((Object[])new DimensionWarning.WarningType[]{DimensionWarning.WarningType.Default, DimensionWarning.WarningType.FailedNearest}));
    }
}

