/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.blob;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.web.blob.BlobStorePage;
import org.geoserver.gwc.web.blob.FileBlobStorePanel;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geowebcache.config.BlobStoreInfo;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.config.FileBlobStoreInfo;
import org.geowebcache.layer.TileLayer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BlobStorePageTest
extends GeoServerWicketTestSupport {
    @Before
    public void loginBefore() {
        super.login();
    }

    @After
    public void cleanup() throws Exception {
        GWC.get().removeBlobStores(Arrays.asList("myblobstore", "yourblobstore"));
    }

    @Test
    public void testPage() {
        BlobStorePage page = new BlobStorePage();
        tester.startPage((Page)page);
        tester.assertRenderedPage(BlobStorePage.class);
        tester.assertComponent("selector", Form.class);
        tester.assertComponent("selector:typeOfBlobStore", DropDownChoice.class);
        tester.assertComponent("blobConfigContainer", MarkupContainer.class);
        tester.assertInvisible("blobConfigContainer:blobStoreForm");
        DropDownChoice typeOfBlobStore = (DropDownChoice)tester.getComponentFromLastRenderedPage("selector:typeOfBlobStore");
        Assert.assertEquals((long)1L, (long)typeOfBlobStore.getChoices().size());
        Assert.assertEquals((Object)"File BlobStore", (Object)typeOfBlobStore.getChoices().get(0).toString());
        this.executeAjaxEventBehavior("selector:typeOfBlobStore", "change", "0");
        tester.assertVisible("blobConfigContainer:blobStoreForm");
        tester.assertComponent("blobConfigContainer:blobStoreForm:blobSpecificPanel", FileBlobStorePanel.class);
    }

    @Test
    public void testNew() {
        BlobStorePage page = new BlobStorePage();
        tester.startPage((Page)page);
        this.executeAjaxEventBehavior("selector:typeOfBlobStore", "change", "0");
        FormTester formTester = tester.newFormTester("blobConfigContainer:blobStoreForm");
        formTester.setValue("name", "myblobstore");
        formTester.setValue("enabled", false);
        formTester.setValue("blobSpecificPanel:baseDirectory:fileInput:border:border_body:paramValue", "/mydir");
        tester.executeAjaxEvent("blobConfigContainer:blobStoreForm:save", "click");
        tester.assertNoErrorMessage();
        List blobStores = GWC.get().getBlobStores();
        BlobStoreInfo config = (BlobStoreInfo)blobStores.get(0);
        Assert.assertTrue((boolean)(config instanceof FileBlobStoreInfo));
        Assert.assertEquals((Object)"myblobstore", (Object)config.getName());
        Assert.assertEquals((Object)"/mydir", (Object)((FileBlobStoreInfo)config).getBaseDirectory());
        Assert.assertEquals((long)4096L, (long)((FileBlobStoreInfo)config).getFileSystemBlockSize());
    }

    @Test
    public void testModify() throws ConfigurationException {
        FileBlobStoreInfo fconfig = new FileBlobStoreInfo("myblobstore");
        fconfig.setFileSystemBlockSize(1024);
        fconfig.setBaseDirectory("/mydir");
        GWC.get().addBlobStore((BlobStoreInfo)fconfig);
        TileLayer layer = GWC.get().getTileLayerByName("cite:Lakes");
        layer.setBlobStoreId("myblobstore");
        GWC.get().save(layer);
        BlobStorePage page = new BlobStorePage((BlobStoreInfo)fconfig);
        tester.startPage((Page)page);
        tester.assertVisible("blobConfigContainer:blobStoreForm");
        tester.assertComponent("blobConfigContainer:blobStoreForm:blobSpecificPanel", FileBlobStorePanel.class);
        FormTester formTester = tester.newFormTester("blobConfigContainer:blobStoreForm");
        formTester.setValue("name", "yourblobstore");
        formTester.setValue("blobSpecificPanel:baseDirectory:fileInput:border:border_body:paramValue", "/yourdir");
        formTester.submit();
        tester.executeAjaxEvent("blobConfigContainer:blobStoreForm:save", "click");
        tester.assertNoErrorMessage();
        BlobStoreInfo config = (BlobStoreInfo)GWC.get().getBlobStores().get(0);
        Assert.assertTrue((boolean)(config instanceof FileBlobStoreInfo));
        Assert.assertEquals((Object)"yourblobstore", (Object)config.getName());
        Assert.assertEquals((Object)"/yourdir", (Object)((FileBlobStoreInfo)config).getBaseDirectory());
        layer = GWC.get().getTileLayerByName("cite:Lakes");
        Assert.assertEquals((Object)"yourblobstore", (Object)layer.getBlobStoreId());
    }

    @Test
    public void testNewDuplicate() throws ConfigurationException {
        FileBlobStoreInfo fconfig = new FileBlobStoreInfo("myblobstore");
        fconfig.setFileSystemBlockSize(1024);
        fconfig.setBaseDirectory("/mydir");
        GWC.get().addBlobStore((BlobStoreInfo)fconfig);
        TileLayer layer = GWC.get().getTileLayerByName("cite:Lakes");
        layer.setBlobStoreId("myblobstore");
        GWC.get().save(layer);
        BlobStorePage page = new BlobStorePage();
        tester.startPage((Page)page);
        this.print((Component)page, true, true, true);
        this.executeAjaxEventBehavior("selector:typeOfBlobStore", "change", "0");
        this.print((Component)tester.getLastRenderedPage(), true, true);
        FormTester formTester = tester.newFormTester("blobConfigContainer:blobStoreForm");
        formTester.setValue("name", "myblobstore");
        formTester.setValue("enabled", false);
        formTester.setValue("blobSpecificPanel:baseDirectory:fileInput:border:border_body:paramValue", "/mydir");
        tester.executeAjaxEvent("blobConfigContainer:blobStoreForm:save", "click");
        tester.assertErrorMessages(new Serializable[]{"This identifier is already in use, please choose a unique one."});
        List blobStores = GWC.get().getBlobStores();
        BlobStoreInfo config = (BlobStoreInfo)blobStores.get(0);
        Assert.assertTrue((boolean)(config instanceof FileBlobStoreInfo));
        Assert.assertEquals((Object)"myblobstore", (Object)config.getName());
        Assert.assertEquals((Object)"/mydir", (Object)((FileBlobStoreInfo)config).getBaseDirectory());
        Assert.assertEquals((long)1024L, (long)((FileBlobStoreInfo)config).getFileSystemBlockSize());
    }

    @Test
    public void testModifyWithoutRename() throws ConfigurationException {
        FileBlobStoreInfo fconfig = new FileBlobStoreInfo("myblobstore");
        fconfig.setFileSystemBlockSize(1024);
        fconfig.setBaseDirectory("/mydir");
        GWC.get().addBlobStore((BlobStoreInfo)fconfig);
        TileLayer layer = GWC.get().getTileLayerByName("cite:Lakes");
        layer.setBlobStoreId("myblobstore");
        GWC.get().save(layer);
        BlobStorePage page = new BlobStorePage((BlobStoreInfo)fconfig);
        tester.startPage((Page)page);
        tester.assertVisible("blobConfigContainer:blobStoreForm");
        tester.assertComponent("blobConfigContainer:blobStoreForm:blobSpecificPanel", FileBlobStorePanel.class);
        FormTester formTester = tester.newFormTester("blobConfigContainer:blobStoreForm");
        formTester.setValue("name", "myblobstore");
        formTester.setValue("blobSpecificPanel:baseDirectory:fileInput:border:border_body:paramValue", "/yourdir");
        formTester.submit();
        tester.executeAjaxEvent("blobConfigContainer:blobStoreForm:save", "click");
        tester.assertNoErrorMessage();
        BlobStoreInfo config = (BlobStoreInfo)GWC.get().getBlobStores().get(0);
        Assert.assertTrue((boolean)(config instanceof FileBlobStoreInfo));
        Assert.assertEquals((Object)"myblobstore", (Object)config.getName());
        Assert.assertEquals((Object)"/yourdir", (Object)((FileBlobStoreInfo)config).getBaseDirectory());
        layer = GWC.get().getTileLayerByName("cite:Lakes");
        Assert.assertEquals((Object)"myblobstore", (Object)layer.getBlobStoreId());
    }

    @Test
    public void testLayout() throws ConfigurationException {
        for (FileBlobStoreInfo.PathGeneratorType type : FileBlobStoreInfo.PathGeneratorType.values()) {
            BlobStorePage page = new BlobStorePage();
            tester.startPage((Page)page);
            this.executeAjaxEventBehavior("selector:typeOfBlobStore", "change", "0");
            FormTester formTester = tester.newFormTester("blobConfigContainer:blobStoreForm");
            formTester.setValue("name", "myblobstore");
            formTester.setValue("enabled", false);
            formTester.setValue("blobSpecificPanel:baseDirectory:fileInput:border:border_body:paramValue", "/mydir");
            formTester.select("blobSpecificPanel:fileSystemLayout", type.ordinal());
            tester.executeAjaxEvent("blobConfigContainer:blobStoreForm:save", "click");
            tester.assertNoErrorMessage();
            List blobStores = GWC.get().getBlobStores();
            FileBlobStoreInfo config = (FileBlobStoreInfo)blobStores.get(0);
            Assert.assertEquals((Object)type, (Object)config.getPathGeneratorType());
            GWC.get().removeBlobStores(Arrays.asList(config.getName()));
        }
    }
}

