/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.gridset;

import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.measure.Unit;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.apache.wicket.validation.validator.RangeValidator;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.web.gridset.GridSetBuilder;
import org.geoserver.gwc.web.gridset.GridSetInfo;
import org.geoserver.gwc.web.gridset.GridSetsPage;
import org.geoserver.gwc.web.gridset.TileMatrixSetEditor;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.data.store.panel.TextParamPanel;
import org.geoserver.web.wicket.CRSPanel;
import org.geoserver.web.wicket.EnvelopePanel;
import org.geoserver.web.wicket.GeoServerAjaxFormLink;
import org.geoserver.web.wicket.SRSListPanel;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.cs.CoordinateSystemAxis;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;

abstract class AbstractGridSetPage
extends GeoServerSecuredPage {
    private static final long serialVersionUID = 2977633539319630433L;
    protected static final Logger LOGGER = Logging.getLogger(AbstractGridSetPage.class);
    public static final String GRIDSET_NAME = "gridSet";
    public static final String GRIDSET_TEMPLATE_NAME = "template";
    protected final Form<GridSetInfo> form;
    protected final TextParamPanel name;
    protected final Component description;
    protected final GridSetCRSPanel crs;
    protected final TextParamPanel tileWidth;
    protected final TextParamPanel tileHeight;
    protected final EnvelopePanel bounds;
    protected final Component computeBoundsLink;
    protected final Component cancelLink;
    protected final Component saveLink;
    protected final TileMatrixSetEditor tileMatrixSetEditor;
    protected final Component addLevelLink;
    protected final FeedbackPanel feedback;

    public AbstractGridSetPage(PageParameters parameters) {
        GridSetInfo gridsetInfo;
        String templateName;
        String gridSetName;
        if (parameters == null) {
            gridSetName = null;
            templateName = null;
        } else {
            gridSetName = parameters.get(GRIDSET_NAME).toOptionalString();
            templateName = parameters.get(GRIDSET_TEMPLATE_NAME).toOptionalString();
        }
        if (templateName != null) {
            gridsetInfo = this.getInfo(templateName);
            gridsetInfo.setName("My_" + gridsetInfo.getName());
            gridsetInfo.setInternal(false);
        } else {
            gridsetInfo = gridSetName != null ? this.getInfo(gridSetName) : this.getInfo(null);
        }
        Model model = new Model((Serializable)gridsetInfo);
        this.form = new Form("gridSetForm", (IModel)model);
        this.feedback = new FeedbackPanel("feedback");
        this.feedback.setOutputMarkupId(true);
        this.form.add(new Component[]{this.feedback});
        Component[] componentArray = new Component[1];
        this.name = this.name((IModel<GridSetInfo>)model);
        componentArray[0] = this.name;
        this.form.add(componentArray);
        this.description = new TextArea("description", (IModel)new PropertyModel((Object)model, "description"));
        this.form.add(new Component[]{this.description});
        Component[] componentArray2 = new Component[1];
        this.crs = this.crs((IModel<GridSetInfo>)model);
        componentArray2[0] = this.crs;
        this.form.add(componentArray2);
        Component[] componentArray3 = new Component[1];
        this.bounds = this.bounds((IModel<GridSetInfo>)model);
        componentArray3[0] = this.bounds;
        this.form.add(componentArray3);
        this.computeBoundsLink = this.computeBoundsLink(this.form);
        this.form.add(new Component[]{this.computeBoundsLink});
        Component[] componentArray4 = new Component[1];
        this.tileWidth = this.tileWidth((IModel<GridSetInfo>)model);
        componentArray4[0] = this.tileWidth;
        this.form.add(componentArray4);
        Component[] componentArray5 = new Component[1];
        this.tileHeight = this.tileHeight((IModel<GridSetInfo>)model);
        componentArray5[0] = this.tileHeight;
        this.form.add(componentArray5);
        Component[] componentArray6 = new Component[1];
        this.tileMatrixSetEditor = new TileMatrixSetEditor("tileMatrixSetEditor", (IModel<GridSetInfo>)model);
        componentArray6[0] = this.tileMatrixSetEditor;
        this.form.add(componentArray6);
        this.tileMatrixSetEditor.setOutputMarkupId(true);
        this.cancelLink = new BookmarkablePageLink("cancel", GridSetsPage.class);
        this.form.add(new Component[]{this.cancelLink});
        this.saveLink = this.saveLink(this.form);
        this.form.add(new Component[]{this.saveLink});
        this.add(new Component[]{this.form});
        this.tileWidth.getFormComponent().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("blur"){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                target.add(new Component[]{AbstractGridSetPage.this.tileMatrixSetEditor});
            }
        }});
        this.tileHeight.getFormComponent().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("blur"){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                target.add(new Component[]{AbstractGridSetPage.this.tileMatrixSetEditor});
            }
        }});
        this.addLevelLink = new GeoServerAjaxFormLink("addZoomLevel", this.form){
            private static final long serialVersionUID = 1202251941625034786L;

            protected void onClick(AjaxRequestTarget target, Form<?> form) {
                AbstractGridSetPage.this.crs.processInput();
                AbstractGridSetPage.this.bounds.processInput();
                AbstractGridSetPage.this.tileWidth.getFormComponent().processInput();
                AbstractGridSetPage.this.tileHeight.getFormComponent().processInput();
                AbstractGridSetPage.this.addZoomLevel(target);
                target.add(new Component[]{AbstractGridSetPage.this.tileMatrixSetEditor});
                target.add(new Component[]{AbstractGridSetPage.this.feedback});
            }
        };
        this.form.add(new Component[]{this.addLevelLink});
    }

    void addZoomLevel(AjaxRequestTarget target) {
        ReferencedEnvelope bbox = (ReferencedEnvelope)this.bounds.getModelObject();
        if (null == bbox) {
            String message = new StringResourceModel("AbstractGridSetPage.cantAddZoomLevel").getString();
            this.feedback.error((Serializable)((Object)message));
            return;
        }
        Integer width = (Integer)this.tileWidth.getFormComponent().getModelObject();
        Integer height = (Integer)this.tileHeight.getFormComponent().getModelObject();
        this.tileMatrixSetEditor.addZoomLevel(bbox, width == null ? 256 : width, height == null ? 256 : height);
    }

    private Component computeBoundsLink(Form<GridSetInfo> form) {
        GeoServerAjaxFormLink link = new GeoServerAjaxFormLink("computeBounds", form){
            private static final long serialVersionUID = 1L;

            protected void onClick(AjaxRequestTarget target, Form<?> form) {
                AbstractGridSetPage.this.crs.processInput();
                AbstractGridSetPage.this.computeBounds();
                target.add(new Component[]{AbstractGridSetPage.this.bounds});
                target.add(new Component[]{AbstractGridSetPage.this.feedback});
                target.add(new Component[]{AbstractGridSetPage.this.tileMatrixSetEditor});
            }
        };
        return link;
    }

    void computeBounds() {
        CoordinateReferenceSystem coordSys = (CoordinateReferenceSystem)this.crs.getModelObject();
        if (coordSys == null) {
            this.bounds.error((Serializable)((Object)new StringResourceModel("AbstractGridsetPage.computeBounds.crsNotSet").getString()));
            return;
        }
        GWC mediator = GWC.get();
        ReferencedEnvelope aov = mediator.getAreaOfValidity(coordSys);
        if (aov == null) {
            this.bounds.error((Serializable)((Object)new StringResourceModel("AbstractGridsetPage.computeBounds.aovNotSet").getString()));
        } else {
            this.bounds.setModelObject((Object)aov);
        }
    }

    private EnvelopePanel bounds(IModel<GridSetInfo> model) {
        PropertyModel boundsModel = new PropertyModel(model, "bounds");
        class UpdatingEnvelopePanel
        extends EnvelopePanel {
            private static final long serialVersionUID = 1L;

            public UpdatingEnvelopePanel(String id, IModel<ReferencedEnvelope> e) {
                super(id, e);
                class UpdateTableBehavior
                extends AjaxFormSubmitBehavior {
                    private static final long serialVersionUID = 1L;

                    public UpdateTableBehavior() {
                        super(AbstractGridSetPage.this.form, "blur");
                    }

                    protected void onSubmit(AjaxRequestTarget target) {
                        target.add(new Component[]{AbstractGridSetPage.this.tileMatrixSetEditor});
                    }

                    protected void onError(AjaxRequestTarget target) {
                        this.setModelObject(null);
                        target.add(new Component[]{AbstractGridSetPage.this.tileMatrixSetEditor});
                    }
                }
                this.minXInput.add(new Behavior[]{new UpdateTableBehavior()});
                this.minYInput.add(new Behavior[]{new UpdateTableBehavior()});
                this.minZInput.add(new Behavior[]{new UpdateTableBehavior()});
                this.maxXInput.add(new Behavior[]{new UpdateTableBehavior()});
                this.maxYInput.add(new Behavior[]{new UpdateTableBehavior()});
                this.maxZInput.add(new Behavior[]{new UpdateTableBehavior()});
            }
        }
        UpdatingEnvelopePanel panel = new UpdatingEnvelopePanel("bounds", (IModel<ReferencedEnvelope>)boundsModel);
        panel.setRequired(true);
        panel.setOutputMarkupId(true);
        return panel;
    }

    private TextParamPanel tileHeight(IModel<GridSetInfo> model) {
        TextParamPanel panel = new TextParamPanel("tileHeight", (IModel)new PropertyModel(model, "tileHeight"), (IModel)new StringResourceModel("AbstractGridSetPage.tileHeight"), true, new IValidator[]{new RangeValidator((Comparable)Integer.valueOf(16), (Comparable)Integer.valueOf(2048))});
        return panel;
    }

    private TextParamPanel tileWidth(IModel<GridSetInfo> model) {
        TextParamPanel panel = new TextParamPanel("tileWidth", (IModel)new PropertyModel(model, "tileWidth"), (IModel)new StringResourceModel("AbstractGridSetPage.tileWidth"), true, new IValidator[]{new RangeValidator((Comparable)Integer.valueOf(16), (Comparable)Integer.valueOf(2048))});
        return panel;
    }

    private GridSetCRSPanel crs(IModel<GridSetInfo> model) {
        GridSetCRSPanel crsPanel = new GridSetCRSPanel("crs", model);
        return crsPanel;
    }

    protected GridSet toGridSet(AjaxRequestTarget target, Form<?> form, GridSetInfo info) throws Exception {
        int i2;
        GridSet newGridset = GridSetBuilder.build(info);
        List names = IntStream.range(0, newGridset.getNumLevels()).mapToObj(i -> newGridset.getGrid(i).getName()).sorted().collect(Collectors.toList());
        LinkedHashSet<String> duplicates = new LinkedHashSet<String>();
        for (i2 = 1; i2 < names.size(); ++i2) {
            String prevName = (String)names.get(i2 - 1);
            if (!prevName.equals(names.get(i2))) continue;
            duplicates.add(prevName);
        }
        if (!duplicates.isEmpty()) {
            for (i2 = 0; i2 < newGridset.getNumLevels(); ++i2) {
                info.getLevels().get(i2).setName((String)names.get(i2));
            }
            throw new IllegalArgumentException("Tile matrix names should not include duplicates, but the following were found: " + duplicates + ". Mind, if you left some names empty, GeoServer has automatically added in some names for you.");
        }
        return newGridset;
    }

    private TextParamPanel name(IModel<GridSetInfo> model) {
        TextParamPanel namePanel = new TextParamPanel("name", (IModel)new PropertyModel(model, "name"), (IModel)new StringResourceModel("AbstractGridSetPage.name"), true, new IValidator[]{new UniqueNameValidator(((GridSetInfo)model.getObject()).getName())});
        return namePanel;
    }

    private GridSetInfo getInfo(String gridSetName) {
        GridSetInfo gridsetInfo;
        if (gridSetName == null) {
            gridsetInfo = new GridSetInfo();
        } else {
            GridSetBroker gridSetBroker = GWC.get().getGridSetBroker();
            GridSet gridSet = gridSetBroker.get(gridSetName);
            if (gridSet == null) {
                throw new IllegalArgumentException("Requested GridSet does not exist: '" + gridSetName + "'");
            }
            String name = gridSet.getName();
            boolean internal = GWC.get().isInternalGridSet(name);
            gridsetInfo = new GridSetInfo(gridSet, internal);
        }
        return gridsetInfo;
    }

    private Component saveLink(final Form<GridSetInfo> form) {
        return new AjaxSubmitLink("save", form){
            private static final long serialVersionUID = 1L;

            protected void onError(AjaxRequestTarget target) {
                super.onError(target);
                target.add(new Component[]{form});
            }

            protected void onSubmit(AjaxRequestTarget target) {
                AbstractGridSetPage.this.onSave(target, form);
            }
        };
    }

    protected abstract void onSave(AjaxRequestTarget var1, Form<?> var2);

    private static class UniqueNameValidator
    implements IValidator<String> {
        private static final long serialVersionUID = 1L;
        private final String previousName;

        public UniqueNameValidator(String previousName) {
            this.previousName = previousName;
        }

        public void validate(IValidatable<String> iv) {
            GridSet gridSet;
            String name = (String)iv.getValue();
            if (name.equals(this.previousName)) {
                return;
            }
            GridSetBroker gridSetBroker = GWC.get().getGridSetBroker();
            if (this.previousName != null) {
                gridSetBroker.get(this.previousName);
            }
            if ((gridSet = gridSetBroker.get(name)) != null) {
                ValidationError error = new ValidationError("gridSetAlreadyExists");
                error.setVariable("name", (Object)name);
                iv.error((IValidationError)error);
            }
        }
    }

    protected static class GridSetCRSPanel
    extends CRSPanel {
        private static final long serialVersionUID = 1L;
        private Label units;
        private Label metersPerUnit;
        private IModel<GridSetInfo> infoModel;

        public GridSetCRSPanel(String id, IModel<GridSetInfo> model) {
            super(id, (IModel)new PropertyModel(model, "crs"));
            this.infoModel = model;
            this.units = new Label("units", (IModel)new Model());
            this.metersPerUnit = new Label("metersPerUnit", (IModel)new Model());
            this.units.setOutputMarkupId(true);
            this.metersPerUnit.setOutputMarkupId(true);
            this.updateUnits((CoordinateReferenceSystem)this.getModelObject());
            this.add(new Component[]{this.units});
            this.add(new Component[]{this.metersPerUnit});
        }

        protected void onSRSUpdated(String srs, AjaxRequestTarget target) {
            target.add(new Component[]{this.units});
            target.add(new Component[]{this.metersPerUnit});
        }

        protected SRSListPanel srsListPanel() {
            SRSListPanel srsList = new SRSListPanel(this.popupWindow.getContentId()){
                private static final long serialVersionUID = 2869219395676091081L;

                protected void onCodeClicked(AjaxRequestTarget target, String epsgCode) {
                    popupWindow.close(target);
                    String srs = "EPSG:" + epsgCode;
                    srsTextField.setModelObject((Object)srs);
                    target.add(new Component[]{srsTextField});
                    CoordinateReferenceSystem crs = this.fromSRS(srs);
                    wktLabel.setDefaultModelObject((Object)crs.getName().toString());
                    wktLink.setEnabled(true);
                    target.add(new Component[]{wktLink});
                    this.updateUnits(crs);
                    target.add(new Component[]{units});
                    target.add(new Component[]{metersPerUnit});
                }
            };
            srsList.setCompactMode(true);
            return srsList;
        }

        public void convertInput() {
            try {
                super.convertInput();
            }
            finally {
                this.updateUnits();
            }
        }

        protected void onBeforeRender() {
            super.onBeforeRender();
        }

        private void updateUnits() {
            CoordinateReferenceSystem crs = (CoordinateReferenceSystem)this.getConvertedInput();
            this.updateUnits(crs);
        }

        private void updateUnits(CoordinateReferenceSystem crs) {
            if (crs == null) {
                this.units.setDefaultModelObject((Object)"--");
                this.metersPerUnit.setDefaultModelObject((Object)"--");
            } else {
                Double meters = ((GridSetInfo)this.infoModel.getObject()).getMetersPerUnit(crs);
                this.metersPerUnit.setDefaultModelObject((Object)String.valueOf(meters));
                CoordinateSystemAxis axis = crs.getCoordinateSystem().getAxis(0);
                Unit unit = axis.getUnit();
                String unitStr = unit.toString();
                this.units.setDefaultModelObject((Object)unitStr);
            }
        }
    }
}

