/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.wmts;

import org.apache.wicket.util.tester.FormTester;
import org.geoserver.gwc.web.wmts.WMTSAdminPage;
import org.geoserver.gwc.wmts.WMTSInfo;
import org.geoserver.web.GeoServerHomePage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

public class WMTSAdminPageTest
extends GeoServerWicketTestSupport {
    private WMTSInfo wmts;

    @Before
    public void beforeTest() throws Exception {
        this.wmts = (WMTSInfo)this.getGeoServerApplication().getGeoServer().getService(WMTSInfo.class);
        this.login();
    }

    @Test
    public void testPageStarts() throws Exception {
        tester.startPage(WMTSAdminPage.class);
        tester.assertModelValue("form:enabled", (Object)this.wmts.isEnabled());
        tester.assertModelValue("form:serviceTitleAndAbstract:title", (Object)this.wmts.getTitle());
        tester.assertModelValue("form:maintainer", (Object)this.wmts.getMaintainer());
        tester.assertModelValue("form:serviceTitleAndAbstract:abstract", (Object)this.wmts.getAbstract());
        tester.assertModelValue("form:accessConstraints", (Object)this.wmts.getAccessConstraints());
        tester.assertModelValue("form:fees", (Object)this.wmts.getFees());
        tester.assertModelValue("form:onlineResource", (Object)this.wmts.getOnlineResource());
    }

    @Test
    public void testFormSubmit() throws Exception {
        WMTSInfo wmtsInfo = (WMTSInfo)this.getGeoServerApplication().getGeoServer().getService(WMTSInfo.class);
        tester.startPage(WMTSAdminPage.class);
        FormTester formTester = tester.newFormTester("form");
        boolean citeCompliant = wmtsInfo.isCiteCompliant();
        formTester.setValue("citeCompliant", !citeCompliant);
        formTester.submit("submit");
        tester.assertNoErrorMessage();
        tester.assertRenderedPage(GeoServerHomePage.class);
        MatcherAssert.assertThat((Object)wmtsInfo.isCiteCompliant(), (Matcher)Matchers.is((Object)(!citeCompliant ? 1 : 0)));
    }
}

