/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.layer;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.gwc.web.layer.IntegerParameterFilterSubform;
import org.geoserver.web.ComponentBuilder;
import org.geoserver.web.FormTestPage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geowebcache.filter.parameters.IntegerParameterFilter;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

public class IntegerParameterFilterSubformTest
extends GeoServerWicketTestSupport {
    private IModel<IntegerParameterFilter> model;
    private IntegerParameterFilter pf;

    @Before
    public void setUpInternal() throws Exception {
        this.pf = new IntegerParameterFilter();
        this.pf.setKey("TEST");
        this.model = Model.of((Serializable)this.pf);
    }

    @Test
    public void testPageLoad() {
        this.startPage();
        tester.assertComponent("form:panel:defaultValue", AbstractTextComponent.class);
        tester.assertComponent("form:panel:values", AbstractTextComponent.class);
    }

    @Test
    public void testLoadDefaultValues() {
        this.startPage();
        AbstractTextComponent defaultValue = (AbstractTextComponent)tester.getComponentFromLastRenderedPage("form:panel:defaultValue");
        AbstractTextComponent values = (AbstractTextComponent)tester.getComponentFromLastRenderedPage("form:panel:values");
        MatcherAssert.assertThat((Object)defaultValue.getValue(), (Matcher)Matchers.equalTo((Object)""));
        MatcherAssert.assertThat((Object)values.getValue(), (Matcher)Matchers.equalTo((Object)""));
    }

    @Test
    public void testLoadSpecifiedValues() {
        this.pf.setDefaultValue("testDefault");
        this.pf.setValues(Arrays.asList(1, 2));
        this.startPage();
        AbstractTextComponent defaultValue = (AbstractTextComponent)tester.getComponentFromLastRenderedPage("form:panel:defaultValue");
        AbstractTextComponent values = (AbstractTextComponent)tester.getComponentFromLastRenderedPage("form:panel:values");
        MatcherAssert.assertThat((Object)defaultValue.getValue(), (Matcher)Matchers.equalTo((Object)"testDefault"));
        MatcherAssert.assertThat((Object)values.getValue(), (Matcher)Matchers.equalTo((Object)"1\r\n2"));
    }

    @Test
    public void testChange() {
        this.startPage();
        FormTester formTester = tester.newFormTester("form");
        formTester.setValue("panel:defaultValue", "testDefault");
        formTester.setValue("panel:values", "1\r\n2");
        formTester.submit();
        MatcherAssert.assertThat((Object)this.pf.getDefaultValue(), (Matcher)Matchers.equalTo((Object)"testDefault"));
        MatcherAssert.assertThat((Object)this.pf.getValues(), (Matcher)Matchers.contains((Object[])new Integer[]{1, 2}));
    }

    private void startPage() {
        tester.startPage((Page)new FormTestPage(new ComponentBuilder(){
            private static final long serialVersionUID = 1L;

            public Component buildComponent(String id) {
                return new IntegerParameterFilterSubform(id, IntegerParameterFilterSubformTest.this.model);
            }
        }));
    }
}

