/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.layer;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.GWCSynchEnv;
import org.geoserver.gwc.web.layer.CachedLayerProvider;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.test.GeoServerTestSupport;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.diskquota.DiskQuotaConfig;
import org.geowebcache.diskquota.DiskQuotaMonitor;
import org.geowebcache.layer.TileLayer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class CachedLayerProviderTest
extends GeoServerTestSupport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQuotaDisabledWithSystemVariable() throws IllegalAccessException {
        DiskQuotaMonitor monitor = (DiskQuotaMonitor)GeoServerExtensions.bean(DiskQuotaMonitor.class);
        Field enabledField = FieldUtils.getField(DiskQuotaMonitor.class, (String)"diskQuotaEnabled", (boolean)true);
        try {
            FieldUtils.writeField((Field)enabledField, (Object)monitor, (Object)false, (boolean)true);
            CachedLayerProvider provider = new CachedLayerProvider();
            List layers = provider.getItems();
            for (TileLayer tileLayer : layers) {
                Assert.assertNull((Object)CachedLayerProvider.QUOTA_USAGE.getPropertyValue((Object)tileLayer));
            }
        }
        finally {
            FieldUtils.writeField((Field)enabledField, (Object)monitor, (Object)true, (boolean)true);
        }
    }

    @Test
    public void testQuotaEnabled() throws ConfigurationException, IOException, InterruptedException {
        GWC gwc = GWC.get();
        DiskQuotaConfig config = gwc.getDiskQuotaConfig();
        config.setEnabled(Boolean.valueOf(true));
        gwc.saveDiskQuotaConfig(config, null);
        CachedLayerProvider provider = new CachedLayerProvider();
        List layers = provider.getItems();
        for (TileLayer tileLayer : layers) {
            Assert.assertNotNull((Object)CachedLayerProvider.QUOTA_USAGE.getPropertyValue((Object)tileLayer));
        }
    }

    @Test
    public void testQuotaDisabled() throws ConfigurationException, IOException, InterruptedException {
        GWC gwc = GWC.get();
        DiskQuotaConfig config = gwc.getDiskQuotaConfig();
        config.setEnabled(Boolean.valueOf(false));
        gwc.saveDiskQuotaConfig(config, null);
        CachedLayerProvider provider = new CachedLayerProvider();
        List layers = provider.getItems();
        for (TileLayer tileLayer : layers) {
            Assert.assertNull((Object)CachedLayerProvider.QUOTA_USAGE.getPropertyValue((Object)tileLayer));
        }
    }

    @Test
    public void testAdvertised() {
        GWC oldGWC = GWC.get();
        GWCSynchEnv oldGWCSynchEnv = GWC.get().getGwcSynchEnv();
        GWC gwc = (GWC)Mockito.mock(GWC.class);
        GWCSynchEnv synchEnv = (GWCSynchEnv)Mockito.mock(GWCSynchEnv.class);
        GWC.set((GWC)gwc, (GWCSynchEnv)synchEnv);
        TileLayer l = (TileLayer)Mockito.mock(TileLayer.class);
        Mockito.when((Object)l.isAdvertised()).thenReturn((Object)false);
        Set tileLayerNames = gwc.getTileLayerNames();
        tileLayerNames.add("testUnAdvertised");
        int gwcSize = tileLayerNames.size() - 1;
        Mockito.when((Object)gwc.getTileLayerNames()).thenReturn((Object)tileLayerNames);
        Mockito.when((Object)gwc.getTileLayerByName("testUnAdvertised")).thenReturn((Object)l);
        CachedLayerProvider provider = new CachedLayerProvider();
        int providerSize = provider.getItems().size();
        Assert.assertEquals((long)gwcSize, (long)providerSize);
        GWC.set((GWC)oldGWC, (GWCSynchEnv)oldGWCSynchEnv);
    }
}

